/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.nbbuild.extlibs;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.net.URLEncoder;

class MavenCoordinate {
    private final String groupId;
    private final String artifactId;
    private final String version;
    private final String extension;
    private final String classifier;

    private MavenCoordinate(String groupId, String artifactId, String version, String extension, String classifier) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.version = version;
        this.extension = extension;
        this.classifier = classifier;
    }

    public boolean hasClassifier() {
        return !this.classifier.isEmpty();
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getVersion() {
        return this.version;
    }

    public String getExtension() {
        return this.extension;
    }

    public String getClassifier() {
        return this.classifier;
    }

    public String toArtifactFilename() {
        return String.format("%s-%s%s.%s", this.getArtifactId(), this.getVersion(), this.hasClassifier() ? "-" + this.getClassifier() : "", this.getExtension());
    }

    public String toMavenPath() {
        return String.format("%s/%s/%s/%s", this.getGroupId().replace(".", "/"), this.getArtifactId(), this.getVersion(), this.toArtifactFilename());
    }

    public static boolean isMavenFile(String gradleFormat) {
        return gradleFormat.split(":").length > 2;
    }

    public static MavenCoordinate fromGradleFormat(String gradleFormat) {
        if (!MavenCoordinate.isMavenFile(gradleFormat)) {
            throw new IllegalArgumentException("Supplied string is not in gradle dependency format: " + gradleFormat);
        }
        String[] coordinateExtension = gradleFormat.split("@", 2);
        String coordinate = coordinateExtension[0];
        String extension = coordinateExtension.length > 1 && !coordinateExtension[1].trim().isEmpty() ? coordinateExtension[1] : "jar";
        String[] coordinates = coordinate.split(":");
        String group = coordinates[0];
        String artifact = coordinates[1];
        String version = coordinates[2];
        String classifier = "";
        if (coordinates.length > 3) {
            classifier = coordinates[3].trim();
        }
        return new MavenCoordinate(group, artifact, version, extension, classifier);
    }

    public static MavenCoordinate fromM2Url(URI m2Url) throws IOException {
        if (!"m2".equals(m2Url.getScheme())) {
            throw new IOException("Only m2 URL is supported: " + m2Url);
        }
        if (!m2Url.getRawPath().startsWith("/")) {
            throw new IOException("Invalid m2 URL. Expected format m2:/group:name:version:extension:classifier (classifier is optional)");
        }
        String[] coordinates = m2Url.getRawPath().substring(1).split(":");
        if (coordinates.length < 4) {
            throw new IOException("Invalid m2 URL. Expected format m2:/group:name:version:extension:classifier (classifier is optional)");
        }
        for (int i = 0; i < coordinates.length; ++i) {
            coordinates[i] = URLDecoder.decode(coordinates[i], "UTF-8");
        }
        String group = coordinates[0];
        String artifact = coordinates[1];
        String version = coordinates[2];
        String extension = coordinates[3];
        String classifier = "";
        if (coordinates.length > 4) {
            classifier = coordinates[4];
        }
        return new MavenCoordinate(group, artifact, version, extension, classifier);
    }

    public URI toM2Url() {
        try {
            return new URI(String.format("m2:/%s:%s:%s:%s%s", URLEncoder.encode(this.groupId, "UTF-8"), URLEncoder.encode(this.artifactId, "UTF-8"), URLEncoder.encode(this.version, "UTF-8"), URLEncoder.encode(this.extension, "UTF-8"), !this.classifier.isEmpty() ? ":" + URLEncoder.encode(this.classifier, "UTF-8") : ""));
        }
        catch (UnsupportedEncodingException | URISyntaxException ex) {
            throw new RuntimeException(ex);
        }
    }
}

