/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.shadowed.org.jline.utils;

import java.io.File;

public class OSUtils {
    public static final boolean IS_WINDOWS;
    public static final boolean IS_CYGWIN;
    @Deprecated
    public static final boolean IS_MINGW;
    public static final boolean IS_MSYSTEM;
    public static final boolean IS_WSL;
    public static final boolean IS_WSL1;
    public static final boolean IS_WSL2;
    public static final boolean IS_CONEMU;
    public static final boolean IS_OSX;
    public static String TTY_COMMAND;
    public static String STTY_COMMAND;
    public static String STTY_F_OPTION;
    public static String INFOCMP_COMMAND;
    public static String TEST_COMMAND;

    static {
        String test;
        String infocmp;
        String sttyfopt;
        String stty;
        String tty;
        IS_WINDOWS = System.getProperty("os.name").toLowerCase().contains("win");
        IS_CYGWIN = IS_WINDOWS && System.getenv("PWD") != null && System.getenv("PWD").startsWith("/");
        IS_MINGW = IS_WINDOWS && System.getenv("MSYSTEM") != null && System.getenv("MSYSTEM").startsWith("MINGW");
        IS_MSYSTEM = IS_WINDOWS && System.getenv("MSYSTEM") != null && (System.getenv("MSYSTEM").startsWith("MINGW") || System.getenv("MSYSTEM").equals("MSYS"));
        IS_WSL = System.getenv("WSL_DISTRO_NAME") != null;
        IS_WSL1 = IS_WSL && System.getenv("WSL_INTEROP") == null;
        IS_WSL2 = IS_WSL && !IS_WSL1;
        IS_CONEMU = IS_WINDOWS && System.getenv("ConEmuPID") != null;
        IS_OSX = System.getProperty("os.name").toLowerCase().contains("mac");
        if (IS_CYGWIN || IS_MSYSTEM) {
            tty = null;
            stty = null;
            sttyfopt = null;
            infocmp = null;
            test = null;
            String path = System.getenv("PATH");
            if (path != null) {
                String[] paths;
                for (String p : paths = path.split(";")) {
                    if (tty == null && new File(p, "tty.exe").exists()) {
                        tty = new File(p, "tty.exe").getAbsolutePath();
                    }
                    if (stty == null && new File(p, "stty.exe").exists()) {
                        stty = new File(p, "stty.exe").getAbsolutePath();
                    }
                    if (infocmp == null && new File(p, "infocmp.exe").exists()) {
                        infocmp = new File(p, "infocmp.exe").getAbsolutePath();
                    }
                    if (test != null || !new File(p, "test.exe").exists()) continue;
                    test = new File(p, "test.exe").getAbsolutePath();
                }
            }
            if (tty == null) {
                tty = "tty.exe";
            }
            if (stty == null) {
                stty = "stty.exe";
            }
            if (infocmp == null) {
                infocmp = "infocmp.exe";
            }
            if (test == null) {
                test = "test.exe";
            }
        } else {
            tty = "tty";
            stty = IS_OSX ? "/bin/stty" : "stty";
            sttyfopt = IS_OSX ? "-f" : "-F";
            infocmp = "infocmp";
            test = "/bin/test";
        }
        TTY_COMMAND = tty;
        STTY_COMMAND = stty;
        STTY_F_OPTION = sttyfopt;
        INFOCMP_COMMAND = infocmp;
        TEST_COMMAND = test;
    }
}

