/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.lsp.client.debugger;

import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.debugger.ActionsManager;
import org.netbeans.modules.lsp.client.debugger.DAPDebugger;
import org.netbeans.spi.debugger.ActionsProviderSupport;
import org.netbeans.spi.debugger.ContextProvider;
import org.openide.util.RequestProcessor;

public final class DAPActionsProvider
extends ActionsProviderSupport
implements ChangeListener {
    private static final Logger LOGGER = Logger.getLogger(DAPActionsProvider.class.getName());
    private static final Set<Object> ACTIONS = new HashSet<Object>();
    private static final Set<Object> ACTIONS_TO_DISABLE = new HashSet<Object>();
    private static final RequestProcessor ACTIONS_WORKER;
    private static RequestProcessor killRequestProcessor;
    private final DAPDebugger debugger;

    public DAPActionsProvider(ContextProvider contextProvider) {
        this.debugger = (DAPDebugger)contextProvider.lookupFirst(null, DAPDebugger.class);
        for (Object action : ACTIONS) {
            this.setEnabled(action, true);
        }
        this.debugger.addChangeListener(this);
    }

    public Set<Object> getActions() {
        return ACTIONS;
    }

    public void doAction(Object action) {
        LOGGER.log(Level.FINE, "DAPDebugger.doAction({0}), is kill = {1}", new Object[]{action, action == ActionsManager.ACTION_KILL});
        if (action == ActionsManager.ACTION_KILL) {
            this.debugger.finish();
        } else if (action == ActionsManager.ACTION_CONTINUE) {
            this.debugger.resume();
        } else if (action == ActionsManager.ACTION_STEP_OVER) {
            this.debugger.stepOver();
        } else if (action == ActionsManager.ACTION_STEP_INTO) {
            this.debugger.stepInto();
        } else if (action == ActionsManager.ACTION_STEP_OUT) {
            this.debugger.stepOut();
        } else if (action == ActionsManager.ACTION_PAUSE) {
            this.debugger.pause();
        }
    }

    public void postAction(final Object action, final Runnable actionPerformedNotifier) {
        this.setDebugActionsEnabled(false);
        ACTIONS_WORKER.post(new Runnable(){
            final /* synthetic */ DAPActionsProvider this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                try {
                    this.this$0.doAction(action);
                }
                finally {
                    actionPerformedNotifier.run();
                    this.this$0.setDebugActionsEnabled(true);
                }
            }
        });
    }

    private void setDebugActionsEnabled(boolean enabled) {
        if (!enabled) {
            for (Object action : ACTIONS_TO_DISABLE) {
                this.setEnabled(action, enabled);
            }
        } else {
            this.setEnabled(ActionsManager.ACTION_CONTINUE, this.debugger.isSuspended());
            this.setEnabled(ActionsManager.ACTION_PAUSE, !this.debugger.isSuspended());
            this.setEnabled(ActionsManager.ACTION_STEP_INTO, this.debugger.isSuspended());
            this.setEnabled(ActionsManager.ACTION_STEP_OUT, this.debugger.isSuspended());
            this.setEnabled(ActionsManager.ACTION_STEP_OVER, this.debugger.isSuspended());
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.setDebugActionsEnabled(true);
    }

    static {
        ACTIONS.add(ActionsManager.ACTION_KILL);
        ACTIONS.add(ActionsManager.ACTION_CONTINUE);
        ACTIONS.add(ActionsManager.ACTION_PAUSE);
        ACTIONS.add(ActionsManager.ACTION_START);
        ACTIONS.add(ActionsManager.ACTION_STEP_INTO);
        ACTIONS.add(ActionsManager.ACTION_STEP_OVER);
        ACTIONS.add(ActionsManager.ACTION_STEP_OUT);
        ACTIONS_TO_DISABLE.addAll(ACTIONS);
        ACTIONS_TO_DISABLE.remove(ActionsManager.ACTION_KILL);
        ACTIONS_WORKER = new RequestProcessor("DAP debugger actions RP", 1);
    }
}

