/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.spi.debugger.jpda;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Map;
import org.netbeans.api.debugger.jpda.JPDABreakpoint;
import org.netbeans.spi.debugger.ContextAwareService;
import org.netbeans.spi.debugger.ContextAwareSupport;
import org.netbeans.spi.debugger.ContextProvider;

public abstract class BreakpointsClassFilter {
    public abstract ClassNames filterClassNames(ClassNames var1, JPDABreakpoint var2);

    static class ContextAware
    extends BreakpointsClassFilter
    implements ContextAwareService<BreakpointsClassFilter> {
        private String serviceName;

        private ContextAware(String serviceName) {
            this.serviceName = serviceName;
        }

        public BreakpointsClassFilter forContext(ContextProvider context) {
            return (BreakpointsClassFilter)ContextAwareSupport.createInstance((String)this.serviceName, (ContextProvider)context);
        }

        @Override
        public ClassNames filterClassNames(ClassNames classNames, JPDABreakpoint breakpoint) {
            return classNames;
        }

        static ContextAwareService createService(Map attrs) throws ClassNotFoundException {
            String serviceName = (String)attrs.get("serviceName");
            return new ContextAware(serviceName);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @Target(value={ElementType.TYPE})
    public static @interface Registration {
        public String path() default "";
    }

    public static class ClassNames {
        private final String[] classNames;
        private final String[] excludedClassNames;

        public ClassNames(String[] classNames, String[] excludedClassNames) {
            this.classNames = classNames;
            this.excludedClassNames = excludedClassNames;
        }

        public String[] getClassNames() {
            return this.classNames;
        }

        public String[] getExcludedClassNames() {
            return this.excludedClassNames;
        }
    }
}

