/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.temporal;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.oracle.truffle.js.nodes.access.IsObjectNode;
import com.oracle.truffle.js.nodes.access.PropertyGetNode;
import com.oracle.truffle.js.nodes.cast.JSToStringNode;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSRealm;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalTimeZoneRecord;
import com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import com.oracle.truffle.js.runtime.objects.JSObject;
import com.oracle.truffle.js.runtime.util.TemporalConstants;
import com.oracle.truffle.js.runtime.util.TemporalErrors;
import com.oracle.truffle.js.runtime.util.TemporalUtil;

public abstract class ToTemporalTimeZoneNode
extends JavaScriptBaseNode {
    @Node.Child
    protected PropertyGetNode getTimeZoneNode;

    protected ToTemporalTimeZoneNode() {
    }

    public abstract JSDynamicObject execute(Object var1);

    @Specialization
    protected JSDynamicObject toTemporalTimeZone(Object temporalTimeZoneLikeParam, @Cached IsObjectNode isObjectNode, @Cached JSToStringNode toStringNode, @Cached InlinedBranchProfile errorBranch, @Cached InlinedConditionProfile parseNameEmpty, @Cached InlinedConditionProfile parseIsZ, @Cached InlinedConditionProfile isObjectProfile, @Cached InlinedConditionProfile isTimeZoneProfile, @Cached InlinedConditionProfile hasProperty1Profile, @Cached InlinedConditionProfile hasProperty2Profile) {
        Object temporalTimeZoneLike = temporalTimeZoneLikeParam;
        if (isObjectProfile.profile((Node)this, isObjectNode.executeBoolean(temporalTimeZoneLike))) {
            JSDynamicObject tzObj = (JSDynamicObject)((Object)temporalTimeZoneLike);
            if (isTimeZoneProfile.profile((Node)this, TemporalUtil.isTemporalZonedDateTime((Object)tzObj))) {
                return (JSDynamicObject)((Object)this.getTimeZone(tzObj));
            }
            if (hasProperty1Profile.profile((Node)this, !JSObject.hasProperty(tzObj, TemporalConstants.TIME_ZONE))) {
                return tzObj;
            }
            temporalTimeZoneLike = this.getTimeZone(tzObj);
            if (hasProperty2Profile.profile((Node)this, isObjectNode.executeBoolean(temporalTimeZoneLike) && !JSObject.hasProperty((JSDynamicObject)((Object)temporalTimeZoneLike), TemporalConstants.TIME_ZONE))) {
                return (JSDynamicObject)((Object)temporalTimeZoneLike);
            }
        }
        TruffleString identifier = toStringNode.executeString(temporalTimeZoneLike);
        JSTemporalTimeZoneRecord parseResult = TemporalUtil.parseTemporalTimeZoneString(identifier);
        JSContext ctx = this.getLanguage().getJSContext();
        JSRealm realm = this.getRealm();
        if (parseNameEmpty.profile((Node)this, parseResult.getName() != null)) {
            boolean canParse = TemporalUtil.canParseAsTimeZoneNumericUTCOffset(parseResult.getName());
            if (canParse) {
                if (parseResult.getOffsetString() != null && TemporalUtil.parseTimeZoneOffsetString(parseResult.getOffsetString()) != TemporalUtil.parseTimeZoneOffsetString(parseResult.getName())) {
                    errorBranch.enter((Node)this);
                    throw TemporalErrors.createRangeErrorInvalidTimeZoneString();
                }
            } else if (!TemporalUtil.isValidTimeZoneName(parseResult.getName())) {
                errorBranch.enter((Node)this);
                throw TemporalErrors.createRangeErrorInvalidTimeZoneString();
            }
            return TemporalUtil.createTemporalTimeZone(ctx, realm, TemporalUtil.canonicalizeTimeZoneName(parseResult.getName()));
        }
        if (parseIsZ.profile((Node)this, parseResult.isZ())) {
            return TemporalUtil.createTemporalTimeZone(ctx, realm, TemporalConstants.UTC);
        }
        return TemporalUtil.createTemporalTimeZone(ctx, realm, parseResult.getOffsetString());
    }

    private Object getTimeZone(JSDynamicObject obj) {
        if (this.getTimeZoneNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.getTimeZoneNode = (PropertyGetNode)this.insert(PropertyGetNode.create(TemporalConstants.TIME_ZONE, this.getLanguage().getJSContext()));
        }
        return this.getTimeZoneNode.getValue((Object)obj);
    }
}

