/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.builtins.temporal;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.js.builtins.JSBuiltinsContainer;
import com.oracle.truffle.js.builtins.temporal.JSTemporalBuiltinOperation;
import com.oracle.truffle.js.builtins.temporal.TemporalCalendarPrototypeBuiltinsFactory;
import com.oracle.truffle.js.nodes.access.EnumerableOwnPropertyNamesNode;
import com.oracle.truffle.js.nodes.access.GetIteratorNode;
import com.oracle.truffle.js.nodes.access.IteratorCloseNode;
import com.oracle.truffle.js.nodes.access.IteratorStepNode;
import com.oracle.truffle.js.nodes.access.IteratorValueNode;
import com.oracle.truffle.js.nodes.binary.JSIdenticalNode;
import com.oracle.truffle.js.nodes.cast.JSToIntegerOrInfinityNode;
import com.oracle.truffle.js.nodes.cast.JSToObjectNode;
import com.oracle.truffle.js.nodes.cast.JSToStringNode;
import com.oracle.truffle.js.nodes.function.JSBuiltin;
import com.oracle.truffle.js.nodes.function.JSBuiltinNode;
import com.oracle.truffle.js.nodes.temporal.TemporalGetOptionNode;
import com.oracle.truffle.js.nodes.temporal.ToTemporalDateNode;
import com.oracle.truffle.js.nodes.temporal.ToTemporalDurationNode;
import com.oracle.truffle.js.runtime.Boundaries;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSRealm;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.Strings;
import com.oracle.truffle.js.runtime.builtins.BuiltinEnum;
import com.oracle.truffle.js.runtime.builtins.temporal.ISODateRecord;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalCalendar;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalCalendarObject;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalDuration;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalDurationObject;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalDurationRecord;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalPlainDate;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalPlainDateObject;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalPlainDateTimeObject;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalPlainMonthDay;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalPlainMonthDayObject;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalPlainYearMonth;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalPlainYearMonthObject;
import com.oracle.truffle.js.runtime.builtins.temporal.TimeDurationRecord;
import com.oracle.truffle.js.runtime.objects.IteratorRecord;
import com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import com.oracle.truffle.js.runtime.util.TemporalConstants;
import com.oracle.truffle.js.runtime.util.TemporalErrors;
import com.oracle.truffle.js.runtime.util.TemporalUtil;
import java.util.ArrayList;
import java.util.EnumSet;

public class TemporalCalendarPrototypeBuiltins
extends JSBuiltinsContainer.SwitchEnum<TemporalCalendarPrototype> {
    public static final TemporalCalendarPrototypeBuiltins BUILTINS = new TemporalCalendarPrototypeBuiltins();

    protected TemporalCalendarPrototypeBuiltins() {
        super(JSTemporalCalendar.PROTOTYPE_NAME, TemporalCalendarPrototype.class);
    }

    @Override
    protected Object createNode(JSContext context, JSBuiltin builtin, boolean construct, boolean newTarget, TemporalCalendarPrototype builtinEnum) {
        switch (builtinEnum.ordinal()) {
            case 0: 
            case 20: 
            case 21: {
                return TemporalCalendarPrototypeBuiltinsFactory.JSTemporalCalendarGetterNodeGen.create(context, builtin, builtinEnum, TemporalCalendarPrototypeBuiltins.args().withThis().createArgumentNodes(context));
            }
            case 1: {
                return TemporalCalendarPrototypeBuiltinsFactory.JSTemporalCalendarMergeFieldsNodeGen.create(context, builtin, TemporalCalendarPrototypeBuiltins.args().withThis().fixedArgs(2).createArgumentNodes(context));
            }
            case 2: {
                return TemporalCalendarPrototypeBuiltinsFactory.JSTemporalCalendarFieldsNodeGen.create(context, builtin, TemporalCalendarPrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context));
            }
            case 3: {
                return TemporalCalendarPrototypeBuiltinsFactory.JSTemporalCalendarDateFromFieldsNodeGen.create(context, builtin, TemporalCalendarPrototypeBuiltins.args().withThis().fixedArgs(2).createArgumentNodes(context));
            }
            case 4: {
                return TemporalCalendarPrototypeBuiltinsFactory.JSTemporalCalendarYearMonthFromFieldsNodeGen.create(context, builtin, TemporalCalendarPrototypeBuiltins.args().withThis().fixedArgs(3).createArgumentNodes(context));
            }
            case 5: {
                return TemporalCalendarPrototypeBuiltinsFactory.JSTemporalCalendarMonthDayFromFieldsNodeGen.create(context, builtin, TemporalCalendarPrototypeBuiltins.args().withThis().fixedArgs(3).createArgumentNodes(context));
            }
            case 6: {
                return TemporalCalendarPrototypeBuiltinsFactory.JSTemporalCalendarDateAddNodeGen.create(context, builtin, TemporalCalendarPrototypeBuiltins.args().withThis().fixedArgs(4).createArgumentNodes(context));
            }
            case 7: {
                return TemporalCalendarPrototypeBuiltinsFactory.JSTemporalCalendarDateUntilNodeGen.create(context, builtin, TemporalCalendarPrototypeBuiltins.args().withThis().fixedArgs(3).createArgumentNodes(context));
            }
            case 8: {
                return TemporalCalendarPrototypeBuiltinsFactory.JSTemporalCalendarYearNodeGen.create(context, builtin, TemporalCalendarPrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context));
            }
            case 9: {
                return TemporalCalendarPrototypeBuiltinsFactory.JSTemporalCalendarMonthNodeGen.create(context, builtin, TemporalCalendarPrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context));
            }
            case 10: {
                return TemporalCalendarPrototypeBuiltinsFactory.JSTemporalCalendarMonthCodeNodeGen.create(context, builtin, TemporalCalendarPrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context));
            }
            case 11: {
                return TemporalCalendarPrototypeBuiltinsFactory.JSTemporalCalendarDayNodeGen.create(context, builtin, TemporalCalendarPrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context));
            }
            case 12: {
                return TemporalCalendarPrototypeBuiltinsFactory.JSTemporalCalendarDayOfWeekNodeGen.create(context, builtin, TemporalCalendarPrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context));
            }
            case 13: {
                return TemporalCalendarPrototypeBuiltinsFactory.JSTemporalCalendarDayOfYearNodeGen.create(context, builtin, TemporalCalendarPrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context));
            }
            case 15: {
                return TemporalCalendarPrototypeBuiltinsFactory.JSTemporalCalendarDaysInWeekNodeGen.create(context, builtin, TemporalCalendarPrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context));
            }
            case 14: {
                return TemporalCalendarPrototypeBuiltinsFactory.JSTemporalCalendarWeekOfYearNodeGen.create(context, builtin, TemporalCalendarPrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context));
            }
            case 16: {
                return TemporalCalendarPrototypeBuiltinsFactory.JSTemporalCalendarDaysInMonthNodeGen.create(context, builtin, TemporalCalendarPrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context));
            }
            case 17: {
                return TemporalCalendarPrototypeBuiltinsFactory.JSTemporalCalendarDaysInYearNodeGen.create(context, builtin, TemporalCalendarPrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context));
            }
            case 18: {
                return TemporalCalendarPrototypeBuiltinsFactory.JSTemporalCalendarMonthsInYearNodeGen.create(context, builtin, TemporalCalendarPrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context));
            }
            case 19: {
                return TemporalCalendarPrototypeBuiltinsFactory.JSTemporalCalendarInLeapYearNodeGen.create(context, builtin, TemporalCalendarPrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context));
            }
        }
        return null;
    }

    public static enum TemporalCalendarPrototype implements BuiltinEnum<TemporalCalendarPrototype>
    {
        id(0),
        mergeFields(2),
        fields(1),
        dateFromFields(1),
        yearMonthFromFields(1),
        monthDayFromFields(1),
        dateAdd(2),
        dateUntil(2),
        year(1),
        month(1),
        monthCode(1),
        day(1),
        dayOfWeek(1),
        dayOfYear(1),
        weekOfYear(1),
        daysInWeek(1),
        daysInMonth(1),
        daysInYear(1),
        monthsInYear(1),
        inLeapYear(1),
        toString(0),
        toJSON(0);

        private final int length;

        private TemporalCalendarPrototype(int length) {
            this.length = length;
        }

        @Override
        public int getLength() {
            return this.length;
        }

        @Override
        public boolean isGetter() {
            return EnumSet.of(id).contains(this);
        }
    }

    public static abstract class JSTemporalCalendarGetterNode
    extends JSBuiltinNode {
        protected final TemporalCalendarPrototype property;

        protected JSTemporalCalendarGetterNode(JSContext context, JSBuiltin builtin, TemporalCalendarPrototype property) {
            super(context, builtin);
            this.property = property;
        }

        @Specialization
        protected Object id(JSTemporalCalendarObject calendar, @Cached JSToStringNode toStringNode) {
            switch (this.property.ordinal()) {
                case 0: 
                case 20: {
                    return calendar.getId();
                }
                case 21: {
                    return toStringNode.executeString((Object)calendar);
                }
            }
            throw Errors.shouldNotReachHere();
        }

        @Specialization(guards={"!isJSTemporalCalendar(thisObj)"})
        protected static Object invalidReceiver(Object thisObj) {
            throw TemporalErrors.createTypeErrorTemporalCalendarExpected();
        }
    }

    public static abstract class JSTemporalCalendarMergeFields
    extends JSTemporalBuiltinOperation {
        protected JSTemporalCalendarMergeFields(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected JSDynamicObject mergeFields(JSTemporalCalendarObject calendar, Object fieldsParam, Object additionalFieldsParam, @Cached JSToObjectNode toObject, @Cached(value="createKeys(getContext())") EnumerableOwnPropertyNamesNode namesNode) {
            assert (calendar.getId().equals((Object)TemporalConstants.ISO8601));
            JSDynamicObject fields = (JSDynamicObject)((Object)toObject.execute(fieldsParam));
            JSDynamicObject additionalFields = (JSDynamicObject)((Object)toObject.execute(additionalFieldsParam));
            return TemporalUtil.defaultMergeFields(this.getContext(), this.getRealm(), fields, additionalFields, namesNode);
        }

        @Specialization(guards={"!isJSTemporalCalendar(thisObj)"})
        protected static Object invalidReceiver(Object thisObj, Object fieldsParam, Object additionalFieldsParam) {
            throw TemporalErrors.createTypeErrorTemporalCalendarExpected();
        }
    }

    public static abstract class JSTemporalCalendarFields
    extends JSTemporalBuiltinOperation {
        @Node.Child
        private IteratorCloseNode iteratorCloseNode;
        @Node.Child
        private IteratorValueNode getIteratorValueNode;
        @Node.Child
        private IteratorStepNode iteratorStepNode;

        protected void iteratorCloseAbrupt(Object iterator) {
            if (this.iteratorCloseNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.iteratorCloseNode = (IteratorCloseNode)this.insert(IteratorCloseNode.create(this.getContext()));
            }
            this.iteratorCloseNode.executeAbrupt(iterator);
        }

        protected Object getIteratorValue(Object iteratorResult) {
            if (this.getIteratorValueNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.getIteratorValueNode = (IteratorValueNode)this.insert(IteratorValueNode.create());
            }
            return this.getIteratorValueNode.execute(iteratorResult);
        }

        protected Object iteratorStep(IteratorRecord iterator) {
            if (this.iteratorStepNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.iteratorStepNode = (IteratorStepNode)this.insert(IteratorStepNode.create());
            }
            return this.iteratorStepNode.execute(iterator);
        }

        protected JSTemporalCalendarFields(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected JSDynamicObject fields(JSTemporalCalendarObject calendar, Object fieldsParam, @Cached(inline=true) GetIteratorNode getIteratorNode) {
            assert (calendar.getId().equals((Object)TemporalConstants.ISO8601));
            IteratorRecord iter = getIteratorNode.execute(this, fieldsParam);
            ArrayList<TruffleString> fieldNames = new ArrayList<TruffleString>();
            Object next = Boolean.TRUE;
            while (next != Boolean.FALSE) {
                next = this.iteratorStep(iter);
                if (next == Boolean.FALSE) continue;
                Object nextValue = this.getIteratorValue(next);
                if (!Strings.isTString(nextValue)) {
                    this.iteratorCloseAbrupt(iter.getIterator());
                    throw Errors.createTypeError("string expected");
                }
                TruffleString str = JSRuntime.toString(nextValue);
                if (str != null && Boundaries.listContains(fieldNames, str)) {
                    this.iteratorCloseAbrupt(iter.getIterator());
                    throw Errors.createRangeError("");
                }
                if (!(TemporalConstants.YEAR.equals((Object)str) || TemporalConstants.MONTH.equals((Object)str) || TemporalConstants.MONTH_CODE.equals((Object)str) || TemporalConstants.DAY.equals((Object)str) || TemporalConstants.HOUR.equals((Object)str) || TemporalConstants.MINUTE.equals((Object)str) || TemporalConstants.SECOND.equals((Object)str) || TemporalConstants.MILLISECOND.equals((Object)str) || TemporalConstants.MICROSECOND.equals((Object)str) || TemporalConstants.NANOSECOND.equals((Object)str))) {
                    this.iteratorCloseAbrupt(iter.getIterator());
                    throw Errors.createRangeError("");
                }
                fieldNames.add(str);
            }
            return JSRuntime.createArrayFromList(this.getContext(), this.getRealm(), fieldNames);
        }

        @Specialization(guards={"!isJSTemporalCalendar(thisObj)"})
        protected static Object invalidReceiver(Object thisObj, Object fieldsParam) {
            throw TemporalErrors.createTypeErrorTemporalCalendarExpected();
        }
    }

    public static abstract class JSTemporalCalendarDateFromFields
    extends JSTemporalBuiltinOperation {
        protected JSTemporalCalendarDateFromFields(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected Object dateFromFields(JSTemporalCalendarObject calendar, Object fields, Object optionsParam, @Cached(value="createSameValue()") JSIdenticalNode identicalNode, @Cached TemporalGetOptionNode getOptionNode, @Cached JSToIntegerOrInfinityNode toIntOrInfinityNode, @Cached InlinedBranchProfile errorBranch, @Cached InlinedConditionProfile optionUndefined) {
            assert (calendar.getId().equals((Object)TemporalConstants.ISO8601));
            if (!this.isObject(fields)) {
                errorBranch.enter((Node)this);
                throw TemporalErrors.createTypeErrorFieldsNotAnObject();
            }
            JSDynamicObject options = this.getOptionsObject(optionsParam, this, errorBranch, optionUndefined);
            ISODateRecord result = TemporalUtil.isoDateFromFields((JSDynamicObject)((Object)fields), options, this.getContext(), this.isObjectNode, getOptionNode, toIntOrInfinityNode, identicalNode);
            return JSTemporalPlainDate.create(this.getContext(), this.getRealm(), result.year(), result.month(), result.day(), calendar, this, errorBranch);
        }

        @Specialization(guards={"!isJSTemporalCalendar(thisObj)"})
        protected static Object invalidReceiver(Object thisObj, Object fields, Object optionsParam) {
            throw TemporalErrors.createTypeErrorTemporalCalendarExpected();
        }
    }

    public static abstract class JSTemporalCalendarYearMonthFromFields
    extends JSTemporalBuiltinOperation {
        protected JSTemporalCalendarYearMonthFromFields(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected Object yearMonthFromFields(JSTemporalCalendarObject calendar, Object fields, Object optionsParam, @Cached(value="createSameValue()") JSIdenticalNode identicalNode, @Cached TemporalGetOptionNode getOptionNode, @Cached JSToIntegerOrInfinityNode toIntOrInfinityNode, @Cached InlinedBranchProfile errorBranch, @Cached InlinedConditionProfile optionUndefined) {
            assert (calendar.getId().equals((Object)TemporalConstants.ISO8601));
            if (!this.isObject(fields)) {
                errorBranch.enter((Node)this);
                throw TemporalErrors.createTypeErrorFieldsNotAnObject();
            }
            JSDynamicObject options = this.getOptionsObject(optionsParam, this, errorBranch, optionUndefined);
            ISODateRecord result = TemporalUtil.isoYearMonthFromFields((JSDynamicObject)((Object)fields), options, this.getContext(), this.isObjectNode, getOptionNode, toIntOrInfinityNode, identicalNode);
            return JSTemporalPlainYearMonth.create(this.getContext(), this.getRealm(), result.year(), result.month(), calendar, result.day(), this, errorBranch);
        }

        @Specialization(guards={"!isJSTemporalCalendar(thisObj)"})
        protected static Object invalidReceiver(Object thisObj, Object fields, Object optionsParam) {
            throw TemporalErrors.createTypeErrorTemporalCalendarExpected();
        }
    }

    public static abstract class JSTemporalCalendarMonthDayFromFields
    extends JSTemporalBuiltinOperation {
        protected JSTemporalCalendarMonthDayFromFields(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected Object monthDayFromFields(JSTemporalCalendarObject calendar, Object fields, Object optionsParam, @Cached(value="createSameValue()") JSIdenticalNode identicalNode, @Cached TemporalGetOptionNode getOptionNode, @Cached JSToIntegerOrInfinityNode toIntOrInfinityNode, @Cached InlinedBranchProfile errorBranch, @Cached InlinedConditionProfile optionUndefined) {
            assert (calendar.getId().equals((Object)TemporalConstants.ISO8601));
            if (!this.isObject(fields)) {
                errorBranch.enter((Node)this);
                throw TemporalErrors.createTypeErrorFieldsNotAnObject();
            }
            JSDynamicObject options = this.getOptionsObject(optionsParam, this, errorBranch, optionUndefined);
            ISODateRecord result = TemporalUtil.isoMonthDayFromFields((JSDynamicObject)((Object)fields), options, this.getContext(), this.isObjectNode, getOptionNode, toIntOrInfinityNode, identicalNode);
            return JSTemporalPlainMonthDay.create(this.getContext(), this.getRealm(), result.month(), result.day(), calendar, result.year(), this, errorBranch);
        }

        @Specialization(guards={"!isJSTemporalCalendar(thisObj)"})
        protected static Object invalidReceiver(Object thisObj, Object fields, Object optionsParam) {
            throw TemporalErrors.createTypeErrorTemporalCalendarExpected();
        }
    }

    public static abstract class JSTemporalCalendarDateAdd
    extends JSTemporalBuiltinOperation {
        protected JSTemporalCalendarDateAdd(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected Object dateAdd(JSTemporalCalendarObject calendar, Object dateObj, Object durationObj, Object optionsParam, @Cached ToTemporalDurationNode toTemporalDurationNode, @Cached ToTemporalDateNode toTemporalDate, @Cached TemporalGetOptionNode getOptionNode, @Cached InlinedBranchProfile errorBranch, @Cached InlinedConditionProfile optionUndefined) {
            assert (calendar.getId().equals((Object)TemporalConstants.ISO8601));
            JSTemporalPlainDateObject date = toTemporalDate.execute(dateObj);
            JSTemporalDurationObject duration = toTemporalDurationNode.execute(durationObj);
            JSDynamicObject options = this.getOptionsObject(optionsParam, this, errorBranch, optionUndefined);
            TemporalUtil.Overflow overflow = TemporalUtil.toTemporalOverflow(options, getOptionNode);
            JSRealm realm = this.getRealm();
            TimeDurationRecord balanceResult = TemporalUtil.balanceTimeDuration(duration.getDays(), duration.getHours(), duration.getMinutes(), duration.getSeconds(), duration.getMilliseconds(), duration.getMicroseconds(), duration.getNanoseconds(), TemporalUtil.Unit.DAY);
            ISODateRecord result = TemporalUtil.addISODate(date.getYear(), date.getMonth(), date.getDay(), duration.getYears(), duration.getMonths(), duration.getWeeks(), balanceResult.days(), overflow);
            return JSTemporalPlainDate.create(this.getContext(), realm, result.year(), result.month(), result.day(), calendar, this, errorBranch);
        }

        @Specialization(guards={"!isJSTemporalCalendar(thisObj)"})
        protected static Object invalidReceiver(Object thisObj, Object dateObj, Object durationObj, Object optionsParam) {
            throw TemporalErrors.createTypeErrorTemporalCalendarExpected();
        }
    }

    public static abstract class JSTemporalCalendarDateUntil
    extends JSTemporalBuiltinOperation {
        protected JSTemporalCalendarDateUntil(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected Object dateUntil(JSTemporalCalendarObject calendar, Object oneObj, Object twoObj, Object optionsParam, @Cached ToTemporalDateNode toTemporalDate, @Cached TruffleString.EqualNode equalNode, @Cached TemporalGetOptionNode getOptionNode, @Cached InlinedBranchProfile errorBranch, @Cached InlinedConditionProfile optionUndefined) {
            assert (calendar.getId().equals((Object)TemporalConstants.ISO8601));
            JSTemporalPlainDateObject one = toTemporalDate.execute(oneObj);
            JSTemporalPlainDateObject two = toTemporalDate.execute(twoObj);
            JSDynamicObject options = this.getOptionsObject(optionsParam, this, errorBranch, optionUndefined);
            TemporalUtil.Unit largestUnit = JSTemporalCalendarDateUntil.toLargestTemporalUnit(options, TemporalUtil.listTime, TemporalConstants.AUTO, TemporalUtil.Unit.DAY, equalNode, getOptionNode, this, errorBranch);
            JSTemporalDurationRecord result = JSTemporalPlainDate.differenceISODate(one.getYear(), one.getMonth(), one.getDay(), two.getYear(), two.getMonth(), two.getDay(), largestUnit);
            return JSTemporalDuration.createTemporalDuration(this.getContext(), this.getRealm(), result.getYears(), result.getMonths(), result.getWeeks(), result.getDays(), 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, this, errorBranch);
        }

        @Specialization(guards={"!isJSTemporalCalendar(thisObj)"})
        protected static Object invalidReceiver(Object thisObj, Object oneObj, Object twoObj, Object optionsParam) {
            throw TemporalErrors.createTypeErrorTemporalCalendarExpected();
        }
    }

    public static abstract class JSTemporalCalendarYear
    extends JSTemporalBuiltinOperation {
        protected JSTemporalCalendarYear(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected long year(JSTemporalCalendarObject calendar, Object temporalDateLike, @Cached ToTemporalDateNode toTemporalDate) {
            int year;
            assert (calendar.getId().equals((Object)TemporalConstants.ISO8601));
            if (temporalDateLike instanceof JSTemporalPlainDateObject) {
                JSTemporalPlainDateObject date = (JSTemporalPlainDateObject)((Object)temporalDateLike);
                year = date.getYear();
            } else if (temporalDateLike instanceof JSTemporalPlainDateTimeObject) {
                JSTemporalPlainDateTimeObject dateTime = (JSTemporalPlainDateTimeObject)((Object)temporalDateLike);
                year = dateTime.getYear();
            } else if (temporalDateLike instanceof JSTemporalPlainYearMonthObject) {
                JSTemporalPlainYearMonthObject yearMonth = (JSTemporalPlainYearMonthObject)((Object)temporalDateLike);
                year = yearMonth.getYear();
            } else {
                JSTemporalPlainDateObject date = toTemporalDate.execute(temporalDateLike);
                year = date.getYear();
            }
            return year;
        }

        @Specialization(guards={"!isJSTemporalCalendar(thisObj)"})
        protected static Object invalidReceiver(Object thisObj, Object temporalDateLike) {
            throw TemporalErrors.createTypeErrorTemporalCalendarExpected();
        }
    }

    public static abstract class JSTemporalCalendarMonth
    extends JSTemporalBuiltinOperation {
        protected JSTemporalCalendarMonth(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected long month(JSTemporalCalendarObject calendar, Object temporalDateLike, @Cached ToTemporalDateNode toTemporalDate) {
            int month;
            assert (calendar.getId().equals((Object)TemporalConstants.ISO8601));
            if (temporalDateLike instanceof JSTemporalPlainDateObject) {
                JSTemporalPlainDateObject date = (JSTemporalPlainDateObject)((Object)temporalDateLike);
                month = date.getMonth();
            } else if (temporalDateLike instanceof JSTemporalPlainDateTimeObject) {
                JSTemporalPlainDateTimeObject dateTime = (JSTemporalPlainDateTimeObject)((Object)temporalDateLike);
                month = dateTime.getMonth();
            } else if (temporalDateLike instanceof JSTemporalPlainYearMonthObject) {
                JSTemporalPlainYearMonthObject yearMonth = (JSTemporalPlainYearMonthObject)((Object)temporalDateLike);
                month = yearMonth.getMonth();
            } else {
                if (temporalDateLike instanceof JSTemporalPlainMonthDayObject) {
                    throw Errors.createTypeError("PlainMonthDay not expected");
                }
                JSTemporalPlainDateObject date = toTemporalDate.execute(temporalDateLike);
                month = date.getMonth();
            }
            return month;
        }

        @Specialization(guards={"!isJSTemporalCalendar(thisObj)"})
        protected static Object invalidReceiver(Object thisObj, Object temporalDateLike) {
            throw TemporalErrors.createTypeErrorTemporalCalendarExpected();
        }
    }

    public static abstract class JSTemporalCalendarMonthCode
    extends JSTemporalBuiltinOperation {
        protected JSTemporalCalendarMonthCode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected TruffleString monthCode(JSTemporalCalendarObject calendar, Object temporalDateLike, @Cached ToTemporalDateNode toTemporalDate) {
            int month;
            assert (calendar.getId().equals((Object)TemporalConstants.ISO8601));
            if (temporalDateLike instanceof JSTemporalPlainDateObject) {
                JSTemporalPlainDateObject date = (JSTemporalPlainDateObject)((Object)temporalDateLike);
                month = date.getMonth();
            } else if (temporalDateLike instanceof JSTemporalPlainDateTimeObject) {
                JSTemporalPlainDateTimeObject dateTime = (JSTemporalPlainDateTimeObject)((Object)temporalDateLike);
                month = dateTime.getMonth();
            } else if (temporalDateLike instanceof JSTemporalPlainYearMonthObject) {
                JSTemporalPlainYearMonthObject yearMonth = (JSTemporalPlainYearMonthObject)((Object)temporalDateLike);
                month = yearMonth.getMonth();
            } else if (temporalDateLike instanceof JSTemporalPlainMonthDayObject) {
                JSTemporalPlainMonthDayObject monthDay = (JSTemporalPlainMonthDayObject)((Object)temporalDateLike);
                month = monthDay.getMonth();
            } else {
                JSTemporalPlainDateObject date = toTemporalDate.execute(temporalDateLike);
                month = date.getMonth();
            }
            return TemporalUtil.buildISOMonthCode(month);
        }

        @Specialization(guards={"!isJSTemporalCalendar(thisObj)"})
        protected static Object invalidReceiver(Object thisObj, Object temporalDateLike) {
            throw TemporalErrors.createTypeErrorTemporalCalendarExpected();
        }
    }

    public static abstract class JSTemporalCalendarDay
    extends JSTemporalBuiltinOperation {
        protected JSTemporalCalendarDay(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected long day(JSTemporalCalendarObject calendar, Object temporalDateLike, @Cached ToTemporalDateNode toTemporalDate) {
            int day;
            assert (calendar.getId().equals((Object)TemporalConstants.ISO8601));
            if (temporalDateLike instanceof JSTemporalPlainDateObject) {
                JSTemporalPlainDateObject date = (JSTemporalPlainDateObject)((Object)temporalDateLike);
                day = date.getDay();
            } else if (temporalDateLike instanceof JSTemporalPlainDateTimeObject) {
                JSTemporalPlainDateTimeObject dateTime = (JSTemporalPlainDateTimeObject)((Object)temporalDateLike);
                day = dateTime.getDay();
            } else if (temporalDateLike instanceof JSTemporalPlainMonthDayObject) {
                JSTemporalPlainMonthDayObject monthDay = (JSTemporalPlainMonthDayObject)((Object)temporalDateLike);
                day = monthDay.getDay();
            } else {
                JSTemporalPlainDateObject date = toTemporalDate.execute(temporalDateLike);
                day = date.getDay();
            }
            return day;
        }

        @Specialization(guards={"!isJSTemporalCalendar(thisObj)"})
        protected static Object invalidReceiver(Object thisObj, Object temporalDateLike) {
            throw TemporalErrors.createTypeErrorTemporalCalendarExpected();
        }
    }

    public static abstract class JSTemporalCalendarDayOfWeek
    extends JSTemporalBuiltinOperation {
        protected JSTemporalCalendarDayOfWeek(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected long dayOfWeek(JSTemporalCalendarObject calendar, Object temporalDateLike, @Cached ToTemporalDateNode toTemporalDate) {
            assert (calendar.getId().equals((Object)TemporalConstants.ISO8601));
            JSTemporalPlainDateObject date = toTemporalDate.execute(temporalDateLike);
            return TemporalUtil.toISODayOfWeek(date.getYear(), date.getMonth(), date.getDay());
        }

        @Specialization(guards={"!isJSTemporalCalendar(thisObj)"})
        protected static Object invalidReceiver(Object thisObj, Object temporalDateLike) {
            throw TemporalErrors.createTypeErrorTemporalCalendarExpected();
        }
    }

    public static abstract class JSTemporalCalendarDayOfYear
    extends JSTemporalBuiltinOperation {
        protected JSTemporalCalendarDayOfYear(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected long dayOfYear(JSTemporalCalendarObject calendar, Object temporalDateLike, @Cached ToTemporalDateNode toTemporalDate) {
            assert (calendar.getId().equals((Object)TemporalConstants.ISO8601));
            JSTemporalPlainDateObject date = toTemporalDate.execute(temporalDateLike);
            return TemporalUtil.toISODayOfYear(date.getYear(), date.getMonth(), date.getDay());
        }

        @Specialization(guards={"!isJSTemporalCalendar(thisObj)"})
        protected static Object invalidReceiver(Object thisObj, Object temporalDateLike) {
            throw TemporalErrors.createTypeErrorTemporalCalendarExpected();
        }
    }

    public static abstract class JSTemporalCalendarDaysInWeek
    extends JSTemporalBuiltinOperation {
        protected JSTemporalCalendarDaysInWeek(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected long daysInWeek(JSTemporalCalendarObject calendar, Object temporalDateLike, @Cached ToTemporalDateNode toTemporalDate) {
            assert (calendar.getId().equals((Object)TemporalConstants.ISO8601));
            toTemporalDate.execute(temporalDateLike);
            return 7L;
        }

        @Specialization(guards={"!isJSTemporalCalendar(thisObj)"})
        protected static Object invalidReceiver(Object thisObj, Object temporalDateLike) {
            throw TemporalErrors.createTypeErrorTemporalCalendarExpected();
        }
    }

    public static abstract class JSTemporalCalendarWeekOfYear
    extends JSTemporalBuiltinOperation {
        protected JSTemporalCalendarWeekOfYear(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected long weekOfYear(JSTemporalCalendarObject calendar, Object temporalDateLike, @Cached ToTemporalDateNode toTemporalDate) {
            assert (calendar.getId().equals((Object)TemporalConstants.ISO8601));
            JSTemporalPlainDateObject date = toTemporalDate.execute(temporalDateLike);
            return TemporalUtil.toISOWeekOfYear(date.getYear(), date.getMonth(), date.getDay());
        }

        @Specialization(guards={"!isJSTemporalCalendar(thisObj)"})
        protected static Object invalidReceiver(Object thisObj, Object temporalDateLike) {
            throw TemporalErrors.createTypeErrorTemporalCalendarExpected();
        }
    }

    public static abstract class JSTemporalCalendarDaysInMonth
    extends JSTemporalBuiltinOperation {
        protected JSTemporalCalendarDaysInMonth(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected long daysInMonth(JSTemporalCalendarObject calendar, Object temporalDateLike, @Cached ToTemporalDateNode toTemporalDate) {
            int month;
            int year;
            assert (calendar.getId().equals((Object)TemporalConstants.ISO8601));
            if (temporalDateLike instanceof JSTemporalPlainDateObject) {
                JSTemporalPlainDateObject date = (JSTemporalPlainDateObject)((Object)temporalDateLike);
                year = date.getYear();
                month = date.getMonth();
            } else if (temporalDateLike instanceof JSTemporalPlainDateTimeObject) {
                JSTemporalPlainDateTimeObject dateTime = (JSTemporalPlainDateTimeObject)((Object)temporalDateLike);
                year = dateTime.getYear();
                month = dateTime.getMonth();
            } else if (temporalDateLike instanceof JSTemporalPlainYearMonthObject) {
                JSTemporalPlainYearMonthObject yearMonth = (JSTemporalPlainYearMonthObject)((Object)temporalDateLike);
                year = yearMonth.getYear();
                month = yearMonth.getMonth();
            } else {
                JSTemporalPlainDateObject date = toTemporalDate.execute(temporalDateLike);
                year = date.getYear();
                month = date.getMonth();
            }
            return TemporalUtil.isoDaysInMonth(year, month);
        }

        @Specialization(guards={"!isJSTemporalCalendar(thisObj)"})
        protected static Object invalidReceiver(Object thisObj, Object temporalDateLike) {
            throw TemporalErrors.createTypeErrorTemporalCalendarExpected();
        }
    }

    public static abstract class JSTemporalCalendarDaysInYear
    extends JSTemporalBuiltinOperation {
        protected JSTemporalCalendarDaysInYear(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected int daysInYear(JSTemporalCalendarObject calendar, Object temporalDateLike, @Cached ToTemporalDateNode toTemporalDate) {
            int year;
            assert (calendar.getId().equals((Object)TemporalConstants.ISO8601));
            if (temporalDateLike instanceof JSTemporalPlainDateObject) {
                JSTemporalPlainDateObject date = (JSTemporalPlainDateObject)((Object)temporalDateLike);
                year = date.getYear();
            } else if (temporalDateLike instanceof JSTemporalPlainDateTimeObject) {
                JSTemporalPlainDateTimeObject dateTime = (JSTemporalPlainDateTimeObject)((Object)temporalDateLike);
                year = dateTime.getYear();
            } else if (temporalDateLike instanceof JSTemporalPlainYearMonthObject) {
                JSTemporalPlainYearMonthObject yearMonth = (JSTemporalPlainYearMonthObject)((Object)temporalDateLike);
                year = yearMonth.getYear();
            } else {
                JSTemporalPlainDateObject date = toTemporalDate.execute(temporalDateLike);
                year = date.getYear();
            }
            return TemporalUtil.isoDaysInYear(year);
        }

        @Specialization(guards={"!isJSTemporalCalendar(thisObj)"})
        protected static Object invalidReceiver(Object thisObj, Object temporalDateLike) {
            throw TemporalErrors.createTypeErrorTemporalCalendarExpected();
        }
    }

    public static abstract class JSTemporalCalendarMonthsInYear
    extends JSTemporalBuiltinOperation {
        protected JSTemporalCalendarMonthsInYear(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected long monthsInYear(JSTemporalCalendarObject calendar, Object temporalDateLike, @Cached ToTemporalDateNode toTemporalDate) {
            assert (calendar.getId().equals((Object)TemporalConstants.ISO8601));
            if (!(temporalDateLike instanceof JSTemporalPlainDateObject || temporalDateLike instanceof JSTemporalPlainDateTimeObject || temporalDateLike instanceof JSTemporalPlainYearMonthObject)) {
                toTemporalDate.execute(temporalDateLike);
            }
            return 12L;
        }

        @Specialization(guards={"!isJSTemporalCalendar(thisObj)"})
        protected static Object invalidReceiver(Object thisObj, Object temporalDateLike) {
            throw TemporalErrors.createTypeErrorTemporalCalendarExpected();
        }
    }

    public static abstract class JSTemporalCalendarInLeapYear
    extends JSTemporalBuiltinOperation {
        protected JSTemporalCalendarInLeapYear(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected boolean inLeapYear(JSTemporalCalendarObject calendar, Object temporalDateLike, @Cached ToTemporalDateNode toTemporalDate) {
            int year;
            assert (calendar.getId().equals((Object)TemporalConstants.ISO8601));
            if (temporalDateLike instanceof JSTemporalPlainDateObject) {
                JSTemporalPlainDateObject date = (JSTemporalPlainDateObject)((Object)temporalDateLike);
                year = date.getYear();
            } else if (temporalDateLike instanceof JSTemporalPlainDateTimeObject) {
                JSTemporalPlainDateTimeObject dateTime = (JSTemporalPlainDateTimeObject)((Object)temporalDateLike);
                year = dateTime.getYear();
            } else if (temporalDateLike instanceof JSTemporalPlainYearMonthObject) {
                JSTemporalPlainYearMonthObject yearMonth = (JSTemporalPlainYearMonthObject)((Object)temporalDateLike);
                year = yearMonth.getYear();
            } else {
                JSTemporalPlainDateObject dateLike = toTemporalDate.execute(temporalDateLike);
                year = dateLike.getYear();
            }
            return TemporalUtil.isISOLeapYear(year);
        }

        @Specialization(guards={"!isJSTemporalCalendar(thisObj)"})
        protected static Object invalidReceiver(Object thisObj, Object temporalDateLike) {
            throw TemporalErrors.createTypeErrorTemporalCalendarExpected();
        }
    }
}

