/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.terminal.api;

import java.io.InputStream;
import java.io.OutputStream;
import org.openide.util.Lookup;
import org.openide.windows.InputOutput;

public abstract class IOTerm {
    private static IOTerm find(InputOutput io) {
        if (io instanceof Lookup.Provider) {
            Lookup.Provider p = (Lookup.Provider)io;
            return (IOTerm)p.getLookup().lookup(IOTerm.class);
        }
        return null;
    }

    public static boolean isSupported(InputOutput io) {
        return IOTerm.find(io) != null;
    }

    public static void connect(InputOutput io, OutputStream pin, InputStream pout, InputStream perr) {
        IOTerm.connect(io, pin, pout, perr, null);
    }

    public static void connect(InputOutput io, OutputStream pin, InputStream pout, InputStream perr, String charset) {
        IOTerm.connect(io, pin, pout, perr, charset, null);
    }

    public static void connect(InputOutput io, OutputStream pin, InputStream pout, InputStream perr, String charset, Runnable postConnectTask) {
        IOTerm iot = IOTerm.find(io);
        if (iot != null) {
            iot.connect(pin, pout, perr, charset, postConnectTask);
        }
    }

    public static void disconnect(InputOutput io, Runnable continuation) {
        IOTerm iot = IOTerm.find(io);
        if (iot == null) {
            return;
        }
        iot.disconnect(continuation);
    }

    public static void setReadOnly(InputOutput io, boolean isReadOnly) {
        IOTerm iot = IOTerm.find(io);
        if (iot == null) {
            return;
        }
        iot.setReadOnly(isReadOnly);
    }

    public static void requestFocus(InputOutput io) {
        IOTerm iot = IOTerm.find(io);
        if (iot == null) {
            return;
        }
        iot.requestFocus();
    }

    protected abstract void connect(OutputStream var1, InputStream var2, InputStream var3, String var4, Runnable var5);

    protected abstract void disconnect(Runnable var1);

    protected abstract void setReadOnly(boolean var1);

    protected abstract void requestFocus();
}

