/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.waiter.internal;

import com.oracle.bmc.responses.AsyncHandler;
import com.oracle.bmc.waiter.Waiter;
import java.beans.ConstructorProperties;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

public class SimpleWaiterImpl<REQUEST, RESPONSE>
implements Waiter<REQUEST, RESPONSE> {
    private final ExecutorService executorService;
    private final Callable<RESPONSE> callable;
    private final REQUEST request;

    @Override
    public RESPONSE execute() throws Exception {
        return this.callable.call();
    }

    @Override
    public Future<Void> execute(final AsyncHandler<REQUEST, RESPONSE> asyncHandler) {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    Object response = SimpleWaiterImpl.this.callable.call();
                    asyncHandler.onSuccess(SimpleWaiterImpl.this.request, response);
                    return null;
                }
                catch (Exception e) {
                    asyncHandler.onError(SimpleWaiterImpl.this.request, e);
                    throw e;
                }
            }
        });
    }

    @ConstructorProperties(value={"executorService", "callable", "request"})
    public SimpleWaiterImpl(ExecutorService executorService, Callable<RESPONSE> callable, REQUEST request) {
        this.executorService = executorService;
        this.callable = callable;
        this.request = request;
    }

    public REQUEST getRequest() {
        return this.request;
    }
}

