/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.http.internal;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.http.client.HttpRequest;
import com.oracle.bmc.retrier.Retriers;
import java.util.UUID;

public class RetryTokenUtils {
    @InternalSdk
    public static final String OPC_RETRY_TOKEN_HEADER = "opc-retry-token";

    private RetryTokenUtils() {
    }

    public static void addRetryToken(HttpRequest httpRequest) {
        if (!Retriers.shouldSendOpcRetryToken()) {
            return;
        }
        boolean isOpcRetryTokenAlreadySet = httpRequest.headers().keySet().stream().anyMatch(headerName -> headerName.equalsIgnoreCase(OPC_RETRY_TOKEN_HEADER));
        if (isOpcRetryTokenAlreadySet) {
            return;
        }
        httpRequest.header(OPC_RETRY_TOKEN_HEADER, RetryTokenUtils.generateRetryToken());
    }

    private static String generateRetryToken() {
        return UUID.randomUUID().toString();
    }
}

