/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.webkit.debugging.api.page;

import org.json.simple.JSONObject;
import org.netbeans.modules.web.webkit.debugging.TransportHelper;
import org.netbeans.modules.web.webkit.debugging.api.WebKitDebugging;
import org.netbeans.modules.web.webkit.debugging.spi.Command;
import org.netbeans.modules.web.webkit.debugging.spi.Response;
import org.netbeans.modules.web.webkit.debugging.spi.ResponseCallback;

public class Page {
    private final TransportHelper transport;
    private boolean enabled;
    private final Callback callback;
    private int numberOfClients = 0;

    public Page(TransportHelper transport, WebKitDebugging webKit) {
        this.transport = transport;
        this.callback = new Callback();
        this.transport.addListener(this.callback);
    }

    public void enable() {
        ++this.numberOfClients;
        if (!this.enabled) {
            this.enabled = true;
            this.transport.sendBlockingCommand(new Command("Page.enable"));
        }
    }

    public void disable() {
        assert (this.numberOfClients > 0);
        --this.numberOfClients;
        if (this.numberOfClients == 0) {
            this.transport.sendCommand(new Command("Page.disable"));
            this.enabled = false;
        }
    }

    public void reload(boolean ignoreCache, String scriptToEvaluateOnLoad) {
        this.reload(ignoreCache, scriptToEvaluateOnLoad, null);
    }

    public void reload(boolean ignoreCache, String scriptToEvaluateOnLoad, String scriptPreprocessor) {
        JSONObject pars = new JSONObject();
        pars.put((Object)"ignoreCache", (Object)ignoreCache);
        if (scriptToEvaluateOnLoad != null) {
            pars.put((Object)"scriptToEvaluateOnLoad", (Object)scriptToEvaluateOnLoad);
        }
        if (scriptPreprocessor != null) {
            pars.put((Object)"scriptPreprocessor", (Object)scriptPreprocessor);
        }
        this.transport.sendBlockingCommand(new Command("Page.reload", pars));
    }

    public void navigate(String url) {
        JSONObject urlPar = new JSONObject();
        urlPar.put((Object)"url", (Object)url);
        this.transport.sendBlockingCommand(new Command("Page.navigate", urlPar));
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    private static class Callback
    implements ResponseCallback {
        private Callback() {
        }

        @Override
        public void handleResponse(Response response) {
        }
    }
}

