/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.dd.impl.ejb.annotation;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.netbeans.modules.j2ee.dd.api.common.CommonDDBean;
import org.netbeans.modules.j2ee.dd.api.common.EjbLocalRef;
import org.netbeans.modules.j2ee.dd.api.common.EjbRef;
import org.netbeans.modules.j2ee.dd.api.common.EnvEntry;
import org.netbeans.modules.j2ee.dd.api.common.Icon;
import org.netbeans.modules.j2ee.dd.api.common.MessageDestinationRef;
import org.netbeans.modules.j2ee.dd.api.common.NameAlreadyUsedException;
import org.netbeans.modules.j2ee.dd.api.common.ResourceEnvRef;
import org.netbeans.modules.j2ee.dd.api.common.ResourceRef;
import org.netbeans.modules.j2ee.dd.api.common.SecurityRoleRef;
import org.netbeans.modules.j2ee.dd.api.common.ServiceRef;
import org.netbeans.modules.j2ee.dd.api.common.VersionNotSupportedException;
import org.netbeans.modules.j2ee.dd.api.ejb.AroundInvoke;
import org.netbeans.modules.j2ee.dd.api.ejb.EjbJar;
import org.netbeans.modules.j2ee.dd.api.ejb.InitMethod;
import org.netbeans.modules.j2ee.dd.api.ejb.LifecycleCallback;
import org.netbeans.modules.j2ee.dd.api.ejb.NamedMethod;
import org.netbeans.modules.j2ee.dd.api.ejb.PersistenceContextRef;
import org.netbeans.modules.j2ee.dd.api.ejb.PersistenceUnitRef;
import org.netbeans.modules.j2ee.dd.api.ejb.RemoveMethod;
import org.netbeans.modules.j2ee.dd.api.ejb.SecurityIdentity;
import org.netbeans.modules.j2ee.dd.api.ejb.Session;
import org.netbeans.modules.j2ee.dd.impl.common.annotation.CommonAnnotationHelper;
import org.netbeans.modules.j2ee.dd.impl.common.annotation.EjbRefHelper;
import org.netbeans.modules.j2ee.metadata.model.api.support.annotation.AnnotationModelHelper;
import org.netbeans.modules.j2ee.metadata.model.api.support.annotation.PersistentObject;
import org.netbeans.modules.j2ee.metadata.model.api.support.annotation.parser.AnnotationParser;
import org.netbeans.modules.j2ee.metadata.model.api.support.annotation.parser.ArrayValueHandler;
import org.netbeans.modules.j2ee.metadata.model.api.support.annotation.parser.ParseResult;
import org.openide.util.Exceptions;

public class SessionImpl
extends PersistentObject
implements Session {
    private final Kind kind;
    private String ejbName;
    private String ejbClass;
    private String sessionType;
    private Set<String> interfacesSet;
    private Set<String> businessLocal = new HashSet<String>();
    private Set<String> businessRemote = new HashSet<String>();
    private EjbRef[] ejbRefs;
    private EjbLocalRef[] ejbLocalRefs;
    private ServiceRef[] serviceRefs;
    private ResourceRef[] resourceRefs;
    private ResourceEnvRef[] resourceEnvRefs = null;
    private EnvEntry[] envEntries = null;
    private MessageDestinationRef[] messageDestinationRefs = null;
    private boolean localBean = false;
    private String serviceEndpoint = null;
    private PropertyChangeSupport changeSupport = new PropertyChangeSupport(this);

    public SessionImpl(Kind kind, AnnotationModelHelper helper, TypeElement typeElement) {
        super(helper, typeElement);
        this.kind = kind;
        this.interfacesSet = new HashSet<String>();
        boolean valid = this.refresh(typeElement);
        assert (valid);
    }

    boolean refresh(TypeElement typeElement) {
        Map annByType = this.getHelper().getAnnotationsByType(typeElement.getAnnotationMirrors());
        AnnotationMirror annotationMirror = null;
        switch (this.kind.ordinal()) {
            case 0: {
                annotationMirror = (AnnotationMirror)annByType.get("jakarta.ejb.Stateless");
                if (annotationMirror == null) {
                    annotationMirror = (AnnotationMirror)annByType.get("javax.ejb.Stateless");
                }
                this.sessionType = "Stateless";
                break;
            }
            case 1: {
                annotationMirror = (AnnotationMirror)annByType.get("jakarta.ejb.Stateful");
                if (annotationMirror == null) {
                    annotationMirror = (AnnotationMirror)annByType.get("javax.ejb.Stateful");
                }
                this.sessionType = "Stateful";
                break;
            }
            case 2: {
                annotationMirror = (AnnotationMirror)annByType.get("jakarta.ejb.Singleton");
                if (annotationMirror == null) {
                    annotationMirror = (AnnotationMirror)annByType.get("javax.ejb.Singleton");
                }
                this.sessionType = "Singleton";
            }
        }
        if (annotationMirror == null) {
            return false;
        }
        AnnotationParser parser = AnnotationParser.create((AnnotationModelHelper)this.getHelper());
        parser.expectString("name", AnnotationParser.defaultValue((Object)typeElement.getSimpleName().toString()));
        ParseResult parseResult = parser.parse(annotationMirror);
        String oldEjbName = this.ejbName;
        this.ejbName = (String)parseResult.get("name", String.class);
        if (this.ejbName != null && !this.ejbName.equals(oldEjbName)) {
            this.fireChange(new PropertyChangeEvent(this, "EjbName", oldEjbName, this.ejbName));
        }
        this.ejbClass = typeElement.getQualifiedName().toString();
        this.initBusinessInterfaces();
        this.localBean = annByType.get("jakarta.ejb.LocalBean") != null || annByType.get("javax.ejb.LocalBean") != null;
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private void initBusinessInterfaces() {
        boolean isAnyIfaceExplicit;
        void var6_9;
        HashSet<String> businessLocalOld = new HashSet<String>(this.businessLocal);
        HashSet<String> businessRemoteOld = new HashSet<String>(this.businessRemote);
        TypeElement typeElement = this.getTypeElement();
        this.interfacesSet = new HashSet<String>();
        this.businessLocal.clear();
        this.businessRemote.clear();
        if (typeElement == null) {
            return;
        }
        ArrayList<TypeElement> interfaces = new ArrayList<TypeElement>();
        for (TypeMirror typeMirror : typeElement.getInterfaces()) {
            DeclaredType declaredType;
            Element element;
            if (TypeKind.DECLARED != typeMirror.getKind() || ElementKind.INTERFACE != (element = (declaredType = (DeclaredType)typeMirror).asElement()).getKind()) continue;
            TypeElement interfaceTypeElement = (TypeElement)element;
            String fqn = interfaceTypeElement.getQualifiedName().toString();
            this.interfacesSet.add(fqn);
            if ("java.io.Serializable".equals(fqn) || "java.io.Externalizable".equals(fqn) || fqn.startsWith("javax.ejb") || fqn.startsWith("jakarta.ejb")) continue;
            interfaces.add(interfaceTypeElement);
        }
        Map annByType = this.getHelper().getAnnotationsByType(typeElement.getAnnotationMirrors());
        AnnotationMirror annotationMirror = (AnnotationMirror)annByType.get("jakarta.ejb.Local");
        if (annotationMirror == null) {
            AnnotationMirror annotationMirror2 = (AnnotationMirror)annByType.get("javax.ejb.Local");
        }
        boolean isEmptyBeanLocalAnnotation = var6_9 != null && var6_9.getElementValues().isEmpty();
        AnnotationMirror beanRemoteAnnotation = (AnnotationMirror)annByType.get("jakarta.ejb.Remote");
        if (beanRemoteAnnotation == null) {
            beanRemoteAnnotation = (AnnotationMirror)annByType.get("javax.ejb.Remote");
        }
        boolean isEmptyBeanRemoteAnnotation = beanRemoteAnnotation != null && beanRemoteAnnotation.getElementValues().isEmpty();
        ArrayList<String> annotatedLocalInterfaces = new ArrayList<String>();
        ArrayList<String> annotatedRemoteInterfaces = new ArrayList<String>();
        ArrayList<String> allInterfaces = new ArrayList<String>();
        for (TypeElement interfaceTypeElement : interfaces) {
            Map ifaceAnnByType = this.getHelper().getAnnotationsByType(interfaceTypeElement.getAnnotationMirrors());
            if (ifaceAnnByType.get("jakarta.ejb.Local") != null || ifaceAnnByType.get("javax.ejb.Local") != null) {
                annotatedLocalInterfaces.add(interfaceTypeElement.getQualifiedName().toString());
            }
            if (ifaceAnnByType.get("jakarta.ejb.Remote") != null || ifaceAnnByType.get("javax.ejb.Remote") != null) {
                annotatedRemoteInterfaces.add(interfaceTypeElement.getQualifiedName().toString());
            }
            allInterfaces.add(interfaceTypeElement.getQualifiedName().toString());
        }
        boolean isNoIfaceView = annByType.get("javax.ejb.LocalBean") != null || annByType.get("jakarta.ejb.LocalBean") != null;
        boolean bl = isAnyIfaceExplicit = !annotatedRemoteInterfaces.isEmpty() || !annotatedLocalInterfaces.isEmpty() || var6_9 != null && !isEmptyBeanLocalAnnotation || beanRemoteAnnotation != null && !isEmptyBeanRemoteAnnotation;
        if (interfaces.size() == 1) {
            if (!isNoIfaceView && !isAnyIfaceExplicit) {
                if (beanRemoteAnnotation != null) {
                    this.businessRemote.add(((TypeElement)interfaces.get(0)).getQualifiedName().toString());
                }
                this.businessLocal.add(((TypeElement)interfaces.get(0)).getQualifiedName().toString());
            } else if (beanRemoteAnnotation == null && annotatedRemoteInterfaces.isEmpty()) {
                this.businessLocal.add(((TypeElement)interfaces.get(0)).getQualifiedName().toString());
            } else if (var6_9 == null && annotatedLocalInterfaces.isEmpty()) {
                this.businessRemote.add(((TypeElement)interfaces.get(0)).getQualifiedName().toString());
            }
        } else if (!isNoIfaceView && !isAnyIfaceExplicit) {
            if (beanRemoteAnnotation != null) {
                this.businessRemote.addAll(allInterfaces);
            }
            this.businessLocal.addAll(allInterfaces);
        } else {
            List<String> annotationsValues;
            if (var6_9 != null) {
                annotationsValues = this.getClassesFromLocalOrRemote((AnnotationMirror)var6_9);
                this.businessLocal.addAll(annotationsValues);
            } else {
                this.businessLocal.addAll(annotatedLocalInterfaces);
            }
            if (beanRemoteAnnotation != null) {
                annotationsValues = this.getClassesFromLocalOrRemote(beanRemoteAnnotation);
                this.businessRemote.addAll(annotationsValues);
            } else {
                this.businessRemote.addAll(annotatedRemoteInterfaces);
            }
        }
        if (!businessLocalOld.equals(this.businessLocal)) {
            this.fireChange(new PropertyChangeEvent(this, "BusinessLocal", businessLocalOld, this.businessLocal));
        }
        if (!businessRemoteOld.equals(this.businessRemote)) {
            this.fireChange(new PropertyChangeEvent(this, "BusinessRemote", businessRemoteOld, this.businessRemote));
        }
    }

    private List<String> getClassesFromLocalOrRemote(AnnotationMirror beanLocalAnnotation) {
        final ArrayList<String> result = new ArrayList<String>();
        AnnotationParser parser = AnnotationParser.create((AnnotationModelHelper)this.getHelper());
        parser.expectClassArray("value", new ArrayValueHandler(){
            final /* synthetic */ SessionImpl this$0;
            {
                this.this$0 = this$0;
            }

            public Object handleArray(List<AnnotationValue> arrayMembers) {
                for (AnnotationValue arrayMember : arrayMembers) {
                    DeclaredType declaredType;
                    Element element;
                    TypeMirror typeMirror = (TypeMirror)arrayMember.getValue();
                    if (TypeKind.DECLARED != typeMirror.getKind() || ElementKind.INTERFACE != (element = (declaredType = (DeclaredType)typeMirror).asElement()).getKind()) continue;
                    TypeElement interfaceTypeElement = (TypeElement)element;
                    result.add(interfaceTypeElement.getQualifiedName().toString());
                }
                return null;
            }
        }, null);
        parser.parse(beanLocalAnnotation);
        return result;
    }

    private void initLocalAndRemoteEjbRefs() {
        if (this.ejbRefs != null && this.ejbLocalRefs != null) {
            return;
        }
        ArrayList<EjbRef> resultEjbRefs = new ArrayList<EjbRef>();
        ArrayList<EjbLocalRef> resultEjbLocalRefs = new ArrayList<EjbLocalRef>();
        EjbRefHelper.setEjbRefsForClass(this.getHelper(), this.getTypeElement(), resultEjbRefs, resultEjbLocalRefs);
        this.ejbRefs = resultEjbRefs.toArray(new EjbRef[0]);
        this.ejbLocalRefs = resultEjbLocalRefs.toArray(new EjbLocalRef[0]);
    }

    private void initServiceRefs() {
        if (this.serviceRefs != null) {
            return;
        }
        this.serviceRefs = CommonAnnotationHelper.getServiceRefs(this.getHelper(), this.getTypeElement());
    }

    private void initResourceRefs() {
        if (this.resourceRefs != null) {
            return;
        }
        this.resourceRefs = CommonAnnotationHelper.getResourceRefs(this.getHelper(), this.getTypeElement());
    }

    private void initResourceEnvRefs() {
        if (this.resourceEnvRefs != null) {
            return;
        }
        this.resourceEnvRefs = CommonAnnotationHelper.getResourceEnvRefs(this.getHelper(), this.getTypeElement());
    }

    private void initEnvEntries() {
        if (this.envEntries != null) {
            return;
        }
        this.envEntries = CommonAnnotationHelper.getEnvEntries(this.getHelper(), this.getTypeElement());
    }

    private void initMessageDestinationRefs() {
        if (this.messageDestinationRefs != null) {
            return;
        }
        this.messageDestinationRefs = CommonAnnotationHelper.getMessageDestinationRefs(this.getHelper(), this.getTypeElement());
    }

    private void initServiceEndpoint() {
        if (this.serviceEndpoint != null) {
            return;
        }
        this.serviceEndpoint = CommonAnnotationHelper.getServiceEndpoint(this.getHelper(), this.getTypeElement());
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener pcl) {
        this.changeSupport.addPropertyChangeListener(pcl);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener pcl) {
        this.changeSupport.removePropertyChangeListener(pcl);
    }

    private void fireChange(PropertyChangeEvent pce) {
        this.changeSupport.firePropertyChange(pce);
    }

    @Override
    public String getEjbName() {
        return this.ejbName;
    }

    @Override
    public String getEjbClass() {
        return this.ejbClass;
    }

    @Override
    public String getSessionType() {
        return this.sessionType;
    }

    @Override
    public String[] getBusinessLocal() throws VersionNotSupportedException {
        this.initBusinessInterfaces();
        return this.businessLocal.toArray(new String[0]);
    }

    @Override
    public String[] getBusinessRemote() throws VersionNotSupportedException {
        this.initBusinessInterfaces();
        return this.businessRemote.toArray(new String[0]);
    }

    @Override
    public EjbRef[] getEjbRef() {
        this.initLocalAndRemoteEjbRefs();
        return this.ejbRefs;
    }

    @Override
    public EjbLocalRef[] getEjbLocalRef() {
        this.initLocalAndRemoteEjbRefs();
        return this.ejbLocalRefs;
    }

    @Override
    public ServiceRef getServiceRef(int index) throws VersionNotSupportedException {
        this.initServiceRefs();
        return this.serviceRefs[index];
    }

    @Override
    public ServiceRef[] getServiceRef() throws VersionNotSupportedException {
        this.initServiceRefs();
        return this.serviceRefs;
    }

    @Override
    public int sizeServiceRef() throws VersionNotSupportedException {
        this.initServiceRefs();
        return this.serviceRefs.length;
    }

    @Override
    public ResourceRef[] getResourceRef() {
        this.initResourceRefs();
        return this.resourceRefs;
    }

    @Override
    public ResourceRef getResourceRef(int index) {
        this.initResourceRefs();
        return this.resourceRefs[index];
    }

    @Override
    public int sizeResourceRef() {
        this.initResourceRefs();
        return this.resourceRefs.length;
    }

    @Override
    public ResourceEnvRef[] getResourceEnvRef() {
        this.initResourceEnvRefs();
        return this.resourceEnvRefs;
    }

    @Override
    public ResourceEnvRef getResourceEnvRef(int index) {
        this.initResourceEnvRefs();
        return this.resourceEnvRefs[index];
    }

    @Override
    public int sizeResourceEnvRef() {
        this.initResourceEnvRefs();
        return this.resourceEnvRefs.length;
    }

    @Override
    public EnvEntry[] getEnvEntry() {
        this.initEnvEntries();
        return this.envEntries;
    }

    @Override
    public EnvEntry getEnvEntry(int index) {
        this.initEnvEntries();
        return this.envEntries[index];
    }

    @Override
    public int sizeEnvEntry() {
        this.initEnvEntries();
        return this.envEntries.length;
    }

    @Override
    public MessageDestinationRef[] getMessageDestinationRef() throws VersionNotSupportedException {
        this.initMessageDestinationRefs();
        return this.messageDestinationRefs;
    }

    @Override
    public MessageDestinationRef getMessageDestinationRef(int index) throws VersionNotSupportedException {
        this.initMessageDestinationRefs();
        return this.messageDestinationRefs[index];
    }

    @Override
    public int sizeMessageDestinationRef() throws VersionNotSupportedException {
        this.initMessageDestinationRefs();
        return this.messageDestinationRefs.length;
    }

    @Override
    public String getServiceEndpoint() throws VersionNotSupportedException {
        this.initServiceEndpoint();
        return this.serviceEndpoint;
    }

    @Override
    public String getDefaultDisplayName() {
        return this.getEjbName();
    }

    @Override
    public String getLocal() {
        try {
            String[] businessLocal = this.getBusinessLocal();
            if (businessLocal != null && businessLocal.length > 0) {
                return businessLocal[0];
            }
        }
        catch (VersionNotSupportedException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return null;
    }

    @Override
    public String getRemote() {
        try {
            String[] businessRemote = this.getBusinessRemote();
            if (businessRemote != null && businessRemote.length > 0) {
                return businessRemote[0];
            }
        }
        catch (VersionNotSupportedException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return null;
    }

    @Override
    public String getLocalHome() {
        return null;
    }

    @Override
    public String getHome() {
        return null;
    }

    @Override
    public boolean isLocalBean() {
        return this.localBean;
    }

    @Override
    public Object clone() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setSessionType(String value) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String getTransactionType() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setTransactionType(String value) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setServiceEndpoint(String value) throws VersionNotSupportedException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setMappedName(String value) throws VersionNotSupportedException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String getMappedName() throws VersionNotSupportedException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setBusinessLocal(int index, String value) throws VersionNotSupportedException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String getBusinessLocal(int index) throws VersionNotSupportedException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int sizeBusinessLocal() throws VersionNotSupportedException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setBusinessLocal(String[] value) throws VersionNotSupportedException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int addBusinessLocal(String value) throws VersionNotSupportedException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int removeBusinessLocal(String value) throws VersionNotSupportedException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setBusinessRemote(int index, String value) throws VersionNotSupportedException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String getBusinessRemote(int index) throws VersionNotSupportedException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int sizeBusinessRemote() throws VersionNotSupportedException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setBusinessRemote(String[] value) throws VersionNotSupportedException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int addBusinessRemote(String value) throws VersionNotSupportedException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int removeBusinessRemote(String value) throws VersionNotSupportedException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setTimeoutMethod(NamedMethod valueInterface) throws VersionNotSupportedException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public NamedMethod getTimeoutMethod() throws VersionNotSupportedException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setInitMethod(int index, InitMethod valueInterface) throws VersionNotSupportedException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public InitMethod getInitMethod(int index) throws VersionNotSupportedException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int sizeInitMethod() throws VersionNotSupportedException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setInitMethod(InitMethod[] value) throws VersionNotSupportedException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public InitMethod[] getInitMethod() throws VersionNotSupportedException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int addInitMethod(InitMethod valueInterface) throws VersionNotSupportedException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int removeInitMethod(InitMethod valueInterface) throws VersionNotSupportedException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setRemoveMethod(int index, RemoveMethod valueInterface) throws VersionNotSupportedException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public RemoveMethod getRemoveMethod(int index) throws VersionNotSupportedException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int sizeRemoveMethod() throws VersionNotSupportedException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setRemoveMethod(RemoveMethod[] value) throws VersionNotSupportedException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public RemoveMethod[] getRemoveMethod() throws VersionNotSupportedException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int addRemoveMethod(RemoveMethod valueInterface) throws VersionNotSupportedException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int removeRemoveMethod(RemoveMethod valueInterface) throws VersionNotSupportedException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setAroundInvoke(int index, AroundInvoke valueInterface) throws VersionNotSupportedException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public AroundInvoke getAroundInvoke(int index) throws VersionNotSupportedException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int sizeAroundInvoke() throws VersionNotSupportedException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setAroundInvoke(AroundInvoke[] value) throws VersionNotSupportedException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public AroundInvoke[] getAroundInvoke() throws VersionNotSupportedException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int addAroundInvoke(AroundInvoke valueInterface) throws VersionNotSupportedException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int removeAroundInvoke(AroundInvoke valueInterface) throws VersionNotSupportedException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setPersistenceContextRef(int index, PersistenceContextRef valueInterface) throws VersionNotSupportedException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public PersistenceContextRef getPersistenceContextRef(int index) throws VersionNotSupportedException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int sizePersistenceContextRef() throws VersionNotSupportedException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setPersistenceContextRef(PersistenceContextRef[] value) throws VersionNotSupportedException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public PersistenceContextRef[] getPersistenceContextRef() throws VersionNotSupportedException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int addPersistenceContextRef(PersistenceContextRef valueInterface) throws VersionNotSupportedException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int removePersistenceContextRef(PersistenceContextRef valueInterface) throws VersionNotSupportedException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setPersistenceUnitRef(int index, PersistenceUnitRef valueInterface) throws VersionNotSupportedException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public PersistenceUnitRef getPersistenceUnitRef(int index) throws VersionNotSupportedException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int sizePersistenceUnitRef() throws VersionNotSupportedException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setPersistenceUnitRef(PersistenceUnitRef[] value) throws VersionNotSupportedException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public PersistenceUnitRef[] getPersistenceUnitRef() throws VersionNotSupportedException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int addPersistenceUnitRef(PersistenceUnitRef valueInterface) throws VersionNotSupportedException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int removePersistenceUnitRef(PersistenceUnitRef valueInterface) throws VersionNotSupportedException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setPostConstruct(int index, LifecycleCallback valueInterface) throws VersionNotSupportedException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public LifecycleCallback getPostConstruct(int index) throws VersionNotSupportedException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int sizePostConstruct() throws VersionNotSupportedException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setPostConstruct(LifecycleCallback[] value) throws VersionNotSupportedException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public LifecycleCallback[] getPostConstruct() throws VersionNotSupportedException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int addPostConstruct(LifecycleCallback valueInterface) throws VersionNotSupportedException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int removePostConstruct(LifecycleCallback valueInterface) throws VersionNotSupportedException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setPreDestroy(int index, LifecycleCallback valueInterface) throws VersionNotSupportedException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public LifecycleCallback getPreDestroy(int index) throws VersionNotSupportedException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int sizePreDestroy() throws VersionNotSupportedException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setPreDestroy(LifecycleCallback[] value) throws VersionNotSupportedException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public LifecycleCallback[] getPreDestroy() throws VersionNotSupportedException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int addPreDestroy(LifecycleCallback valueInterface) throws VersionNotSupportedException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int removePreDestroy(LifecycleCallback valueInterface) throws VersionNotSupportedException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setPostActivate(int index, LifecycleCallback valueInterface) throws VersionNotSupportedException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public LifecycleCallback getPostActivate(int index) throws VersionNotSupportedException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int sizePostActivate() throws VersionNotSupportedException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setPostActivate(LifecycleCallback[] value) throws VersionNotSupportedException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public LifecycleCallback[] getPostActivate() throws VersionNotSupportedException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int addPostActivate(LifecycleCallback valueInterface) throws VersionNotSupportedException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int removePostActivate(LifecycleCallback valueInterface) throws VersionNotSupportedException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setPrePassivate(int index, LifecycleCallback valueInterface) throws VersionNotSupportedException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public LifecycleCallback getPrePassivate(int index) throws VersionNotSupportedException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int sizePrePassivate() throws VersionNotSupportedException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setPrePassivate(LifecycleCallback[] value) throws VersionNotSupportedException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public LifecycleCallback[] getPrePassivate() throws VersionNotSupportedException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int addPrePassivate(LifecycleCallback valueInterface) throws VersionNotSupportedException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int removePrePassivate(LifecycleCallback valueInterface) throws VersionNotSupportedException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public NamedMethod newNamedMethod() throws VersionNotSupportedException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public InitMethod newInitMethod() throws VersionNotSupportedException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public RemoveMethod newRemoveMethod() throws VersionNotSupportedException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public AroundInvoke newAroundInvoke() throws VersionNotSupportedException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public PersistenceContextRef newPersistenceContextRef() throws VersionNotSupportedException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public PersistenceUnitRef newPersistenceUnitRef() throws VersionNotSupportedException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public LifecycleCallback newLifecycleCallback() throws VersionNotSupportedException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setHome(String value) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setRemote(String value) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setLocal(String value) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setLocalHome(String value) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setSecurityRoleRef(int index, SecurityRoleRef value) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public SecurityRoleRef getSecurityRoleRef(int index) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setSecurityRoleRef(SecurityRoleRef[] value) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public SecurityRoleRef[] getSecurityRoleRef() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int sizeSecurityRoleRef() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int removeSecurityRoleRef(SecurityRoleRef value) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int addSecurityRoleRef(SecurityRoleRef value) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public SecurityRoleRef newSecurityRoleRef() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public EjbJar getRoot() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setEjbName(String value) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setEjbClass(String value) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setEnvEntry(int index, EnvEntry value) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setEnvEntry(EnvEntry[] value) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int addEnvEntry(EnvEntry value) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int removeEnvEntry(EnvEntry value) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public EnvEntry newEnvEntry() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setEjbRef(int index, EjbRef value) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public EjbRef getEjbRef(int index) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setEjbRef(EjbRef[] value) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int removeEjbRef(EjbRef value) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int addEjbRef(EjbRef value) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int sizeEjbRef() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public EjbRef newEjbRef() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setEjbLocalRef(int index, EjbLocalRef value) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public EjbLocalRef getEjbLocalRef(int index) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setEjbLocalRef(EjbLocalRef[] value) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int addEjbLocalRef(EjbLocalRef value) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int removeEjbLocalRef(EjbLocalRef value) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int sizeEjbLocalRef() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public EjbLocalRef newEjbLocalRef() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public SecurityIdentity getSecurityIdentity() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setSecurityIdentity(SecurityIdentity value) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public SecurityIdentity newSecurityIdentity() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setResourceRef(int index, ResourceRef value) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setResourceRef(ResourceRef[] value) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int removeResourceRef(ResourceRef value) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int addResourceRef(ResourceRef value) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public ResourceRef newResourceRef() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setResourceEnvRef(int index, ResourceEnvRef value) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setResourceEnvRef(ResourceEnvRef[] value) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int addResourceEnvRef(ResourceEnvRef value) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int removeResourceEnvRef(ResourceEnvRef value) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public ResourceEnvRef newResourceEnvRef() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setMessageDestinationRef(int index, MessageDestinationRef value) throws VersionNotSupportedException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setMessageDestinationRef(MessageDestinationRef[] value) throws VersionNotSupportedException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int removeMessageDestinationRef(MessageDestinationRef value) throws VersionNotSupportedException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int addMessageDestinationRef(MessageDestinationRef value) throws VersionNotSupportedException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public MessageDestinationRef newMessageDestinationRef() throws VersionNotSupportedException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setServiceRef(int index, ServiceRef value) throws VersionNotSupportedException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setServiceRef(ServiceRef[] value) throws VersionNotSupportedException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int removeServiceRef(ServiceRef value) throws VersionNotSupportedException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int addServiceRef(ServiceRef value) throws VersionNotSupportedException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public ServiceRef newServiceRef() throws VersionNotSupportedException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setId(String value) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String getId() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Object getValue(String propertyName) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void write(OutputStream os) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setDescription(String locale, String description) throws VersionNotSupportedException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setDescription(String description) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setAllDescriptions(Map descriptions) throws VersionNotSupportedException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String getDescription(String locale) throws VersionNotSupportedException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String getDefaultDescription() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Map getAllDescriptions() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void removeDescriptionForLocale(String locale) throws VersionNotSupportedException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void removeDescription() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void removeAllDescriptions() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setDisplayName(String locale, String displayName) throws VersionNotSupportedException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setDisplayName(String displayName) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setAllDisplayNames(Map displayNames) throws VersionNotSupportedException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String getDisplayName(String locale) throws VersionNotSupportedException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Map getAllDisplayNames() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void removeDisplayNameForLocale(String locale) throws VersionNotSupportedException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void removeDisplayName() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void removeAllDisplayNames() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public CommonDDBean createBean(String beanName) throws ClassNotFoundException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public CommonDDBean addBean(String beanName, String[] propertyNames, Object[] propertyValues, String keyProperty) throws ClassNotFoundException, NameAlreadyUsedException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public CommonDDBean addBean(String beanName) throws ClassNotFoundException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public CommonDDBean findBeanByName(String beanName, String propertyName, String value) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setSmallIcon(String locale, String icon) throws VersionNotSupportedException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setSmallIcon(String icon) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setLargeIcon(String locale, String icon) throws VersionNotSupportedException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setLargeIcon(String icon) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setAllIcons(String[] locales, String[] smallIcons, String[] largeIcons) throws VersionNotSupportedException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setIcon(Icon icon) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String getSmallIcon(String locale) throws VersionNotSupportedException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String getSmallIcon() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String getLargeIcon(String locale) throws VersionNotSupportedException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String getLargeIcon() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Icon getDefaultIcon() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Map getAllIcons() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void removeSmallIcon(String locale) throws VersionNotSupportedException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void removeLargeIcon(String locale) throws VersionNotSupportedException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void removeIcon(String locale) throws VersionNotSupportedException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void removeSmallIcon() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void removeLargeIcon() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void removeIcon() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void removeAllIcons() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    protected static enum Kind {
        STATELESS,
        STATEFUL,
        SINGLETON;

    }
}

