/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.dd.impl.common.annotation;

import java.util.List;
import java.util.Map;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import org.netbeans.modules.j2ee.dd.util.AnnotationUtils;
import org.netbeans.modules.j2ee.metadata.model.api.support.annotation.AnnotationModelHelper;
import org.netbeans.modules.j2ee.metadata.model.api.support.annotation.parser.AnnotationParser;
import org.netbeans.modules.j2ee.metadata.model.api.support.annotation.parser.DefaultProvider;
import org.netbeans.modules.j2ee.metadata.model.api.support.annotation.parser.ParseResult;

public class ResourceImpl {
    static final String DEFAULT_AUTHENTICATION_TYPE = "javax.annotation.Resource.AuthenticationType.CONTAINER";
    static final String DEFAULT_AUTHENTICATION_TYPE_JAKARTA = "jakarta.annotation.Resource.AuthenticationType.CONTAINER";
    static final String DEFAULT_SHAREABLE = Boolean.TRUE.toString();
    static final String DEFAULT_MAPPED_NAME = "";
    static final String DEFAULT_DESCRIPTION = "";
    private final ParseResult parseResult;
    private final AnnotationModelHelper annotationModelHelper;
    private final TypeElement typeElement;
    private final Element element;

    public ResourceImpl(Element element, TypeElement typeElement, AnnotationModelHelper annotationModelHelper) {
        this.annotationModelHelper = annotationModelHelper;
        this.typeElement = typeElement;
        this.element = element;
        Map annByType = annotationModelHelper.getAnnotationsByType(element.getAnnotationMirrors());
        AnnotationMirror annotationMirror = (AnnotationMirror)annByType.get("jakarta.annotation.Resource");
        if (annotationMirror == null) {
            annotationMirror = (AnnotationMirror)annByType.get("javax.annotation.Resource");
        }
        this.parseResult = this.parseAnnotation(annotationMirror);
    }

    private ParseResult parseAnnotation(AnnotationMirror resourceAnnotation) {
        AnnotationParser parser = AnnotationParser.create((AnnotationModelHelper)this.annotationModelHelper);
        parser.expectString("name", new DefaultProvider(){

            public Object getDefaultValue() {
                switch (ResourceImpl.this.element.getKind()) {
                    case METHOD: {
                        return AnnotationUtils.setterNameToPropertyName(ResourceImpl.this.element.getSimpleName().toString());
                    }
                    case FIELD: {
                        return ResourceImpl.this.element.getSimpleName().toString();
                    }
                }
                return "";
            }
        });
        parser.expectClass("type", new DefaultProvider(){

            public Object getDefaultValue() {
                switch (ResourceImpl.this.element.getKind()) {
                    case CLASS: {
                        TypeElement typeElement = (TypeElement)ResourceImpl.this.element;
                        return typeElement.getQualifiedName().toString();
                    }
                    case METHOD: {
                        ExecutableElement executableElement = (ExecutableElement)ResourceImpl.this.element;
                        List<? extends VariableElement> parameters = executableElement.getParameters();
                        if (parameters.isEmpty()) break;
                        VariableElement parameter = parameters.get(0);
                        return parameter.asType().toString();
                    }
                    case FIELD: {
                        VariableElement field = (VariableElement)ResourceImpl.this.element;
                        return field.asType().toString();
                    }
                }
                return Object.class.getName();
            }
        });
        if (((TypeElement)resourceAnnotation.getAnnotationType().asElement()).getQualifiedName().toString().startsWith("jakarta.")) {
            parser.expectEnumConstant("authenticationType", this.annotationModelHelper.resolveType("jakarta.annotation.Resource.AuthenticationType"), AnnotationParser.defaultValue((Object)DEFAULT_AUTHENTICATION_TYPE_JAKARTA));
        } else {
            parser.expectEnumConstant("authenticationType", this.annotationModelHelper.resolveType("javax.annotation.Resource.AuthenticationType"), AnnotationParser.defaultValue((Object)DEFAULT_AUTHENTICATION_TYPE));
        }
        parser.expectPrimitive("shareable", Boolean.class, AnnotationParser.defaultValue((Object)Boolean.parseBoolean(DEFAULT_SHAREABLE)));
        parser.expectString("mappedName", AnnotationParser.defaultValue((Object)""));
        parser.expectString("description", AnnotationParser.defaultValue((Object)""));
        return parser.parse(resourceAnnotation);
    }

    public String getName() {
        return (String)this.parseResult.get("name", String.class);
    }

    public String getType() {
        return (String)this.parseResult.get("type", String.class);
    }

    public String getAuthenticationType() {
        return (String)this.parseResult.get("authenticationType", String.class);
    }

    public String getShareable() {
        return ((Boolean)this.parseResult.get("shareable", Boolean.class)).toString();
    }

    public String getMappedName() {
        return (String)this.parseResult.get("mappedName", String.class);
    }

    public String getDescription() {
        return (String)this.parseResult.get("description", String.class);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        String newLine = System.getProperty("line.separator");
        sb.append(this.getClass().getName() + " Object {");
        sb.append(newLine);
        sb.append(" Name: ");
        sb.append(this.getName());
        sb.append(newLine);
        sb.append(" Type: ");
        sb.append(this.getType());
        sb.append(newLine);
        sb.append(" AuthenticationType: ");
        sb.append(this.getAuthenticationType());
        sb.append(newLine);
        sb.append(" Shareable: ");
        sb.append(this.getShareable());
        sb.append(newLine);
        sb.append(" MappedName: ");
        sb.append(this.getMappedName());
        sb.append(newLine);
        sb.append(" Description: ");
        sb.append(this.getDescription());
        sb.append(newLine);
        sb.append("}");
        return sb.toString();
    }
}

