/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javaee.wildfly.ide;

import java.util.regex.Pattern;

public class WildflyStartLineParser {
    private static final Pattern JBOSS_7_STARTED_ML = Pattern.compile(".*JBoss AS 7(\\..*)* \\d+ms .*");
    private static final Pattern WILDFLY_8_STARTED_ML = Pattern.compile(".*JBAS015874: WildFly 8(\\..*)* .* started in \\d+ms .*");
    private static final Pattern WILDFLY_8_STARTING_ML = Pattern.compile(".*JBAS015899: WildFly 8(\\..*)* .* starting");
    private static final Pattern WILDFLY_9_STARTED_ML = Pattern.compile(".*WFLYSRV0050: WildFly Full \\d+(\\..*)* .* started in \\d+ms .*");
    private static final Pattern WILDFLY_STARTING_ML = Pattern.compile(".*WFLYSRV0049: WildFly .* \\d+(\\..*)* .* starting");
    private static final Pattern WILDFLY_10_STARTED_ML = Pattern.compile(".*WFLYSRV0025: WildFly .* \\d+(\\..*)* .* started in \\d+ms .*");
    private static final Pattern EAP6_STARTED_ML = Pattern.compile(".*JBAS015874: JBoss EAP 6\\.[0-9]{0,2}?.[0-9]{0,2}?\\.GA .* \\d+ms .*");
    private static final Pattern EAP6_STARTING_ML = Pattern.compile(".*JBAS015899: JBoss EAP 6\\.[0-9]{0,2}?.[0-9]{0,2}?\\.GA .*");
    private static final Pattern EAP7_STARTED_ML = Pattern.compile(".*WFLYSRV0025: JBoss EAP 7\\.[0-9]{0,2}?.[0-9]{0,2}?\\.GA .* \\d+\\s?ms .*");
    private static final Pattern EAP7_STARTING_ML = Pattern.compile(".*WFLYSRV0049: JBoss EAP 7\\.[0-9]{0,2}?.[0-9]{0,2}?\\.GA .*");

    public static boolean isStarting(String line) {
        return line.contains("Starting JBoss (MX MicroKernel)") || line.contains("Starting JBoss (Microcontainer)") || line.contains("Starting JBossAS") || WILDFLY_8_STARTING_ML.matcher(line).matches() || WILDFLY_STARTING_ML.matcher(line).matches() || EAP6_STARTING_ML.matcher(line).matches() || EAP7_STARTING_ML.matcher(line).matches();
    }

    public static boolean isStarted(String line) {
        return (line.contains("JBoss (MX MicroKernel)") || line.contains("JBoss (Microcontainer)") || line.contains("JBossAS") || line.contains("JBoss AS")) && line.contains("Started in") || line.contains("started in") || line.contains("started (with errors) in") || JBOSS_7_STARTED_ML.matcher(line).matches() || WILDFLY_8_STARTED_ML.matcher(line).matches() || WILDFLY_9_STARTED_ML.matcher(line).matches() || WILDFLY_10_STARTED_ML.matcher(line).matches() || EAP6_STARTED_ML.matcher(line).matches() || EAP7_STARTED_ML.matcher(line).matches();
    }
}

