/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javaee.wildfly.config.xml.ds;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.netbeans.modules.j2ee.deployment.common.api.Datasource;
import org.netbeans.modules.javaee.wildfly.config.WildflyDatasource;
import org.netbeans.modules.javaee.wildfly.config.xml.ds.WildflyDataSource;
import org.netbeans.modules.javaee.wildfly.config.xml.ds.WildflyDatasourceHandler;
import org.netbeans.modules.javaee.wildfly.config.xml.ds.WildflyDriver;
import org.netbeans.modules.javaee.wildfly.config.xml.ds.WildflyDriversHandler;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class WildflyDatasourcesHandler
extends DefaultHandler {
    private final XMLReader parser;
    private final Set<Datasource> datasources = new HashSet<Datasource>();
    private final Set<WildflyDataSource> parsedDatasources = new HashSet<WildflyDataSource>();
    boolean isDatasource = false;
    private WildflyDatasourceHandler datasourceHandler;
    private WildflyDriversHandler driversHandler;

    public WildflyDatasourcesHandler(XMLReader parser) {
        this.parser = parser;
    }

    public Set<Datasource> getDatasources() {
        return this.datasources;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        boolean bl = this.isDatasource = this.isDatasource || "datasources".equals(qName);
        if (this.isDatasource) {
            if ("datasource".equals(qName)) {
                this.datasourceHandler = new WildflyDatasourceHandler(this, this.parser);
                this.datasourceHandler.start(uri, localName, qName, attributes);
            } else if ("drivers".equals(qName)) {
                this.driversHandler = new WildflyDriversHandler(this, this.parser);
                this.driversHandler.start(uri, localName, qName, attributes);
            }
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (this.isDatasource) {
            if ("datasource".equals(qName)) {
                this.parsedDatasources.add(this.datasourceHandler.getDatasource());
                this.datasourceHandler = null;
            } else if ("drivers".equals(qName)) {
                Map<String, WildflyDriver> drivers = this.driversHandler.getDrivers();
                for (WildflyDataSource ds : this.parsedDatasources) {
                    if (!drivers.containsKey(ds.getDriver())) continue;
                    ds.setDriver(drivers.get(ds.getDriver()).getDriverClass());
                }
                this.driversHandler = null;
            } else if ("datasources".equals(qName)) {
                for (WildflyDataSource ds : this.parsedDatasources) {
                    this.datasources.add(new WildflyDatasource(ds.getName(), ds.getJndiName(), ds.getUrl(), ds.getUsername(), ds.getPassword(), ds.getDriver()));
                }
            }
        }
    }
}

