/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.glassfish.javaee;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.glassfish.common.parser.TreeParser;
import org.netbeans.modules.glassfish.javaee.Hk2DeploymentManager;
import org.netbeans.modules.glassfish.spi.GlassfishModule;
import org.netbeans.modules.glassfish.tooling.GlassFishIdeException;
import org.netbeans.modules.glassfish.tooling.TaskState;
import org.netbeans.modules.glassfish.tooling.admin.CommandAddResources;
import org.netbeans.modules.glassfish.tooling.admin.CommandGetProperty;
import org.netbeans.modules.glassfish.tooling.admin.CommandSetProperty;
import org.netbeans.modules.glassfish.tooling.admin.ResultMap;
import org.netbeans.modules.glassfish.tooling.admin.ResultString;
import org.netbeans.modules.glassfish.tooling.data.GlassFishServer;
import org.netbeans.modules.j2ee.deployment.common.api.ConfigurationException;
import org.netbeans.modules.j2ee.deployment.common.api.SourceFileMap;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class ResourceRegistrationHelper {
    private static final int TIMEOUT = 2000;

    private ResourceRegistrationHelper() {
    }

    public static void deployResources(File root, Hk2DeploymentManager dm) {
        Set<File> resourceDirs = ResourceRegistrationHelper.getResourceDirs(root);
        ResourceRegistrationHelper.deployResources(resourceDirs, dm);
    }

    private static void deployResources(Set<File> resourceDirs, Hk2DeploymentManager dm) {
        for (File resourceDir : resourceDirs) {
            try {
                boolean usedNewName = ResourceRegistrationHelper.registerResourceDir(resourceDir, dm, dm.getCommonServerSupport().getResourcesXmlName());
                if (usedNewName) continue;
                ResourceRegistrationHelper.registerResourceDir(resourceDir, dm, "sun-resources");
            }
            catch (ConfigurationException ex) {
                Logger.getLogger("glassfish-javaee").log(Level.INFO, "some data sources may not be deployed", ex);
            }
        }
    }

    private static Set<File> getResourceDirs(File file) {
        File[] erds;
        TreeSet<File> retVal = new TreeSet<File>();
        FileObject fo = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)file));
        SourceFileMap sourceFileMap = SourceFileMap.findSourceMap((FileObject)fo);
        if (sourceFileMap != null && null != (erds = sourceFileMap.getEnterpriseResourceDirs())) {
            for (File f : erds) {
                if (null == f || f.getPath() == null) continue;
                retVal.add(f);
            }
        }
        return retVal;
    }

    private static boolean registerResourceDir(File resourceDir, Hk2DeploymentManager dm, String baseName) throws ConfigurationException {
        boolean succeeded = false;
        File sunResourcesXml = new File(resourceDir, baseName + ".xml");
        if (sunResourcesXml.exists()) {
            ResourceRegistrationHelper.checkUpdateServerResources(sunResourcesXml, dm);
            GlassfishModule commonSupport = dm.getCommonServerSupport();
            String uri = (String)commonSupport.getInstanceProperties().get("url");
            String target = Hk2DeploymentManager.getTargetFromUri(uri);
            try {
                ResultString result = CommandAddResources.addResource((GlassFishServer)commonSupport.getInstance(), (File)sunResourcesXml, (String)target);
                return result.getState() == TaskState.COMPLETED;
            }
            catch (GlassFishIdeException gfie) {
                Logger.getLogger("glassfish-javaee").log(Level.INFO, gfie.getLocalizedMessage(), gfie);
                throw new ConfigurationException(gfie.getLocalizedMessage(), (Throwable)gfie);
            }
        }
        return succeeded;
    }

    private static void checkUpdateServerResources(File sunResourcesXml, Hk2DeploymentManager dm) {
        Map<String, String> changedData = new HashMap<String, String>();
        ArrayList<TreeParser.Path> pathList = new ArrayList<TreeParser.Path>();
        ResourceFinder cpFinder = new ResourceFinder("name");
        pathList.add(new TreeParser.Path("/resources/jdbc-connection-pool", (TreeParser.NodeReader)cpFinder));
        ResourceFinder jdbcFinder = new ResourceFinder("jndi-name");
        pathList.add(new TreeParser.Path("/resources/jdbc-resource", (TreeParser.NodeReader)jdbcFinder));
        ResourceFinder connectorPoolFinder = new ResourceFinder("name");
        pathList.add(new TreeParser.Path("/resources/connector-connection-pool", (TreeParser.NodeReader)connectorPoolFinder));
        ResourceFinder connectorFinder = new ResourceFinder("jndi-name");
        pathList.add(new TreeParser.Path("/resources/connector-resource", (TreeParser.NodeReader)connectorFinder));
        ResourceFinder aoFinder = new ResourceFinder("jndi-name");
        pathList.add(new TreeParser.Path("/resources/admin-object-resource", (TreeParser.NodeReader)aoFinder));
        ResourceFinder mailFinder = new ResourceFinder("jndi-name");
        pathList.add(new TreeParser.Path("/resources/mail-resource", (TreeParser.NodeReader)mailFinder));
        try {
            TreeParser.readXml((File)sunResourcesXml, pathList);
        }
        catch (IllegalStateException ex) {
            Logger.getLogger("glassfish-javaee").log(Level.INFO, ex.getLocalizedMessage(), ex);
        }
        Map<String, String> allRemoteData = ResourceRegistrationHelper.getResourceData("resources.*", dm);
        changedData = ResourceRegistrationHelper.checkResources(cpFinder, "resources.jdbc-connection-pool.", allRemoteData, changedData, dm);
        changedData = ResourceRegistrationHelper.checkResources(jdbcFinder, "resources.jdbc-resource.", allRemoteData, changedData, dm);
        changedData = ResourceRegistrationHelper.checkResources(connectorPoolFinder, "resources.connector-connection-pool.", allRemoteData, changedData, dm);
        changedData = ResourceRegistrationHelper.checkResources(connectorFinder, "resources.connector-resource.", allRemoteData, changedData, dm);
        changedData = ResourceRegistrationHelper.checkResources(aoFinder, "resources.admin-object-resource.", allRemoteData, changedData, dm);
        changedData = ResourceRegistrationHelper.checkResources(mailFinder, "resources.mail-resource.", allRemoteData, changedData, dm);
        if (changedData.size() > 0) {
            ResourceRegistrationHelper.putResourceData(changedData, dm);
        }
    }

    private static Map<String, String> checkResources(ResourceFinder resourceFinder, String prefix, Map<String, String> allRemoteData, Map<String, String> changedData, Hk2DeploymentManager dm) {
        List<String> resources = resourceFinder.getResourceNames();
        for (int i = 0; i < resources.size(); ++i) {
            String jndiName = resources.get(i);
            Map<String, String> localData = resourceFinder.getResourceData().get(jndiName);
            String remoteKey = prefix + jndiName + ".";
            HashMap<String, String> remoteData = new HashMap<String, String>();
            for (String key : allRemoteData.keySet()) {
                if (!key.startsWith(remoteKey)) continue;
                remoteData.put(key, allRemoteData.get(key));
            }
            if (remoteData.size() <= 0) continue;
            changedData = ResourceRegistrationHelper.getChangedData(remoteData, localData, changedData, remoteKey);
        }
        return changedData;
    }

    private static Map<String, String> getChangedData(Map<String, String> remoteData, Map<String, String> localData, Map<String, String> changedData, String resourceKey) {
        ArrayList<String> props = new ArrayList<String>();
        Iterator<String> keys = remoteData.keySet().iterator();
        Set<String> localKeySet = localData.keySet();
        while (keys.hasNext()) {
            String localValue;
            String remoteDataKey = keys.next();
            String remoteValue = remoteData.get(remoteDataKey);
            String[] split = remoteDataKey.split(resourceKey);
            String key = split[1];
            if (key.indexOf("property.") != -1) {
                props.add(key);
            }
            if ((localValue = localData.get(key)) != null) {
                if (remoteValue != null && localValue.equals(remoteValue)) continue;
                changedData.put(remoteDataKey, localValue);
                continue;
            }
            if (!localKeySet.contains(key) || remoteValue == null) continue;
            changedData.put(remoteDataKey, localValue);
        }
        for (String key : localData.keySet()) {
            if (key.indexOf("property.") == -1 || props.contains(key)) continue;
            String remoteKey = resourceKey + key;
            changedData.put(remoteKey, localData.get(key));
        }
        return changedData;
    }

    public static Map<String, String> getResourceData(String query, Hk2DeploymentManager dm) {
        try {
            ResultMap result = CommandGetProperty.getProperties((GlassFishServer)dm.getCommonServerSupport().getInstance(), (String)query);
            if (result.getState() == TaskState.COMPLETED) {
                Map values = result.getValue();
                if (values.isEmpty()) {
                    Logger.getLogger("glassfish-javaee").log(Level.INFO, null, new IllegalStateException(query + " has no data"));
                }
                return values;
            }
        }
        catch (GlassFishIdeException gfie) {
            Logger.getLogger("glassfish-javaee").log(Level.INFO, "Could not retrieve property from server.", gfie);
        }
        return new HashMap<String, String>();
    }

    public static void putResourceData(Map<String, String> data, Hk2DeploymentManager dm) {
        Set<String> keys = data.keySet();
        Iterator<String> iterator = keys.iterator();
        while (iterator.hasNext()) {
            String k;
            String name = k = iterator.next();
            String value = data.get(k);
            try {
                GlassfishModule support = dm.getCommonServerSupport();
                CommandSetProperty command = support.getCommandFactory().getSetPropertyCommand(name, value);
                CommandSetProperty.setProperty((GlassFishServer)support.getInstance(), (CommandSetProperty)command);
            }
            catch (GlassFishIdeException gfie) {
                Logger.getLogger("glassfish-javaee").log(Level.INFO, gfie.getMessage(), gfie);
            }
        }
    }

    public static class ResourceFinder
    extends TreeParser.NodeReader {
        private Map<String, String> properties = null;
        private Map<String, Map<String, String>> resourceData = new HashMap<String, Map<String, String>>();
        private final String nameKey;

        public ResourceFinder(String in_nameKey) {
            this.nameKey = in_nameKey;
        }

        public void readAttributes(String qname, Attributes attributes) throws SAXException {
            this.properties = new HashMap<String, String>();
            String resourceName = attributes.getValue(this.nameKey);
            this.properties.put(this.nameKey, resourceName);
            int attrLen = attributes.getLength();
            for (int i = 0; i < attrLen; ++i) {
                String name = attributes.getLocalName(i);
                String value = attributes.getValue(i);
                if (name == null || name.length() <= 0 || value == null || value.length() <= 0) continue;
                this.properties.put(name, value);
            }
        }

        public void readChildren(String qname, Attributes attributes) throws SAXException {
            if (null != this.properties && null != attributes) {
                String propName = qname + "." + attributes.getValue("name");
                this.properties.put(propName, attributes.getValue("value"));
            }
        }

        public void endNode(String qname) throws SAXException {
            String poolName = this.properties.get(this.nameKey);
            this.resourceData.put(poolName, this.properties);
        }

        public List<String> getResourceNames() {
            return new ArrayList<String>(this.resourceData.keySet());
        }

        public Map<String, Map<String, String>> getResourceData() {
            return Collections.unmodifiableMap(this.resourceData);
        }
    }
}

