/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.glassfish.javaee;

import java.io.File;
import java.util.Collections;
import java.util.Set;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeApplicationProvider;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.netbeans.modules.javaee.specs.support.api.util.JndiNamespacesDefinition;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public final class ApplicationScopedResourcesUtils {
    private ApplicationScopedResourcesUtils() {
    }

    public static ResourceFileDescription checkNamespaces(J2eeModule module, ResourceFileDescription fileDesc, String namespace) {
        Set<String> ns;
        if (fileDesc.isIsApplicationScoped() && namespace == null && !(ns = fileDesc.getNamespaces()).contains("java:app") && !ns.contains("java:module")) {
            String customNamespace = null;
            customNamespace = ApplicationScopedResourcesUtils.isEarChild(fileDesc.getFile()) ? "java:module" : "java:app";
            return new ResourceFileDescription(fileDesc.getFile(), fileDesc.isIsApplicationScoped(), Collections.singleton(customNamespace));
        }
        return fileDesc;
    }

    public static String getJndiName(String jndiName, ResourceFileDescription fileDesc) {
        if (!fileDesc.isIsApplicationScoped()) {
            return jndiName;
        }
        String realJndiName = jndiName;
        Set<String> ns = fileDesc.getNamespaces();
        realJndiName = ns.isEmpty() ? JndiNamespacesDefinition.normalize((String)realJndiName, (String)"java:app") : (ns.contains("java:module") ? JndiNamespacesDefinition.normalize((String)realJndiName, (String)"java:module") : JndiNamespacesDefinition.normalize((String)realJndiName, (String)"java:app"));
        return realJndiName;
    }

    public static boolean isEarChild(File file) {
        FileObject fo = FileUtil.toFileObject((File)file);
        assert (fo != null);
        if (fo == null) {
            return false;
        }
        Project p = FileOwnerQuery.getOwner((FileObject)fo);
        if (p == null) {
            return false;
        }
        return ApplicationScopedResourcesUtils.isEarChild(p);
    }

    public static boolean isEarChild(Project project) {
        Project[] allProjects;
        J2eeModuleProvider childProvider = (J2eeModuleProvider)project.getLookup().lookup(J2eeModuleProvider.class);
        if (childProvider == null || childProvider instanceof J2eeApplicationProvider) {
            return false;
        }
        for (Project candidate : allProjects = OpenProjects.getDefault().getOpenProjects()) {
            J2eeApplicationProvider app = (J2eeApplicationProvider)candidate.getLookup().lookup(J2eeApplicationProvider.class);
            if (app == null) continue;
            for (J2eeModuleProvider p : app.getChildModuleProviders()) {
                if (!p.equals(childProvider)) continue;
                return true;
            }
        }
        return false;
    }

    public static class ResourceFileDescription {
        private final File file;
        private final boolean isApplicationScoped;
        private final Set<String> namespaces;

        public ResourceFileDescription(File file, boolean isApplicationScoped, Set<String> namespaces) {
            this.file = file;
            this.isApplicationScoped = isApplicationScoped;
            this.namespaces = namespaces;
        }

        public File getFile() {
            return this.file;
        }

        public boolean isIsApplicationScoped() {
            return this.isApplicationScoped;
        }

        public Set<String> getNamespaces() {
            return this.namespaces;
        }
    }

    public static interface JndiNameResolver {
        public String resolveJndiName(String var1);
    }
}

