/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.ui;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Point;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ResourceBundle;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.JTextComponent;
import javax.swing.text.Utilities;
import org.netbeans.api.editor.DialogBinding;
import org.netbeans.modules.debugger.ui.Utils;
import org.netbeans.spi.debugger.ui.EditorContextDispatcher;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.text.Line;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.windows.WindowManager;

public class WatchPanel {
    private JPanel panel;
    private JTextComponent editorPane;
    private String expression;

    public WatchPanel(String expression) {
        this.expression = expression;
    }

    public JComponent getPanel() {
        JComponent[] editorComponents;
        if (this.panel != null) {
            return this.panel;
        }
        this.panel = new JPanel();
        ResourceBundle bundle = NbBundle.getBundle(WatchPanel.class);
        this.panel.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_WatchPanel"));
        JLabel textLabel = new JLabel();
        Mnemonics.setLocalizedText((JLabel)textLabel, (String)bundle.getString("CTL_Watch_Name"));
        textLabel.setBorder(new EmptyBorder(0, 0, 5, 0));
        this.panel.setLayout(new BorderLayout());
        this.panel.setBorder(new EmptyBorder(11, 12, 1, 11));
        this.panel.add("North", textLabel);
        final FileObject file = WatchPanel.getRecentFile();
        int line = EditorContextDispatcher.getDefault().getMostRecentLineNumber();
        int column = WatchPanel.getRecentColumn();
        String mimeType = file != null ? file.getMIMEType() : "text/plain";
        boolean doBind = true;
        if (!mimeType.startsWith("text/") && !mimeType.startsWith("application/")) {
            mimeType = "text/plain";
            doBind = false;
        }
        try {
            editorComponents = org.netbeans.editor.Utilities.createSingleLineEditor((String)mimeType);
        }
        catch (IllegalArgumentException iaex) {
            editorComponents = org.netbeans.editor.Utilities.createSingleLineEditor((String)"text/plain");
            doBind = false;
        }
        JScrollPane sp = (JScrollPane)editorComponents[0];
        this.editorPane = (JTextComponent)editorComponents[1];
        int h = sp.getPreferredSize().height;
        int w = Math.min(70 * this.editorPane.getFontMetrics(this.editorPane.getFont()).charWidth('a'), WindowManager.getDefault().getMainWindow().getSize().width);
        sp.setPreferredSize(new Dimension(w, h));
        if (doBind) {
            final Point lineCol = WatchPanel.adjustLineAndColumn(file, line, column);
            if (file != null && lineCol.x >= 0) {
                DialogBinding.bindComponentToFile((FileObject)file, (int)(lineCol.x - 1), (int)lineCol.y, (int)0, (JTextComponent)this.editorPane);
            }
            RequestProcessor.getDefault().post(new Runnable(){
                final /* synthetic */ WatchPanel this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void run() {
                    final Point adjustedLineCol = WatchPanel.adjustLineAndColumn(file, lineCol.x, lineCol.y);
                    if (!adjustedLineCol.equals(lineCol)) {
                        SwingUtilities.invokeLater(new Runnable(){
                            final /* synthetic */ 1 this$1;
                            {
                                this.this$1 = this$1;
                            }

                            @Override
                            public void run() {
                                DialogBinding.bindComponentToFile((FileObject)file, (int)(adjustedLineCol.x - 1), (int)adjustedLineCol.y, (int)0, (JTextComponent)this.this$1.this$0.editorPane);
                            }
                        });
                    }
                }
            });
        }
        this.panel.add("Center", sp);
        this.editorPane.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_CTL_Watch_Name"));
        String t = Utils.getIdentifier();
        if (t != null) {
            this.editorPane.setText(t);
        } else {
            this.editorPane.setText(this.expression);
        }
        this.editorPane.selectAll();
        textLabel.setLabelFor(this.editorPane);
        this.editorPane.requestFocus();
        return this.panel;
    }

    public static FileObject getRecentFile() {
        Line mostRecentLine;
        FileObject fo = EditorContextDispatcher.getDefault().getMostRecentFile();
        if (fo == null && (mostRecentLine = EditorContextDispatcher.getDefault().getMostRecentLine()) != null) {
            fo = (FileObject)mostRecentLine.getLookup().lookup(FileObject.class);
        }
        return fo;
    }

    public static int getRecentColumn() {
        Caret caret;
        JEditorPane mostRecentEditor = EditorContextDispatcher.getDefault().getMostRecentEditor();
        if (mostRecentEditor != null && (caret = mostRecentEditor.getCaret()) != null) {
            int offset = caret.getDot();
            try {
                int rs = Utilities.getRowStart(mostRecentEditor, offset);
                return offset - rs;
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
        return 0;
    }

    public String getExpression() {
        return this.editorPane.getText().trim();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Point adjustLineAndColumn(FileObject fo, int theLine, int theColumn) {
        BufferedReader br;
        if (theLine == -1) {
            theLine = 1;
        }
        if (fo == null) {
            return new Point(theLine, theColumn);
        }
        if (!"java".equalsIgnoreCase(fo.getExt())) {
            return new Point(theLine, theColumn);
        }
        try {
            br = new BufferedReader(new InputStreamReader(fo.getInputStream()));
        }
        catch (FileNotFoundException ex) {
            return new Point(theLine, theColumn);
        }
        try {
            int line = WatchPanel.findClassLine(br);
            Point lc = WatchPanel.findMethodLineColumn(line, theColumn, br);
            if (theLine < lc.x) {
                Point point = lc;
                return point;
            }
        }
        catch (IOException iOException) {
        }
        finally {
            try {
                br.close();
            }
            catch (IOException iOException) {}
        }
        return new Point(theLine, theColumn);
    }

    private static int findClassLine(BufferedReader br) throws IOException {
        String line;
        int l = 1;
        boolean comment = false;
        boolean classDecl = false;
        while ((line = br.readLine()) != null) {
            if (classDecl) {
                if (line.indexOf(123) >= 0) {
                    return l + 1;
                }
            } else {
                boolean slash = false;
                boolean asterix = false;
                for (int i = 0; i < line.length(); ++i) {
                    char c = line.charAt(i);
                    if (comment) {
                        if (asterix && c == '/') {
                            comment = false;
                            asterix = false;
                            continue;
                        }
                        asterix = c == '*';
                        continue;
                    }
                    if (slash && c == '*') {
                        comment = true;
                        slash = false;
                        continue;
                    }
                    if (c == '/') {
                        if (slash) break;
                        slash = true;
                    }
                    if (c != 'c' || line.length() < i + "class".length() || !"lass".equals(line.substring(i + 1, i + 5))) continue;
                    classDecl = true;
                    if (line.indexOf(123, i + 5) <= 0) continue;
                    return l + 1;
                }
            }
            ++l;
        }
        return 1;
    }

    private static Point findMethodLineColumn(int l, int col, BufferedReader br) throws IOException {
        String line;
        int origLine = l;
        boolean isParenthesis = false;
        boolean isThrows = false;
        while ((line = br.readLine()) != null) {
            int i = 0;
            if (!isParenthesis && (i = line.indexOf(41)) >= 0 || isParenthesis) {
                isParenthesis = true;
                if (!isThrows) {
                    ++i;
                    while (i < line.length() && Character.isWhitespace(line.charAt(i))) {
                        ++i;
                    }
                    if (i + "throws".length() < line.length() && "throws".equals(line.substring(i, i + "throws".length()))) {
                        isThrows = true;
                    }
                }
                if (isThrows && (i = line.indexOf("{", i)) < 0) {
                    i = line.length();
                }
                if (i < line.length()) {
                    if (line.charAt(i) == '{') {
                        return new Point(l, i + 1);
                    }
                    isParenthesis = false;
                }
            }
            ++l;
        }
        return new Point(origLine, col);
    }
}

