/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jsf.icefaces;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.api.project.libraries.LibraryManager;
import org.netbeans.modules.j2ee.common.ClasspathUtil;
import org.netbeans.modules.web.jsf.icefaces.Bundle;
import org.netbeans.modules.web.jsf.icefaces.Icefaces2Implementation;
import org.netbeans.modules.web.jsf.icefaces.ui.Icefaces2CustomizerPanelVisual;
import org.netbeans.modules.web.jsf.spi.components.JsfComponentCustomizer;
import org.openide.util.ChangeSupport;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.RequestProcessor;

public class Icefaces2Customizer
implements JsfComponentCustomizer {
    private static final Logger LOGGER = Logger.getLogger(Icefaces2Customizer.class.getName());
    private Icefaces2CustomizerPanelVisual panel;
    private ChangeSupport changeSupport = new ChangeSupport((Object)this);
    private Future<Boolean> result = null;
    private boolean fixedLibrary = false;

    public void addChangeListener(ChangeListener listener) {
        this.changeSupport.addChangeListener(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.changeSupport.removeChangeListener(listener);
    }

    public JComponent getComponent() {
        if (this.panel == null) {
            this.panel = new Icefaces2CustomizerPanelVisual(this);
            this.panel.initLibraries(true);
        }
        return this.panel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isValid() {
        Preferences preferences = Icefaces2Implementation.getIcefacesPreferences();
        String icefacesLibrary = preferences.get("preffered-library", "");
        if (LibraryManager.getDefault().getLibrary(icefacesLibrary) != null) {
            return true;
        }
        Icefaces2Customizer icefaces2Customizer = this;
        synchronized (icefaces2Customizer) {
            if (this.result == null) {
                this.result = RequestProcessor.getDefault().submit((Callable)new Callable<Boolean>(){

                    @Override
                    public Boolean call() throws Exception {
                        for (Library library : LibraryManager.getDefault().getLibraries()) {
                            List content;
                            if (!"j2se".equals(library.getType()) || !Icefaces2Customizer.isValidIcefacesLibrary(content = library.getContent("classpath"))) continue;
                            this.refreshParentValidation();
                            return true;
                        }
                        this.refreshParentValidation();
                        return false;
                    }

                    private void refreshParentValidation() {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                Icefaces2Customizer.this.fireChange();
                            }
                        });
                    }
                });
            } else {
                if (!this.result.isDone()) {
                    return false;
                }
                try {
                    return this.result.get() != false || this.fixedLibrary;
                }
                catch (InterruptedException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                catch (ExecutionException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        }
        return false;
    }

    public String getErrorMessage() {
        if (this.result == null && !this.isValid() || this.result != null && !this.result.isDone()) {
            return Bundle.Icefaces2Customizer_err_searching_icefaces_library();
        }
        return this.panel.getErrorMessage();
    }

    public String getWarningMessage() {
        return this.panel.getWarningMessage();
    }

    public void saveConfiguration() {
        Preferences preferences = Icefaces2Implementation.getIcefacesPreferences();
        if (this.panel.getIcefacesLibrary() != null) {
            preferences.put("preffered-library", this.panel.getIcefacesLibrary());
        }
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    public void setFixedLibrary(boolean fixed) {
        this.fixedLibrary = fixed;
    }

    public void fireChange() {
        this.changeSupport.fireChange();
    }

    public static List<Library> getIcefacesLibraries() {
        ArrayList<Library> libraries = new ArrayList<Library>();
        for (Library library : LibraryManager.getDefault().getLibraries()) {
            List content;
            if (!"j2se".equals(library.getType()) || !Icefaces2Customizer.isValidIcefacesLibrary(content = library.getContent("classpath"))) continue;
            libraries.add(library);
        }
        return libraries;
    }

    public static boolean isValidIcefacesLibrary(List<URL> libraryContent) {
        try {
            return ClasspathUtil.containsClass(libraryContent, (String)"org.icefaces.impl.facelets.tag.icefaces.core.ConfigHandler");
        }
        catch (IOException ex) {
            LOGGER.log(Level.INFO, null, ex);
            return false;
        }
    }
}

