/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.persistence;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.persistence.spi.PersistenceLocationProvider;
import org.netbeans.modules.maven.api.FileUtilities;
import org.netbeans.modules.maven.api.NbMavenProject;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;

public class PersistenceLocationProviderImpl
implements PersistenceLocationProvider,
PropertyChangeListener {
    static final String DEF_LOCATION = "src/main/resources/META-INF";
    static final String DEF_PERSISTENCE = "src/main/resources/META-INF/persistence.xml";
    static final String ALT_PERSISTENCE = "src/main/java/META-INF/persistence.xml";
    static final String REL_PERSISTENCE = "META-INF/persistence.xml";
    static final String REL_LOCATION = "META-INF";
    private Project project = null;
    private FileObject location = null;
    private File projectDir = null;
    private File persistenceXml = null;
    private boolean initialized = false;
    private final NbMavenProject mproject;

    public PersistenceLocationProviderImpl(Project proj, NbMavenProject mProj) {
        this.project = proj;
        this.mproject = mProj;
        this.projectDir = FileUtil.toFile((FileObject)proj.getProjectDirectory());
    }

    public FileObject getLocation() {
        this.initPXmlLocation(false);
        return this.location;
    }

    public FileObject createLocation() throws IOException {
        URI[] resources;
        FileObject retVal = null;
        URI[] uRIArray = resources = this.mproject != null ? this.mproject.getResources(false) : null;
        if (resources != null && resources.length > 0) {
            try {
                FileObject res = URLMapper.findFileObject((URL)resources[0].toURL());
                retVal = res.getFileObject(REL_LOCATION);
                if (retVal == null) {
                    retVal = res.createFolder(REL_LOCATION);
                }
            }
            catch (Exception res) {
                // empty catch block
            }
        }
        if (retVal == null) {
            File defaultLocation = FileUtilities.resolveFilePath((File)this.projectDir, (String)DEF_LOCATION);
            if (!defaultLocation.exists()) {
                retVal = FileUtil.createFolder((FileObject)this.project.getProjectDirectory(), (String)DEF_LOCATION);
            }
            this.location = retVal = FileUtil.toFileObject((File)defaultLocation);
        }
        return retVal;
    }

    protected File getPersistenceXml() {
        this.initPXmlLocation(false);
        return this.persistenceXml;
    }

    private void initPXmlLocation(boolean forced) {
        if (!this.initialized || forced) {
            this.persistenceXml = this.findPersistenceXml();
            this.location = FileUtil.toFileObject((File)this.persistenceXml.getParentFile());
            this.initialized = true;
        }
    }

    private File findPersistenceXml() {
        File retVal = null;
        File defaultLocation = FileUtilities.resolveFilePath((File)this.projectDir, (String)DEF_PERSISTENCE);
        if (defaultLocation.exists()) {
            retVal = defaultLocation;
        } else {
            File altLocation = FileUtilities.resolveFilePath((File)this.projectDir, (String)ALT_PERSISTENCE);
            if (altLocation.exists()) {
                retVal = altLocation;
            } else {
                URI[] resources;
                URI[] uRIArray = resources = this.mproject != null ? this.mproject.getResources(false) : null;
                if (resources != null && resources.length > 0) {
                    try {
                        FileObject res = URLMapper.findFileObject((URL)resources[0].toURL());
                        File file = retVal = res != null ? FileUtilities.resolveFilePath((File)FileUtil.toFile((FileObject)res), (String)REL_PERSISTENCE) : null;
                        if (retVal == null || !retVal.exists()) {
                            retVal = defaultLocation;
                        }
                    }
                    catch (MalformedURLException ex) {
                        retVal = defaultLocation;
                    }
                } else {
                    retVal = defaultLocation;
                }
            }
        }
        return retVal;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("MavenPersistence".equals(evt.getPropertyName())) {
            this.initPXmlLocation(true);
        }
    }
}

