/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.nativeimage.debugger.displayer;

import java.util.HashSet;
import java.util.Map;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.modules.java.nativeimage.debugger.displayer.Utils;
import org.netbeans.modules.nativeimage.api.debug.NIVariable;

final class DynamicHub {
    private static final String HUB = "hub";
    private static final String HUB_TYPE = "hubType";
    private static final int HUB_TYPE_INSTANCE = 2;
    private static final int HUB_TYPE_ARRAY = 4;
    private static final String OBJ_HEADER = "_objhdr";
    private static final String NAME = "name";
    private final NIVariable hub;
    private final Map<String, NIVariable> childrenByName;

    private DynamicHub(NIVariable hub) {
        this.hub = hub;
        this.childrenByName = Utils.getVarsByName(hub.getChildren());
    }

    @CheckForNull
    static DynamicHub find(NIVariable var) {
        NIVariable object = DynamicHub.findObjectType(var);
        if (object == null) {
            return null;
        }
        NIVariable[] children = object.getChildren();
        NIVariable hub = Utils.findChild(children, OBJ_HEADER, "public", HUB, Class.class.getName(), "private");
        if (hub != null) {
            return new DynamicHub(hub);
        }
        return null;
    }

    @CheckForNull
    private static NIVariable findObjectType(NIVariable var) {
        NIVariable[] children = var.getChildren();
        if (children.length < 1) {
            return null;
        }
        if (children[0].getName().equals(Object.class.getName())) {
            return children[0];
        }
        HashSet<String> visitedNames = new HashSet<String>();
        var = children[0];
        do {
            if ((children = var.getChildren()).length < 1) {
                return null;
            }
            var = children[0];
            if (!var.getName().equals(Object.class.getName())) continue;
            return var;
        } while (visitedNames.add(var.getName()));
        return null;
    }

    @CheckForNull
    HubType getType() {
        NIVariable hubTypeVar = this.childrenByName.get(HUB_TYPE);
        if (hubTypeVar == null) {
            return null;
        }
        try {
            int hubType = Integer.parseInt(hubTypeVar.getValue());
            return HubType.getFrom(hubType);
        }
        catch (NumberFormatException ex) {
            return null;
        }
    }

    @CheckForNull
    NIVariable findClassNameVar() {
        return this.childrenByName.get(NAME);
    }

    static enum HubType {
        OBJECT,
        ARRAY;


        static HubType getFrom(int hubType) {
            if (hubType <= 2) {
                return OBJECT;
            }
            if (hubType >= 4) {
                return ARRAY;
            }
            return null;
        }
    }
}

