/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.nativeimage.debugger.api;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Consumer;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.api.extexecution.ExecutionDescriptor;
import org.netbeans.api.project.Project;
import org.netbeans.modules.java.nativeimage.debugger.api.Bundle;
import org.netbeans.modules.java.nativeimage.debugger.breakpoints.JPDABreakpointsHandler;
import org.netbeans.modules.java.nativeimage.debugger.displayer.JavaFrameDisplayer;
import org.netbeans.modules.java.nativeimage.debugger.displayer.JavaVariablesDisplayer;
import org.netbeans.modules.nativeimage.api.debug.NIDebugger;
import org.netbeans.modules.nativeimage.api.debug.StartDebugParameters;
import org.netbeans.modules.nativeimage.spi.debug.filters.FrameDisplayer;
import org.netbeans.modules.nativeimage.spi.debug.filters.VariableDisplayer;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;

public final class NIDebugRunner {
    private NIDebugRunner() {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public static NIDebugger start(File niFile, List<String> arguments, String debuggerCommand, Project project, String displayName, ExecutionDescriptor executionDescriptor, Consumer<DebuggerEngine> startedEngine) throws IllegalStateException {
        JavaVariablesDisplayer variablesDisplayer = new JavaVariablesDisplayer();
        JavaFrameDisplayer frameDisplayer = new JavaFrameDisplayer(project);
        NIDebugger debugger = NIDebugger.newBuilder().frameDisplayer((FrameDisplayer)frameDisplayer).variablesDisplayer((VariableDisplayer)variablesDisplayer).build();
        variablesDisplayer.setDebugger(debugger);
        JPDABreakpointsHandler breakpointsHandler = new JPDABreakpointsHandler(niFile, debugger);
        File workingDirectory = new File(System.getProperty("user.dir"));
        List<String> command = arguments.isEmpty() ? Collections.singletonList(niFile.getAbsolutePath()) : NIDebugRunner.join(niFile.getAbsolutePath(), arguments);
        DialogDisplayer displayer = DialogDisplayer.getDefault();
        debugger.start(command, workingDirectory, debuggerCommand, "debug " + niFile.getName(), executionDescriptor, engine -> {
            if (startedEngine != null) {
                startedEngine.accept((DebuggerEngine)engine);
            }
        }).thenRun(() -> breakpointsHandler.dispose());
        NIDebugRunner.checkVersion(debugger.getVersion(), displayer);
        return debugger;
    }

    public static NIDebugger start(File niFile, StartDebugParameters debugParameters, Project project, Consumer<DebuggerEngine> startedEngine) throws IllegalStateException {
        JavaVariablesDisplayer variablesDisplayer = new JavaVariablesDisplayer();
        JavaFrameDisplayer frameDisplayer = new JavaFrameDisplayer(project);
        NIDebugger debugger = NIDebugger.newBuilder().frameDisplayer((FrameDisplayer)frameDisplayer).variablesDisplayer((VariableDisplayer)variablesDisplayer).build();
        variablesDisplayer.setDebugger(debugger);
        JPDABreakpointsHandler breakpointsHandler = new JPDABreakpointsHandler(niFile, debugger);
        DialogDisplayer displayer = DialogDisplayer.getDefault();
        debugger.start(debugParameters, engine -> {
            if (startedEngine != null) {
                startedEngine.accept((DebuggerEngine)engine);
            }
        }).thenRun(() -> breakpointsHandler.dispose());
        NIDebugRunner.checkVersion(debugger.getVersion(), displayer);
        return debugger;
    }

    @Deprecated
    public static NIDebugger attach(File niFile, long processId, String debuggerCommand, Project project, Consumer<DebuggerEngine> startedEngine) throws IllegalStateException {
        JavaVariablesDisplayer variablesDisplayer = new JavaVariablesDisplayer();
        JavaFrameDisplayer frameDisplayer = new JavaFrameDisplayer(project);
        NIDebugger debugger = NIDebugger.newBuilder().frameDisplayer((FrameDisplayer)frameDisplayer).variablesDisplayer((VariableDisplayer)variablesDisplayer).build();
        variablesDisplayer.setDebugger(debugger);
        JPDABreakpointsHandler breakpointsHandler = new JPDABreakpointsHandler(niFile, debugger);
        DialogDisplayer displayer = DialogDisplayer.getDefault();
        CompletionStage future = debugger.attach(niFile.getAbsolutePath(), processId, debuggerCommand, engine -> {
            if (startedEngine != null) {
                startedEngine.accept((DebuggerEngine)engine);
            }
        }).thenRun(() -> breakpointsHandler.dispose());
        if (((CompletableFuture)future).isDone()) {
            throw new IllegalStateException("Failed to attach.");
        }
        NIDebugRunner.checkVersion(debugger.getVersion(), displayer);
        return debugger;
    }

    private static void checkVersion(String version, DialogDisplayer displayer) {
        String gdbVersion = "GNU gdb";
        int i = version.indexOf(gdbVersion);
        if (i >= 0) {
            String v;
            i += gdbVersion.length();
            int eol = version.indexOf("\\n", i = NIDebugRunner.skipParanthesis(version, i));
            if (eol > 0 && ((v = version.substring(i, eol).trim()).startsWith("8.") && !v.startsWith("8.0") || v.startsWith("9."))) {
                NotifyDescriptor.Message descriptor = new NotifyDescriptor.Message((Object)Bundle.MSG_GDBVersionBug(), 2);
                displayer.notifyLater((NotifyDescriptor)descriptor);
            }
        }
    }

    private static int skipParanthesis(String str, int i) {
        int p;
        while (i < str.length() && Character.isWhitespace(str.charAt(i))) {
            ++i;
        }
        if (i < str.length() && '(' == str.charAt(i) && (p = str.indexOf(41, i + 1)) > 0) {
            i = p + 1;
        }
        return i;
    }

    private static List<String> join(String first, List<String> next) {
        ArrayList<String> joined = new ArrayList<String>(next.size() + 1);
        joined.add(first);
        joined.addAll(next);
        return joined;
    }
}

