/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.menu;

import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import org.netbeans.modules.form.InPlaceEditLayer;
import org.netbeans.modules.form.RADComponent;
import org.netbeans.modules.form.RADVisualComponent;
import org.netbeans.modules.form.RADVisualContainer;
import org.netbeans.modules.form.menu.MenuEditLayer;

public class KeyboardMenuNavigator
extends KeyAdapter {
    MenuEditLayer menuEditLayer;
    private RADVisualContainer menuBarRAD;
    private RADVisualContainer currentMenuRAD;
    KeyboardFinishListener listener;

    public KeyboardMenuNavigator(MenuEditLayer menuEditLayer) {
        this.menuEditLayer = menuEditLayer;
        this.configure();
    }

    public void setCurrentMenuRAD(RADVisualContainer currentMenuRAD) {
        this.currentMenuRAD = currentMenuRAD;
        this.menuBarRAD = this.getMenuBarRad(currentMenuRAD);
    }

    private RADVisualContainer getMenuBarRad(RADComponent comp) {
        if (JMenuBar.class.isAssignableFrom(comp.getBeanClass())) {
            return (RADVisualContainer)comp;
        }
        if (comp.getParentComponent() == null) {
            return null;
        }
        return this.getMenuBarRad(comp.getParentComponent());
    }

    public void configure() {
        this.listener = new KeyboardFinishListener();
        this.menuEditLayer.formDesigner.getInPlaceEditLayer().addFinishListener(this.listener);
    }

    public void unconfigure() {
        this.menuEditLayer.formDesigner.getInPlaceEditLayer().removeFinishListener(this.listener);
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 40) {
            this.selectOffsetMenuItem(1);
        }
        if (e.getKeyCode() == 38) {
            this.selectOffsetMenuItem(-1);
        }
        if (e.getKeyCode() == 37) {
            this.selectOffsetMenu(-1);
        }
        if (e.getKeyCode() == 39) {
            this.selectOffsetMenu(1);
        }
        if (e.getKeyCode() == 32) {
            this.startEditing();
        }
        if (e.getKeyCode() == 113) {
            this.startEditing();
        }
        if (e.getKeyCode() == 65) {
            if (e.isShiftDown()) {
                this.selectNextMenuItem(-1);
            } else {
                this.selectNextMenuItem(1);
            }
        }
    }

    private void selectNextMenuItem(int offset) {
        RADVisualContainer newMenu;
        RADComponent selectedRADComponent;
        if (this.currentMenuRAD == null) {
            return;
        }
        if (!this.menuEditLayer.isComponentSelected()) {
            this.menuEditLayer.setSelectedRADComponent(this.currentMenuRAD.getSubComponent(0));
        }
        if (this.isJMenu(selectedRADComponent = this.menuEditLayer.getSingleSelectedComponent()) && offset == 1 && (newMenu = (RADVisualContainer)selectedRADComponent).getSubComponents().length > 0) {
            this.currentMenuRAD = newMenu;
            this.selectOffsetMenuItem(offset);
            return;
        }
        if (this.isLastItem(selectedRADComponent, this.currentMenuRAD) && offset == 1) {
            this.goUpOneLevelAndNext();
            return;
        }
        if (this.isFirstItem(selectedRADComponent, this.currentMenuRAD) && offset == -1) {
            this.goUpOneLevel();
            return;
        }
        this.selectOffsetMenuItem(offset);
    }

    private void selectOffsetMenuItem(int offset) {
        if (this.currentMenuRAD == null) {
            return;
        }
        if (this.currentMenuRAD.getSubComponents().length == 0) {
            this.menuEditLayer.setSelectedRADComponent(null);
            return;
        }
        if (!this.menuEditLayer.isComponentSelected()) {
            this.menuEditLayer.setSelectedRADComponent(this.currentMenuRAD.getSubComponent(0));
            return;
        }
        int index = this.currentMenuRAD.getIndexOf(this.menuEditLayer.getSingleSelectedComponent());
        if (index + offset >= 0 && index + offset < this.currentMenuRAD.getSubComponents().length) {
            this.menuEditLayer.setSelectedRADComponent(this.currentMenuRAD.getSubComponent(index + offset));
        } else if (index >= 0 && index < this.currentMenuRAD.getSubComponents().length) {
            this.menuEditLayer.setSelectedRADComponent(this.currentMenuRAD.getSubComponent(index));
        }
    }

    private boolean isJMenu(RADComponent comp) {
        return this.menuEditLayer.formDesigner.getComponent(comp) instanceof JMenu;
    }

    private void selectOffsetMenu(int offset) {
        RADVisualContainer menuRAD;
        if (this.isJMenu(this.menuEditLayer.getSingleSelectedComponent()) && (menuRAD = (RADVisualContainer)this.menuEditLayer.getSingleSelectedComponent()).getSubComponents() != null && menuRAD.getSubComponents().length > 0 && menuRAD.getSubComponent(0) != null) {
            RADVisualComponent firstItemRad = menuRAD.getSubComponent(0);
            this.menuEditLayer.showMenuPopup((JMenu)this.menuEditLayer.formDesigner.getComponent(this.menuEditLayer.getSingleSelectedComponent()));
            this.menuEditLayer.setSelectedRADComponent(firstItemRad);
            this.currentMenuRAD = menuRAD;
            return;
        }
        int index = this.menuBarRAD.getIndexOf(this.currentMenuRAD);
        if (index < 0) {
            if (offset < 0) {
                this.goUpOneLevel();
                return;
            }
            if (offset > 0) {
                this.currentMenuRAD = this.getTopLevelMenu(this.currentMenuRAD);
                index = this.menuBarRAD.getIndexOf(this.currentMenuRAD);
            }
        }
        if ((index += offset) < 0) {
            index = this.menuBarRAD.getSubComponents().length - 1;
        }
        if (index >= this.menuBarRAD.getSubComponents().length) {
            index = 0;
        }
        this.currentMenuRAD = (RADVisualContainer)this.menuBarRAD.getSubComponent(index);
        JMenu menu = (JMenu)this.menuEditLayer.formDesigner.getComponent(this.currentMenuRAD);
        this.menuEditLayer.openMenu(this.currentMenuRAD, menu);
        if (this.currentMenuRAD.getSubComponents().length > 0) {
            this.menuEditLayer.setSelectedRADComponent(this.currentMenuRAD.getSubComponents()[0]);
        }
    }

    private void goUpOneLevel() {
        this.menuEditLayer.setSelectedRADComponent(this.currentMenuRAD);
        this.currentMenuRAD = this.currentMenuRAD.getParentContainer();
    }

    private void goUpOneLevelAndNext() {
        this.menuEditLayer.setSelectedRADComponent(this.currentMenuRAD);
        this.currentMenuRAD = this.currentMenuRAD.getParentContainer();
        if (this.isLastItem(this.menuEditLayer.getSingleSelectedComponent(), this.currentMenuRAD)) {
            this.goUpOneLevelAndNext();
            return;
        }
        this.selectOffsetMenuItem(1);
    }

    private boolean isFirstItem(RADComponent comp, RADVisualContainer cont) {
        int index = cont.getIndexOf(comp);
        return index == 0;
    }

    private boolean isLastItem(RADComponent comp, RADVisualContainer cont) {
        int index = cont.getIndexOf(comp);
        return index == cont.getSubComponents().length - 1;
    }

    private RADVisualContainer getTopLevelMenu(RADVisualContainer currentMenuRAD) {
        if (this.menuBarRAD.getIndexOf(currentMenuRAD) >= 0) {
            return currentMenuRAD;
        }
        return this.getTopLevelMenu(currentMenuRAD.getParentContainer());
    }

    private void startEditing() {
        this.menuEditLayer.configureEditedComponent(this.menuEditLayer.getSingleSelectedComponent());
        this.menuEditLayer.formDesigner.startInPlaceEditing(this.menuEditLayer.getSingleSelectedComponent());
    }

    private class KeyboardFinishListener
    implements InPlaceEditLayer.FinishListener {
        private KeyboardFinishListener() {
        }

        @Override
        public void editingFinished(boolean changed) {
            if (KeyboardMenuNavigator.this.menuEditLayer.isVisible()) {
                KeyboardMenuNavigator.this.menuEditLayer.glassLayer.requestFocusInWindow();
            }
        }
    }
}

