/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.fakepeer;

import java.awt.Button;
import java.awt.Canvas;
import java.awt.Checkbox;
import java.awt.Choice;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.Label;
import java.awt.List;
import java.awt.Panel;
import java.awt.ScrollPane;
import java.awt.Scrollbar;
import java.awt.TextArea;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.peer.ButtonPeer;
import java.awt.peer.CanvasPeer;
import java.awt.peer.CheckboxPeer;
import java.awt.peer.ChoicePeer;
import java.awt.peer.ComponentPeer;
import java.awt.peer.ContainerPeer;
import java.awt.peer.LabelPeer;
import java.awt.peer.LightweightPeer;
import java.awt.peer.ListPeer;
import java.awt.peer.PanelPeer;
import java.awt.peer.ScrollPanePeer;
import java.awt.peer.ScrollbarPeer;
import java.awt.peer.TextAreaPeer;
import java.awt.peer.TextComponentPeer;
import java.awt.peer.TextFieldPeer;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import javax.swing.JComponent;
import javax.swing.RootPaneContainer;
import org.netbeans.modules.form.fakepeer.FakeButtonPeer;
import org.netbeans.modules.form.fakepeer.FakeCanvasPeer;
import org.netbeans.modules.form.fakepeer.FakeCheckboxPeer;
import org.netbeans.modules.form.fakepeer.FakeChoicePeer;
import org.netbeans.modules.form.fakepeer.FakeComponentPeer;
import org.netbeans.modules.form.fakepeer.FakeLabelPeer;
import org.netbeans.modules.form.fakepeer.FakeListPeer;
import org.netbeans.modules.form.fakepeer.FakePanelPeer;
import org.netbeans.modules.form.fakepeer.FakePeer;
import org.netbeans.modules.form.fakepeer.FakePeerInvocationHandler;
import org.netbeans.modules.form.fakepeer.FakeScrollPanePeer;
import org.netbeans.modules.form.fakepeer.FakeScrollbarPeer;
import org.netbeans.modules.form.fakepeer.FakeTextAreaPeer;
import org.netbeans.modules.form.fakepeer.FakeTextComponentPeer;
import org.netbeans.modules.form.fakepeer.FakeTextFieldPeer;
import org.openide.ErrorManager;
import org.openide.windows.WindowManager;

public class FakePeerSupport {
    private static Font defaultFont;

    private FakePeerSupport() {
    }

    public static boolean attachFakePeer(Component comp) {
        if (comp == null || comp.isDisplayable() || comp instanceof JComponent || comp instanceof RootPaneContainer) {
            return false;
        }
        FakePeer peer = null;
        if (comp instanceof Label) {
            peer = FakePeerSupport.getFakePeer(LabelPeer.class, (FakeComponentPeer)new FakeLabelPeer((Label)comp));
        } else if (comp instanceof Button) {
            peer = FakePeerSupport.getFakePeer(ButtonPeer.class, (FakeComponentPeer)new FakeButtonPeer((Button)comp));
        } else if (comp instanceof Panel) {
            peer = FakePeerSupport.getFakePeer(new Class[]{ContainerPeer.class, PanelPeer.class}, (FakeComponentPeer)new FakePanelPeer((Panel)comp));
        } else if (comp instanceof TextField) {
            peer = FakePeerSupport.getFakePeer(new Class[]{TextFieldPeer.class, TextComponentPeer.class}, (FakeComponentPeer)new FakeTextFieldPeer((TextField)comp));
        } else if (comp instanceof TextArea) {
            peer = FakePeerSupport.getFakePeer(new Class[]{TextAreaPeer.class, TextComponentPeer.class}, (FakeComponentPeer)new FakeTextAreaPeer((TextArea)comp));
        } else if (comp instanceof TextComponent) {
            peer = FakePeerSupport.getFakePeer(TextComponentPeer.class, (FakeComponentPeer)new FakeTextComponentPeer((TextComponent)comp));
        } else if (comp instanceof Checkbox) {
            peer = FakePeerSupport.getFakePeer(CheckboxPeer.class, (FakeComponentPeer)new FakeCheckboxPeer((Checkbox)comp));
        } else if (comp instanceof Choice) {
            peer = FakePeerSupport.getFakePeer(ChoicePeer.class, (FakeComponentPeer)new FakeChoicePeer((Choice)comp));
        } else if (comp instanceof List) {
            peer = FakePeerSupport.getFakePeer(ListPeer.class, (FakeComponentPeer)new FakeListPeer((List)comp));
        } else if (comp instanceof Scrollbar) {
            peer = FakePeerSupport.getFakePeer(ScrollbarPeer.class, (FakeComponentPeer)new FakeScrollbarPeer((Scrollbar)comp));
        } else if (comp instanceof ScrollPane) {
            peer = FakePeerSupport.getFakePeer(new Class[]{ContainerPeer.class, ScrollPanePeer.class}, (FakeComponentPeer)new FakeScrollPanePeer((ScrollPane)comp));
        } else if (comp instanceof Canvas) {
            peer = FakePeerSupport.getFakePeer(CanvasPeer.class, (FakeComponentPeer)new FakeCanvasPeer((Canvas)comp));
        } else {
            return false;
        }
        FakePeerSupport.attachFakePeer(comp, peer);
        return true;
    }

    private static FakePeer getFakePeer(Class fakePeerInterfaces, FakeComponentPeer compPeer) {
        return FakePeerSupport.getFakePeer(new Class[]{fakePeerInterfaces}, compPeer);
    }

    private static FakePeer getFakePeer(Class[] fakePeerInterfaces, FakeComponentPeer compPeer) {
        Class[] interfaces = new Class[fakePeerInterfaces.length + 2];
        System.arraycopy(fakePeerInterfaces, 0, interfaces, 0, fakePeerInterfaces.length);
        interfaces[fakePeerInterfaces.length] = FakePeer.class;
        interfaces[fakePeerInterfaces.length + 1] = LightweightPeer.class;
        Class<?> proxyClass = Proxy.getProxyClass(compPeer.getClass().getClassLoader(), interfaces);
        FakePeerInvocationHandler handler = new FakePeerInvocationHandler(compPeer);
        try {
            return (FakePeer)proxyClass.getConstructor(InvocationHandler.class).newInstance(handler);
        }
        catch (Exception e) {
            ErrorManager.getDefault().notify((Throwable)e);
            return null;
        }
    }

    public static ComponentPeer getPeer(Component comp) {
        ComponentPeer peer = null;
        try {
            Field f = Component.class.getDeclaredField("peer");
            f.setAccessible(true);
            peer = (ComponentPeer)f.get(comp);
        }
        catch (IllegalAccessException iaex) {
            ErrorManager.getDefault().notify(1, (Throwable)iaex);
        }
        catch (NoSuchFieldException nsfex) {
            ErrorManager.getDefault().notify(1, (Throwable)nsfex);
        }
        return peer;
    }

    public static void attachFakePeer(Component comp, ComponentPeer peer) {
        try {
            Field f = Component.class.getDeclaredField("peer");
            f.setAccessible(true);
            f.set(comp, peer);
        }
        catch (Exception ex) {
            ErrorManager.getDefault().notify(1, (Throwable)ex);
        }
    }

    public static void attachFakePeerRecursively(Container container) {
        Component[] components = FakePeerSupport.getComponents(container);
        for (int i = 0; i < components.length; ++i) {
            Component comp = components[i];
            FakePeerSupport.attachFakePeer(comp);
            if (!(comp instanceof Container)) continue;
            FakePeerSupport.attachFakePeerRecursively((Container)comp);
        }
    }

    static Component[] getComponents(Container container) {
        try {
            Component[] components;
            Field f = Container.class.getDeclaredField("component");
            f.setAccessible(true);
            Object value = f.get(container);
            if (value instanceof Component[]) {
                components = (Component[])value;
            } else {
                java.util.List list = (java.util.List)value;
                components = list.toArray(new Component[0]);
            }
            return components;
        }
        catch (Exception ex) {
            ErrorManager.getDefault().notify(1, (Throwable)ex);
            return container.getComponents();
        }
    }

    public static ComponentPeer detachFakePeer(Component comp) {
        try {
            Field f = Component.class.getDeclaredField("peer");
            f.setAccessible(true);
            ComponentPeer peer = (ComponentPeer)f.get(comp);
            if (peer instanceof FakePeer) {
                f.set(comp, null);
                return (FakePeer)peer;
            }
        }
        catch (Exception ex) {
            ErrorManager.getDefault().notify(1, (Throwable)ex);
        }
        return null;
    }

    public static Font getDefaultAWTFont() {
        if (defaultFont == null && (defaultFont = WindowManager.getDefault().getMainWindow().getFont()) == null) {
            defaultFont = new Font("Dialog", 0, 12);
        }
        return defaultFont;
    }
}

