/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.actions;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.ListIterator;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import org.netbeans.modules.form.FormDesigner;
import org.netbeans.modules.form.FormEditor;
import org.netbeans.modules.form.RADComponent;
import org.netbeans.modules.form.RADComponentCookie;
import org.netbeans.modules.form.RADVisualComponent;
import org.netbeans.modules.form.actions.EditContainerAction;
import org.netbeans.modules.form.actions.EditFormAction;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.NodeAction;
import org.openide.util.actions.SystemAction;

public class DesignParentAction
extends NodeAction {
    private ActionListener menuItemListener;

    protected boolean enable(Node[] nodes) {
        boolean ret = false;
        if (nodes != null && nodes.length == 1) {
            RADVisualComponent designed;
            FormDesigner designer;
            RADComponent comp;
            RADComponentCookie radCookie = (RADComponentCookie)nodes[0].getCookie(RADComponentCookie.class);
            RADComponent rADComponent = comp = radCookie != null ? radCookie.getRADComponent() : null;
            if (comp != null && DesignParentAction.isParentEditableComponent(comp) && (designer = DesignParentAction.getDesigner(comp)) != null && (comp == (designed = designer.getTopDesignComponent()) || designed != null && designed.isParentComponent(comp) && DesignParentAction.isParentEditableComponent(comp.getParentComponent()))) {
                ret = true;
            }
        }
        return ret;
    }

    public static boolean isParentEditableComponent(RADComponent comp) {
        RADComponent parent = comp.getParentComponent();
        if (EditContainerAction.isEditableComponent(parent)) {
            return true;
        }
        if (parent == null) {
            RADComponent topComp = comp.getFormModel().getTopRADComponent();
            return comp != topComp && EditContainerAction.isEditableComponent(topComp);
        }
        return false;
    }

    protected void performAction(Node[] activatedNodes) {
    }

    static void reenable(Node[] nodes) {
        ((DesignParentAction)SystemAction.get(DesignParentAction.class)).reenable0(nodes);
    }

    private void reenable0(Node[] nodes) {
        this.setEnabled(this.enable(nodes));
    }

    protected boolean asynchronous() {
        return false;
    }

    public String getName() {
        return NbBundle.getMessage(DesignParentAction.class, (String)"ACT_DesignParentAction");
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    public JMenuItem getMenuPresenter() {
        return this.getPopupPresenter();
    }

    public JMenuItem getPopupPresenter() {
        JMenu popupMenu = new JMenu(NbBundle.getMessage(DesignParentAction.class, (String)"ACT_DesignParentAction"));
        popupMenu.setEnabled(this.isEnabled());
        HelpCtx.setHelpIDString((JComponent)popupMenu, (String)DesignParentAction.class.getName());
        this.createSubmenu(popupMenu);
        return popupMenu;
    }

    private void createSubmenu(JMenu menu) {
        Node[] nodes = this.getActivatedNodes();
        if (nodes != null && nodes.length == 1) {
            RADComponent comp;
            RADComponentCookie radCookie = (RADComponentCookie)nodes[0].getCookie(RADComponentCookie.class);
            RADComponent rADComponent = comp = radCookie != null ? radCookie.getRADComponent() : null;
            if (comp != null) {
                ArrayList<DesignParentMenuItem> list = new ArrayList<DesignParentMenuItem>();
                RADComponent topComp = comp.getFormModel().getTopRADComponent();
                boolean topCompIncluded = false;
                for (RADComponent parent = comp.getParentComponent(); parent != null; parent = parent.getParentComponent()) {
                    list.add(new DesignParentMenuItem(parent, parent == topComp, this.getMenuItemListener()));
                    if (parent != topComp) continue;
                    topCompIncluded = true;
                }
                if (!topCompIncluded && topComp != null) {
                    list.add(new DesignParentMenuItem(topComp, true, this.getMenuItemListener()));
                }
                ListIterator it = list.listIterator(list.size());
                while (it.hasPrevious()) {
                    menu.add((JMenuItem)it.previous());
                }
            }
        }
    }

    private ActionListener getMenuItemListener() {
        if (this.menuItemListener == null) {
            this.menuItemListener = new DesignParentMenuItemListener();
        }
        return this.menuItemListener;
    }

    private static FormDesigner getDesigner(RADComponent comp) {
        return FormEditor.getFormDesigner(comp.getFormModel());
    }

    private static class DesignParentMenuItem
    extends JMenuItem {
        private RADComponent radc = null;

        public DesignParentMenuItem(RADComponent c, boolean top, ActionListener l) {
            this.radc = c;
            this.setText(top ? NbBundle.getMessage(DesignParentAction.class, (String)"ACT_DesignParentTopMenuItemName") : c.getName());
            this.addActionListener(l);
            FormDesigner designer = DesignParentAction.getDesigner(c);
            this.setEnabled(designer != null && c != designer.getTopDesignComponent());
        }

        public RADComponent getRADComponent() {
            return this.radc;
        }
    }

    private static class DesignParentMenuItemListener
    implements ActionListener {
        private DesignParentMenuItemListener() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            Object source = evt.getSource();
            if (source == null || !(source instanceof DesignParentMenuItem)) {
                return;
            }
            DesignParentMenuItem mi = (DesignParentMenuItem)source;
            RADComponent lc = mi.getRADComponent();
            FormDesigner designer = DesignParentAction.getDesigner(lc);
            if (designer != null) {
                designer.setTopDesignComponent((RADVisualComponent)lc, true);
                designer.requestActive();
                Node[] n = new Node[]{lc.getNodeReference()};
                if (n[0] != null) {
                    EditContainerAction.reenable(n);
                    DesignParentAction.reenable(n);
                    EditFormAction.reenable(n);
                }
            }
        }
    }
}

