/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form;

import java.awt.EventQueue;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditor;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JLayeredPane;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JSeparator;
import javax.swing.MenuElement;
import javax.swing.undo.UndoableEdit;
import org.netbeans.modules.form.FormLAF;
import org.netbeans.modules.form.FormProperty;
import org.netbeans.modules.form.FormPropertyContext;
import org.netbeans.modules.form.FormUtils;
import org.netbeans.modules.form.RADComponent;
import org.netbeans.modules.form.RADComponentNode;
import org.netbeans.modules.form.RADVisualContainer;
import org.netbeans.modules.form.editors.EnumEditor;
import org.netbeans.modules.form.layoutdesign.LayoutComponent;
import org.netbeans.modules.form.layoutdesign.LayoutInterval;
import org.netbeans.modules.form.layoutdesign.LayoutModel;
import org.netbeans.modules.form.layoutsupport.LayoutConstraints;
import org.netbeans.modules.form.layoutsupport.LayoutSupportManager;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.util.NbBundle;

public class RADVisualComponent
extends RADComponent {
    private static final String PROP_LAYOUT_COMPONENT_HORIZONTAL_SIZE = "layoutComponentHorizontalSize";
    private static final String PROP_LAYOUT_COMPONENT_VERTICAL_SIZE = "layoutComponentVerticalSize";
    private static final String PROP_LAYOUT_COMPONENT_HORIZONTAL_RESIZABLE = "layoutComponentHorizontalResizable";
    private static final String PROP_LAYOUT_COMPONENT_VERTICAL_RESIZABLE = "layoutComponentVerticalResizable";
    static final String PROP_LAYER = "JLayeredPane.layer";
    private Map<String, LayoutConstraints> constraints = new HashMap<String, LayoutConstraints>();
    private Node.Property[] constraintsProperties;
    private ConstraintsListenerConvertor constraintsListener;

    public final RADVisualContainer getParentContainer() {
        return (RADVisualContainer)this.getParentComponent();
    }

    public final int getComponentIndex() {
        RADVisualContainer parent = (RADVisualContainer)this.getParentComponent();
        return parent != null ? parent.getIndexOf(this) : -1;
    }

    final LayoutSupportManager getParentLayoutSupport() {
        RADVisualContainer parent = (RADVisualContainer)this.getParentComponent();
        return parent != null ? parent.getLayoutSupport() : null;
    }

    boolean isMenuTypeComponent() {
        return MenuElement.class.isAssignableFrom(this.getBeanClass());
    }

    public boolean isMenuComponent() {
        RADVisualContainer parent;
        return this.isMenuTypeComponent() && ((parent = this.getParentContainer()) == null && !this.isInModel() || parent != null && (parent.isMenuTypeComponent() || this == parent.getContainerMenu()));
    }

    static MenuType getMenuType(Class cl) {
        if (MenuElement.class.isAssignableFrom(cl)) {
            if (JMenu.class.isAssignableFrom(cl)) {
                return MenuType.JMenu;
            }
            if (JMenuBar.class.isAssignableFrom(cl)) {
                return MenuType.JMenuBar;
            }
            if (JCheckBoxMenuItem.class.isAssignableFrom(cl)) {
                return MenuType.JCheckBoxMenuItem;
            }
            if (JRadioButtonMenuItem.class.isAssignableFrom(cl)) {
                return MenuType.JRadioButtonMenuItem;
            }
            if (JMenuItem.class.isAssignableFrom(cl)) {
                return MenuType.JMenuItem;
            }
            if (JPopupMenu.class.isAssignableFrom(cl)) {
                return MenuType.JPopupMenu;
            }
        } else if (JSeparator.class.isAssignableFrom(cl)) {
            return MenuType.JSeparator;
        }
        return null;
    }

    public void setLayoutConstraints(Class layoutDelegateClass, LayoutConstraints constr) {
        if (constr != null) {
            this.constraints.put(layoutDelegateClass.getName(), constr);
        }
    }

    public LayoutConstraints getLayoutConstraints(Class layoutDelegateClass) {
        return this.constraints.get(layoutDelegateClass.getName());
    }

    Map<String, LayoutConstraints> getConstraintsMap() {
        return this.constraints;
    }

    void setConstraintsMap(Map<String, LayoutConstraints> map) {
        this.constraints.putAll(map);
    }

    @Override
    protected synchronized void createPropertySets(List<Node.PropertySet> propSets) {
        super.createPropertySets(propSets);
        if (SUPPRESS_PROPERTY_TABS) {
            return;
        }
        if (this.constraintsProperties == null) {
            this.createConstraintsProperties();
        }
        if (this.constraintsProperties != null && this.constraintsProperties.length > 0) {
            propSets.add(propSets.size() - 1, new Node.PropertySet("layout", FormUtils.getBundleString("CTL_LayoutTab"), FormUtils.getBundleString("CTL_LayoutTabHint")){

                public Node.Property[] getProperties() {
                    Node.Property[] props = RADVisualComponent.this.getConstraintsProperties();
                    return props == null ? RADComponent.NO_PROPERTIES : props;
                }
            });
        }
    }

    @Override
    protected synchronized void clearProperties() {
        super.clearProperties();
        this.constraintsProperties = null;
    }

    public synchronized Node.Property[] getConstraintsProperties() {
        if (this.constraintsProperties == null) {
            this.createConstraintsProperties();
        }
        return this.constraintsProperties;
    }

    public synchronized void resetConstraintsProperties() {
        if (this.constraintsProperties != null) {
            for (int i = 0; i < this.constraintsProperties.length; ++i) {
                this.nameToProperty.remove(this.constraintsProperties[i].getName());
            }
            this.constraintsProperties = null;
            this.propertySets = null;
            RADComponentNode node = this.getNodeReference();
            if (node != null) {
                node.fireComponentPropertySetsChange();
            }
        }
    }

    private synchronized void createConstraintsProperties() {
        this.constraintsProperties = null;
        LayoutSupportManager layoutSupport = this.getParentLayoutSupport();
        if (layoutSupport != null) {
            LayoutConstraints constr;
            if (this.getParentContainer().isLayoutSubcomponent(this) && (constr = layoutSupport.getConstraints(this)) != null) {
                this.constraintsProperties = constr.getProperties();
            }
        } else if (this.getParentContainer() != null && !this.isMenuComponent()) {
            this.constraintsProperties = new Node.Property[]{new LayoutComponentSizeProperty(0), new LayoutComponentSizeProperty(1), new LayoutComponentResizableProperty(0), new LayoutComponentResizableProperty(1)};
        }
        if (this.isInLayeredPane()) {
            ArrayList<Object> l;
            if (this.constraintsProperties != null) {
                l = new ArrayList(this.constraintsProperties.length + 1);
                l.addAll(Arrays.asList(this.constraintsProperties));
            } else {
                l = new ArrayList<Object>(1);
            }
            LayerProperty layerProperty = new LayerProperty();
            l.add((Object)layerProperty);
            this.nameToProperty.put(layerProperty.getName(), layerProperty);
            this.constraintsProperties = l.toArray(new Node.Property[0]);
        }
        if (this.constraintsProperties == null) {
            this.constraintsProperties = NO_PROPERTIES;
            return;
        }
        for (int i = 0; i < this.constraintsProperties.length; ++i) {
            if (!(this.constraintsProperties[i] instanceof FormProperty)) continue;
            FormProperty prop = (FormProperty)this.constraintsProperties[i];
            prop.addVetoableChangeListener(this.getConstraintsListener());
            prop.addPropertyChangeListener(this.getConstraintsListener());
            prop.addValueConvertor(this.getConstraintsListener());
            prop.setPropertyContext(new FormPropertyContext.Component(this));
            if (this.isReadOnly() || !this.isValid()) {
                int type = prop.getAccessType() | 0xA;
                prop.setAccessType(type);
            }
            this.nameToProperty.put(prop.getName(), prop);
        }
    }

    private ConstraintsListenerConvertor getConstraintsListener() {
        if (this.constraintsListener == null) {
            this.constraintsListener = new ConstraintsListenerConvertor();
        }
        return this.constraintsListener;
    }

    final int getComponentLayer() {
        Object layer = this.getAuxValue(PROP_LAYER);
        return layer instanceof Integer ? ((Integer)layer).intValue() : JLayeredPane.DEFAULT_LAYER.intValue();
    }

    final String getComponentLayerJavaInitCode() {
        int layer;
        if (this.isInLayeredPane() && ((layer = this.getComponentLayer()) != JLayeredPane.DEFAULT_LAYER || RADVisualContainer.isInFreeDesign(this))) {
            LayerPropertyEditor prEd = new LayerPropertyEditor();
            prEd.setValue(layer);
            return prEd.getJavaInitializationString();
        }
        return null;
    }

    final boolean isInLayeredPane() {
        RADVisualContainer parent = this.getParentContainer();
        return parent != null && parent.getBeanInstance() instanceof JLayeredPane;
    }

    static enum MenuType {
        JMenuItem,
        JCheckBoxMenuItem,
        JRadioButtonMenuItem,
        JMenu,
        JMenuBar,
        JPopupMenu,
        JSeparator;

    }

    private class LayoutComponentSizeProperty
    extends LProperty {
        private LayoutComponent component;
        private int dimension;

        private LayoutComponentSizeProperty(int dimension) {
            super(dimension == 0 ? RADVisualComponent.PROP_LAYOUT_COMPONENT_HORIZONTAL_SIZE : RADVisualComponent.PROP_LAYOUT_COMPONENT_VERTICAL_SIZE, Integer.class, null, null);
            boolean horizontal = dimension == 0;
            this.setDisplayName(FormUtils.getBundleString(horizontal ? "PROP_LAYOUT_COMPONENT_HORIZONTAL_SIZE" : "PROP_LAYOUT_COMPONENT_VERTICAL_SIZE"));
            this.setShortDescription(FormUtils.getBundleString(horizontal ? "HINT_LAYOUT_COMPONENT_HORIZONTAL_SIZE" : "HINT_LAYOUT_COMPONENT_VERTICAL_SIZE"));
            this.dimension = dimension;
        }

        private LayoutComponent getComponent() {
            if (this.component == null) {
                this.component = RADVisualComponent.this.getFormModel().getLayoutModel().getLayoutComponent(RADVisualComponent.this.getId());
                if (this.component != null) {
                    String sourcePropertyName = this.dimension == 0 ? "horizontalPrefSize" : "verticalPrefSize";
                    this.component.addPropertyChangeListener(new PropertySynchronizer(sourcePropertyName, this.getName()));
                }
            }
            return this.component;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setValue(Object value) {
            if (!(value instanceof Integer)) {
                throw new IllegalArgumentException();
            }
            Integer oldValue = (Integer)this.getValue();
            Integer newValue = (Integer)value;
            LayoutModel layoutModel = RADVisualComponent.this.getFormModel().getLayoutModel();
            LayoutInterval interval = this.getComponent().getLayoutInterval(this.dimension);
            Object layoutUndoMark = layoutModel.getChangeMark();
            UndoableEdit ue = layoutModel.getUndoableEdit();
            boolean autoUndo = true;
            try {
                layoutModel.setUserIntervalSize(interval, this.dimension, newValue);
                RADVisualComponent.this.getNodeReference().firePropertyChangeHelper(this.getName(), oldValue, newValue);
                autoUndo = false;
            }
            finally {
                RADVisualComponent.this.getFormModel().fireContainerLayoutChanged(RADVisualComponent.this.getParentContainer(), null, null, null);
                if (!layoutUndoMark.equals(layoutModel.getChangeMark())) {
                    RADVisualComponent.this.getFormModel().addUndoableEdit(ue);
                }
                if (autoUndo) {
                    RADVisualComponent.this.getFormModel().forceUndoOfCompoundEdit();
                }
            }
        }

        public Object getValue() {
            int size = this.getComponent().getLayoutInterval(this.dimension).getPreferredSize();
            return size;
        }

        @Override
        Object getDefaultValue() {
            return -1;
        }

        public PropertyEditor getPropertyEditor() {
            return new LayoutSizePropertyEditor();
        }
    }

    private class LayoutComponentResizableProperty
    extends LProperty {
        private LayoutComponent component;
        private int dimension;

        private LayoutComponentResizableProperty(int dimension) {
            super(dimension == 0 ? RADVisualComponent.PROP_LAYOUT_COMPONENT_HORIZONTAL_RESIZABLE : RADVisualComponent.PROP_LAYOUT_COMPONENT_VERTICAL_RESIZABLE, Boolean.class, null, null);
            boolean horizontal = dimension == 0;
            this.setDisplayName(FormUtils.getBundleString(horizontal ? "PROP_LAYOUT_COMPONENT_HORIZONTAL_RESIZABLE" : "PROP_LAYOUT_COMPONENT_VERTICAL_RESIZABLE"));
            this.setShortDescription(FormUtils.getBundleString(horizontal ? "HINT_LAYOUT_COMPONENT_HORIZONTAL_RESIZABLE" : "HINT_LAYOUT_COMPONENT_VERTICAL_RESIZABLE"));
            this.dimension = dimension;
        }

        private LayoutComponent getComponent() {
            if (this.component == null) {
                this.component = RADVisualComponent.this.getFormModel().getLayoutModel().getLayoutComponent(RADVisualComponent.this.getId());
                if (this.component != null) {
                    String sourcePropertyName = this.dimension == 0 ? "horizontalMaxSize" : "verticalMaxSize";
                    this.component.addPropertyChangeListener(new PropertySynchronizer(sourcePropertyName, this.getName()));
                }
            }
            return this.component;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setValue(Object value) {
            if (!(value instanceof Boolean)) {
                throw new IllegalArgumentException();
            }
            Boolean oldValue = (Boolean)this.getValue();
            Boolean newValue = (Boolean)value;
            boolean resizable = newValue;
            LayoutModel layoutModel = RADVisualComponent.this.getFormModel().getLayoutModel();
            LayoutInterval interval = this.getComponent().getLayoutInterval(this.dimension);
            Object layoutUndoMark = layoutModel.getChangeMark();
            UndoableEdit ue = layoutModel.getUndoableEdit();
            boolean autoUndo = true;
            try {
                layoutModel.setUserIntervalSize(interval, this.dimension, interval.getPreferredSize(), resizable);
                RADVisualComponent.this.getNodeReference().firePropertyChangeHelper(this.getName(), oldValue, newValue);
                autoUndo = false;
            }
            finally {
                RADVisualComponent.this.getFormModel().fireContainerLayoutChanged(RADVisualComponent.this.getParentContainer(), null, null, null);
                if (!layoutUndoMark.equals(layoutModel.getChangeMark())) {
                    RADVisualComponent.this.getFormModel().addUndoableEdit(ue);
                }
                if (autoUndo) {
                    RADVisualComponent.this.getFormModel().forceUndoOfCompoundEdit();
                }
            }
        }

        public Object getValue() {
            int pref = this.getComponent().getLayoutInterval(this.dimension).getPreferredSize();
            int max = this.getComponent().getLayoutInterval(this.dimension).getMaximumSize();
            return max != pref && max != -2;
        }

        @Override
        Object getDefaultValue() {
            return Boolean.FALSE;
        }
    }

    private class LayerProperty
    extends LProperty {
        LayerProperty() {
            super(RADVisualComponent.PROP_LAYER, Integer.TYPE, NbBundle.getMessage(LayoutSupportManager.class, (String)"PROP_layer"), NbBundle.getMessage(LayoutSupportManager.class, (String)"HINT_layer"));
        }

        public Object getValue() {
            Object value = RADVisualComponent.this.getAuxValue(RADVisualComponent.PROP_LAYER);
            if (!(value instanceof Integer)) {
                value = (int)JLayeredPane.DEFAULT_LAYER;
            }
            return value;
        }

        public void setValue(Object value) {
            if (!(value instanceof Integer)) {
                throw new IllegalArgumentException();
            }
            Integer oldValue = (Integer)this.getValue();
            RADVisualComponent.this.setAuxValue(RADVisualComponent.PROP_LAYER, value.equals(this.getDefaultValue()) ? null : value);
            if (!value.equals(oldValue)) {
                RADVisualComponent.this.getNodeReference().firePropertyChangeHelper(this.getName(), oldValue, value);
                RADVisualComponent.this.getFormModel().fireComponentLayoutChanged(RADVisualComponent.this, this.getName(), oldValue, value);
            }
        }

        @Override
        Object getDefaultValue() {
            return (int)JLayeredPane.DEFAULT_LAYER;
        }

        public PropertyEditor getPropertyEditor() {
            return new LayerPropertyEditor();
        }
    }

    private class ConstraintsListenerConvertor
    implements VetoableChangeListener,
    PropertyChangeListener,
    FormProperty.ValueConvertor {
        private ConstraintsListenerConvertor() {
        }

        @Override
        public void vetoableChange(PropertyChangeEvent ev) throws PropertyVetoException {
            Object source = ev.getSource();
            String eventName = ev.getPropertyName();
            if (source instanceof FormProperty && ("propertyValue".equals(eventName) || "propertyValueAndEditor".equals(eventName))) {
                RADVisualComponent.this.resourcePropertyChanged(ev);
                LayoutSupportManager layoutSupport = RADVisualComponent.this.getParentLayoutSupport();
                int index = RADVisualComponent.this.getComponentIndex();
                LayoutConstraints constraints = layoutSupport.getConstraints(index);
                ev = new PropertyChangeEvent(constraints, ((FormProperty)((Object)source)).getName(), ev.getOldValue(), ev.getNewValue());
                layoutSupport.componentLayoutChanged(index, ev);
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent ev) {
            Object source = ev.getSource();
            if (source instanceof FormProperty && "currentEditor".equals(ev.getPropertyName())) {
                LayoutSupportManager layoutSupport = RADVisualComponent.this.getParentLayoutSupport();
                int index = RADVisualComponent.this.getComponentIndex();
                LayoutConstraints constraints = layoutSupport.getConstraints(index);
                ev = new PropertyChangeEvent(constraints, null, null, null);
                try {
                    layoutSupport.componentLayoutChanged(index, ev);
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
            }
        }

        @Override
        public Object convert(Object value, FormProperty property) {
            return RADVisualComponent.this.resourcePropertyConvert(value, property);
        }
    }

    private static class LayerPropertyEditor
    extends EnumEditor {
        LayerPropertyEditor() {
            super(new Object[]{"DEFAULT_LAYER", JLayeredPane.DEFAULT_LAYER, "javax.swing.JLayeredPane.DEFAULT_LAYER", "PALETTE_LAYER", JLayeredPane.PALETTE_LAYER, "javax.swing.JLayeredPane.PALETTE_LAYER", "MODAL_LAYER", JLayeredPane.MODAL_LAYER, "javax.swing.JLayeredPane.MODAL_LAYER", "POPUP_LAYER", JLayeredPane.POPUP_LAYER, "javax.swing.JLayeredPane.POPUP_LAYER", "DRAG_LAYER", JLayeredPane.DRAG_LAYER, "javax.swing.JLayeredPane.DRAG_LAYER"}, false, true);
        }

        @Override
        public void setAsText(String str) {
            if (!this.setValueFromString(str)) {
                try {
                    this.setValue(Integer.valueOf(str));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
    }

    private class PropertySynchronizer
    implements PropertyChangeListener,
    Runnable {
        private String sourcePropertyName;
        private String targetPropertyName;

        PropertySynchronizer(String sourcePropertyName, String targetPropertyName) {
            this.sourcePropertyName = sourcePropertyName;
            this.targetPropertyName = targetPropertyName;
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            String propName = evt.getPropertyName();
            if (this.sourcePropertyName.equals(propName)) {
                if (!FormLAF.inLAFBlock()) {
                    this.run();
                } else {
                    EventQueue.invokeLater(this);
                }
            }
        }

        @Override
        public void run() {
            RADComponentNode node = RADVisualComponent.this.getNodeReference();
            if (node != null) {
                node.firePropertyChangeHelper(this.targetPropertyName, null, null);
            }
        }
    }

    private static class LayoutSizePropertyEditor
    extends EnumEditor {
        LayoutSizePropertyEditor() {
            super(new Object[]{FormUtils.getBundleString("VALUE_SizeNotExplicitelyDefined"), -1, ""}, false, true);
        }

        @Override
        public void setAsText(String str) {
            if (!this.setValueFromString(str)) {
                try {
                    int size = Integer.parseInt(str);
                    if (size < 0) {
                        throw new IllegalArgumentException();
                    }
                    this.setValue(size);
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException();
                }
            }
        }
    }

    private abstract class LProperty
    extends PropertySupport.ReadWrite {
        LProperty(String name, Class type, String displayName, String shortDescription) {
            super(name, type, displayName, shortDescription);
            this.setValue("canEditAsText", Boolean.TRUE);
        }

        abstract Object getDefaultValue();

        public boolean supportsDefaultValue() {
            return true;
        }

        public void restoreDefaultValue() {
            try {
                this.setValue(this.getDefaultValue());
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
        }

        public boolean isDefaultValue() {
            Object value = null;
            try {
                value = this.getValue();
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
            return value == null || value.equals(this.getDefaultValue());
        }

        public String getHtmlDisplayName() {
            return this.isDefaultValue() ? null : "<b>" + this.getDisplayName();
        }

        public boolean canWrite() {
            return !RADVisualComponent.this.isReadOnly();
        }
    }
}

