/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form;

import java.beans.Introspector;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.modules.form.FormEditor;
import org.netbeans.modules.form.FormModel;
import org.netbeans.modules.java.source.queries.api.Function;
import org.netbeans.modules.java.source.queries.api.Queries;
import org.netbeans.modules.java.source.queries.api.QueryException;
import org.netbeans.modules.java.source.queries.api.Updates;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;

public final class FormJavaSource {
    private boolean validJavaSource;
    private DataObject formDataObject;
    private FileObject javaFile;
    private String className;
    private String filePath;
    private final Object javaContext;
    private Collection<? extends String> fields;
    private static final String[] PROPERTY_PREFIXES = new String[]{"get", "is"};
    private static final String JAVA_QUERIES_CONTEXT_KEY = "JavaQueriesContext_key";

    FormJavaSource(DataObject dob, Object javaContext) {
        this.formDataObject = dob;
        this.javaFile = dob.getPrimaryFile();
        this.javaContext = javaContext;
        this.validJavaSource = ClassPath.getClassPath((FileObject)this.javaFile, (String)"classpath/source") != null;
    }

    public <T> T query(Function<Queries, T> queryFnc) {
        try {
            this.setTransientContext(true);
            Object object = Queries.query((URL)this.getJavaFile().toURL(), queryFnc);
            return (T)object;
        }
        catch (QueryException ex) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, null, ex);
        }
        finally {
            this.setTransientContext(false);
        }
        return null;
    }

    public Boolean update(Function<Updates, Boolean> updateFnc) {
        try {
            this.setTransientContext(true);
            Boolean bl = Updates.update((URL)this.getJavaFile().toURL(), updateFnc);
            return bl;
        }
        catch (QueryException ex) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, null, ex);
        }
        finally {
            this.setTransientContext(false);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setTransientContext(boolean set) {
        if (this.javaContext != null) {
            FileObject file = this.getJavaFile();
            if (set) {
                ThreadLocal<Object> tl;
                FileObject fileObject = file;
                synchronized (fileObject) {
                    Object o = file.getAttribute(JAVA_QUERIES_CONTEXT_KEY);
                    ThreadLocal<Object> threadLocal = tl = o instanceof ThreadLocal ? (ThreadLocal<Object>)o : null;
                    if (tl == null) {
                        tl = new ThreadLocal<Object>();
                        try {
                            file.setAttribute(JAVA_QUERIES_CONTEXT_KEY, tl);
                        }
                        catch (IOException ex) {
                            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, null, ex);
                        }
                    }
                }
                tl.set(this.javaContext);
            } else {
                Object o = file.getAttribute(JAVA_QUERIES_CONTEXT_KEY);
                if (o instanceof ThreadLocal) {
                    ((ThreadLocal)o).remove();
                }
            }
        }
    }

    private String getFormClassName() {
        if (!this.validJavaSource) {
            return null;
        }
        FileObject file = this.getJavaFile();
        if (this.className != null && file.getPath().equals(this.filePath)) {
            return this.className;
        }
        Collection<? extends String> names = this.query(new Function<Queries, Collection<? extends String>>(){

            public Collection<? extends String> apply(Queries queries) throws QueryException {
                return queries.getTopLevelClasses();
            }
        });
        this.className = null;
        if (names != null) {
            String fileName = file.getName();
            String dotFileName = "." + fileName;
            for (String string : names) {
                if (!string.equals(fileName) && !string.endsWith(dotFileName)) continue;
                this.className = string;
                break;
            }
        }
        this.filePath = file.getPath();
        return this.className;
    }

    public boolean containsField(String name, boolean refresh) {
        if (refresh) {
            this.refresh();
        }
        return this.fields != null && this.fields.contains(name);
    }

    private void refresh() {
        final String cls = this.getFormClassName();
        if (cls != null) {
            this.fields = this.query(new Function<Queries, Collection<? extends String>>(){
                final /* synthetic */ FormJavaSource this$0;
                {
                    this.this$0 = this$0;
                }

                public Collection<? extends String> apply(Queries queries) throws QueryException {
                    return queries.getFieldNames(cls, true, null);
                }
            });
        }
    }

    public String getSuperClassName() {
        final String cls = this.getFormClassName();
        return cls != null ? this.query(new Function<Queries, String>(){
            final /* synthetic */ FormJavaSource this$0;
            {
                this.this$0 = this$0;
            }

            public String apply(Queries queries) throws QueryException {
                return queries.getSuperClass(cls);
            }
        }) : null;
    }

    public String getClassBinaryName() {
        final String cls = this.getFormClassName();
        return cls != null ? this.query(new Function<Queries, String>(){
            final /* synthetic */ FormJavaSource this$0;
            {
                this.this$0 = this$0;
            }

            public String apply(Queries queries) throws QueryException {
                return queries.getClassBinaryName(cls);
            }
        }) : null;
    }

    public boolean modifyInterfaces(final Collection<String> toAdd, final Collection<String> toRemove) {
        final String cls = this.getFormClassName();
        Boolean ret = cls != null ? this.update(new Function<Updates, Boolean>(){
            final /* synthetic */ FormJavaSource this$0;
            {
                this.this$0 = this$0;
            }

            public Boolean apply(Updates updates) throws QueryException {
                updates.modifyInterfaces(cls, toAdd, toRemove);
                return true;
            }
        }) : null;
        return Boolean.TRUE.equals(ret);
    }

    public void renameField(final String oldName, final String newName) {
        if (this.containsField(oldName, true)) {
            final String cls = this.getFormClassName();
            this.update(new Function<Updates, Boolean>(){
                final /* synthetic */ FormJavaSource this$0;
                {
                    this.this$0 = this$0;
                }

                public Boolean apply(Updates updates) throws QueryException {
                    updates.renameField(cls, oldName, newName);
                    return true;
                }
            });
        }
    }

    public int[] getEventHandlerMethodSpan(final String evenHandlerName, final String eventType) {
        final String cls = this.getFormClassName();
        return cls != null ? this.query(new Function<Queries, int[]>(){
            final /* synthetic */ FormJavaSource this$0;
            {
                this.this$0 = this$0;
            }

            public int[] apply(Queries queries) throws QueryException {
                String[] stringArray;
                if (eventType != null) {
                    String[] stringArray2 = new String[1];
                    stringArray = stringArray2;
                    stringArray2[0] = eventType;
                } else {
                    stringArray = new String[]{};
                }
                String[] paramTypes = stringArray;
                return queries.getMethodSpan(cls, evenHandlerName, true, "void", paramTypes);
            }
        }) : null;
    }

    public int[] getMethodSpan(final String methodName, final String ... paramTypes) {
        final String cls = this.getFormClassName();
        return cls != null ? this.query(new Function<Queries, int[]>(){
            final /* synthetic */ FormJavaSource this$0;
            {
                this.this$0 = this$0;
            }

            public int[] apply(Queries queries) throws QueryException {
                return queries.getMethodSpan(cls, methodName, true, "void", paramTypes);
            }
        }) : null;
    }

    public String[] getMethodNames(final Class returnType) {
        final String cls = this.getFormClassName();
        Collection<? extends String> result = cls != null ? this.query(new Function<Queries, Collection<? extends String>>(){
            final /* synthetic */ FormJavaSource this$0;
            {
                this.this$0 = this$0;
            }

            public Collection<? extends String> apply(Queries queries) throws QueryException {
                return queries.getMethodNames(cls, true, returnType.getCanonicalName(), new String[0]);
            }
        }) : null;
        return result != null ? result.toArray(new String[0]) : new String[]{};
    }

    public String[] getPropertyReadMethodNames(Class returnType) {
        String[] names = this.getMethodNames(returnType);
        ArrayList<String> result = new ArrayList<String>(names.length);
        for (String name : names) {
            if (FormJavaSource.extractPropertyName(name).equals("")) continue;
            result.add(name);
        }
        return result.toArray(new String[0]);
    }

    public static String extractPropertyName(String methodName) {
        for (int i = 0; i < PROPERTY_PREFIXES.length; ++i) {
            if (!methodName.startsWith(PROPERTY_PREFIXES[i]) || methodName.length() <= PROPERTY_PREFIXES[i].length()) continue;
            return Introspector.decapitalize(methodName.substring(PROPERTY_PREFIXES[i].length()));
        }
        return "";
    }

    public void importFQNs(final int[][] ranges) {
        if (this.validJavaSource) {
            this.update(new Function<Updates, Boolean>(){
                final /* synthetic */ FormJavaSource this$0;
                {
                    this.this$0 = this$0;
                }

                public Boolean apply(Updates updates) throws QueryException {
                    updates.fixImports(ranges);
                    return true;
                }
            });
        }
    }

    public static boolean isInDefaultPackage(FormModel formModel) {
        FileObject fdo = FormEditor.getFormDataObject(formModel).getPrimaryFile();
        ClassPath cp = ClassPath.getClassPath((FileObject)fdo, (String)"classpath/source");
        String name = cp != null ? cp.getResourceName(fdo) : null;
        return name == null || name.indexOf(47) < 0;
    }

    private synchronized FileObject getJavaFile() {
        if (!this.javaFile.isValid()) {
            this.javaFile = this.formDataObject.getPrimaryFile();
        }
        return this.javaFile;
    }
}

