/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Insets;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.api.editor.guards.GuardedSectionManager;
import org.netbeans.api.editor.guards.SimpleSection;
import org.netbeans.modules.form.EditorSupport;
import org.netbeans.modules.form.FormDataObject;
import org.netbeans.modules.form.FormEditor;
import org.netbeans.modules.form.FormModel;
import org.netbeans.modules.form.FormProperty;
import org.netbeans.modules.form.FormUtils;
import org.netbeans.modules.form.RADComponent;
import org.netbeans.modules.form.RADConnectionPropertyEditor;
import org.netbeans.modules.form.RADProperty;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

class CodeCustomEditor
extends JPanel
implements DocumentListener,
Runnable {
    private RADConnectionPropertyEditor propertyEditor;
    private JEditorPane codePane;
    private boolean ignoreUpdate;
    private JLabel headerLabel = new JLabel();
    private JLabel footerLabel = new JLabel();
    private JTextField typeField = new JTextField();
    private JScrollPane jScrollPane = new JScrollPane(){

        @Override
        public Dimension getPreferredSize() {
            Dimension prefSize = super.getPreferredSize();
            JScrollBar hBar = this.getHorizontalScrollBar();
            if (hBar != null && hBar.isVisible()) {
                prefSize = new Dimension(prefSize.width, prefSize.height + ((Component)hBar).getPreferredSize().height);
            }
            return prefSize;
        }
    };
    private int lineHeight = -1;

    public CodeCustomEditor(RADConnectionPropertyEditor propertyEditor, FormModel formModel, FormProperty property) {
        this.propertyEditor = propertyEditor;
        this.codePane = new JEditorPane(){

            @Override
            public Dimension getPreferredScrollableViewportSize() {
                return new Dimension(super.getPreferredScrollableViewportSize().width, CodeCustomEditor.this.getPrefHeight(this));
            }

            @Override
            public Dimension getPreferredSize() {
                return new Dimension(super.getPreferredSize().width, CodeCustomEditor.this.getPrefHeight(this));
            }

            @Override
            public Dimension getMinimumSize() {
                return new Dimension(super.getMinimumSize().width, CodeCustomEditor.this.getPrefHeight(this));
            }
        };
        this.codePane.getAccessibleContext().setAccessibleName(NbBundle.getBundle(CodeCustomEditor.class).getString("ACSN_CustomCode_EditorPane"));
        this.headerLabel.setLabelFor(this.codePane);
        this.jScrollPane.setViewportView(this.codePane);
        this.jScrollPane.getViewport().setBackground(new Color(this.codePane.getBackground().getRGB()));
        int codePos = -1;
        FormDataObject dobj = FormEditor.getFormDataObject(formModel);
        EditorSupport es = dobj.getFormEditorSupport();
        GuardedSectionManager gsm = es.getGuardedSectionManager();
        SimpleSection sec = gsm.findSimpleSection("initComponents");
        if (property instanceof RADProperty && property.getWriteMethod() != null) {
            RADComponent metacomp = ((RADProperty)property).getRADComponent();
            this.headerLabel.setText("<html>" + metacomp.getName() + ".<b>" + property.getWriteMethod().getName() + "</b>(");
            this.footerLabel.setText(");");
            String codeSnippet = metacomp != formModel.getTopRADComponent() ? " " + metacomp.getName() + "." + property.getWriteMethod().getName() + "(" : " " + property.getWriteMethod().getName() + "(";
            codePos = sec.getText().indexOf(codeSnippet);
            if (codePos >= 0) {
                codePos += codeSnippet.length();
            }
        } else {
            this.headerLabel.setText(FormUtils.getBundleString("CodeCustomEditor.codeLabel"));
        }
        if (codePos < 0) {
            codePos = sec.getText().indexOf(123) + 2;
        }
        FormUtils.setupEditorPane(this.codePane, dobj.getPrimaryFile(), codePos + sec.getStartPosition().getOffset());
        this.headerLabel.setFont(this.codePane.getFont());
        this.footerLabel.setFont(this.codePane.getFont());
        this.typeField.setBorder(BorderFactory.createEmptyBorder());
        this.typeField.setEditable(false);
        this.typeField.setFont(this.codePane.getFont());
        this.typeField.setText(Utilities.getClassName((Class)property.getValueType()));
        if (UIManager.getLookAndFeel().getID().equals("Nimbus")) {
            this.typeField.setBackground(new Color(this.getBackground().getRGB()));
        }
        this.resetLayout();
        this.codePane.getDocument().addDocumentListener(this);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent ev) {
                CodeCustomEditor.this.revalidate();
                CodeCustomEditor.this.repaint();
            }
        });
    }

    private void resetLayout() {
        int maxHeight;
        int prefHeight;
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setAutoCreateContainerGaps(true);
        layout.setHorizontalGroup(layout.createSequentialGroup().addComponent(this.headerLabel, -2, -1, -2).addGap(3).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane, -2, 320, Short.MAX_VALUE).addComponent(this.typeField)).addGap(3).addComponent(this.footerLabel));
        if (this.jScrollPane.getPreferredSize().getHeight() > 300.0) {
            prefHeight = 300;
            maxHeight = -1;
        } else {
            prefHeight = -1;
            maxHeight = -2;
        }
        layout.setVerticalGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(this.jScrollPane.getInsets().top).addGroup(layout.createParallelGroup().addComponent(this.headerLabel).addComponent(this.footerLabel))).addComponent(this.jScrollPane, -1, prefHeight, maxHeight)).addComponent(this.typeField, -2, -1, -2));
    }

    void setValue(RADConnectionPropertyEditor.RADConnectionDesignValue value) {
        if (value != null && value.getType() == 2) {
            this.ignoreUpdate = true;
            this.codePane.setText(value.getCode());
            this.ignoreUpdate = false;
            this.resetLayout();
        }
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.invokeUpdate();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.invokeUpdate();
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
    }

    private void invokeUpdate() {
        if (!this.ignoreUpdate) {
            this.ignoreUpdate = true;
            EventQueue.invokeLater(this);
            this.revalidate();
            this.repaint();
        }
    }

    private int getPrefHeight(JEditorPane pane) {
        if (this.lineHeight < 0) {
            this.lineHeight = pane.getFontMetrics(pane.getFont()).getHeight();
        }
        int lineCount = pane.getDocument().getDefaultRootElement().getElementCount();
        Insets ins = pane.getInsets();
        return this.lineHeight * lineCount + ins.top + ins.bottom;
    }

    @Override
    public void run() {
        this.propertyEditor.setValue(new RADConnectionPropertyEditor.RADConnectionDesignValue(this.codePane.getText()));
        this.ignoreUpdate = false;
    }
}

