/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.glassfish.common.nodes;

import java.awt.Image;
import java.util.ArrayList;
import javax.swing.Action;
import org.netbeans.modules.glassfish.common.nodes.Hk2Cookie;
import org.netbeans.modules.glassfish.common.nodes.actions.DisableModulesAction;
import org.netbeans.modules.glassfish.common.nodes.actions.EditDetailsAction;
import org.netbeans.modules.glassfish.common.nodes.actions.EnableModulesAction;
import org.netbeans.modules.glassfish.common.nodes.actions.OpenTestURLAction;
import org.netbeans.modules.glassfish.common.nodes.actions.OpenURLAction;
import org.netbeans.modules.glassfish.common.nodes.actions.RefreshModulesAction;
import org.netbeans.modules.glassfish.common.nodes.actions.UndeployModuleAction;
import org.netbeans.modules.glassfish.common.nodes.actions.UnregisterResourceAction;
import org.netbeans.modules.glassfish.spi.Decorator;
import org.netbeans.modules.glassfish.spi.ResourceDecorator;
import org.openide.actions.CopyAction;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.actions.SystemAction;

public class Hk2ItemNode
extends AbstractNode {
    private static final String RESOURCES_ICON = "org/netbeans/modules/glassfish/common/resources/resources.gif";
    private static final String WS_ICON = "org/netbeans/modules/glassfish/common/resources/webservice.png";
    public static final Decorator J2EE_APPLICATION_FOLDER = new Decorator(){

        @Override
        public boolean isRefreshable() {
            return true;
        }

        @Override
        public boolean canDeployTo() {
            return true;
        }
    };
    public static final Decorator RESOURCES_FOLDER = new Decorator(){

        @Override
        public boolean isRefreshable() {
            return true;
        }

        @Override
        public Image getIcon(int type) {
            return ImageUtilities.loadImage((String)Hk2ItemNode.RESOURCES_ICON);
        }

        @Override
        public Image getOpenedIcon(int type) {
            return this.getIcon(type);
        }
    };
    public static final Decorator WS_FOLDER = new Decorator(){

        @Override
        public boolean isRefreshable() {
            return true;
        }
    };
    public static final Decorator WS_ENDPOINT = new Decorator(){

        @Override
        public boolean canTest() {
            return true;
        }

        @Override
        public boolean canCopy() {
            return true;
        }

        @Override
        public Image getIcon(int type) {
            return ImageUtilities.loadImage((String)Hk2ItemNode.WS_ICON);
        }

        @Override
        public Image getOpenedIcon(int type) {
            return this.getIcon(type);
        }
    };
    public static final Decorator J2EE_APPLICATION = new Decorator(){

        @Override
        public boolean canUndeploy() {
            return true;
        }

        @Override
        public boolean canEnable() {
            return true;
        }

        @Override
        public boolean canDisable() {
            return true;
        }

        @Override
        public boolean canShowBrowser() {
            return true;
        }
    };
    public static final Decorator REFRESHABLE_FOLDER = new Decorator(){

        @Override
        public boolean isRefreshable() {
            return true;
        }

        @Override
        public boolean canDeployTo() {
            return true;
        }
    };
    public static final Decorator JDBC_MANAGED_DATASOURCES = new ResourceDecorator(){

        @Override
        public boolean canUnregister() {
            return true;
        }

        @Override
        public Image getIcon(int type) {
            return ImageUtilities.loadImage((String)Hk2ItemNode.RESOURCES_ICON);
        }

        @Override
        public String getCmdPropertyName() {
            return "jdbc_resource_name";
        }
    };
    public static final Decorator CONNECTION_POOLS = new ResourceDecorator(){

        @Override
        public boolean canUnregister() {
            return true;
        }

        @Override
        public Image getIcon(int type) {
            return ImageUtilities.loadImage((String)Hk2ItemNode.RESOURCES_ICON);
        }

        @Override
        public String getCmdPropertyName() {
            return "jdbc_connection_pool_id";
        }

        @Override
        public boolean isCascadeDelete() {
            return true;
        }
    };
    protected final Decorator decorator;

    protected Hk2ItemNode(Children children, Lookup lookup, String name, Decorator decorator) {
        super(children);
        this.decorator = decorator;
        if (decorator.isRefreshable()) {
            this.getCookieSet().add((Node.Cookie)new Hk2Cookie.Refresh(children));
        }
        if (decorator.canDeployTo()) {
            this.getCookieSet().add((Node.Cookie)new Hk2Cookie.Deploy(lookup));
        }
        if (decorator.canUndeploy()) {
            this.getCookieSet().add((Node.Cookie)new Hk2Cookie.Undeploy(lookup, name));
        }
        if (decorator.canEnable()) {
            this.getCookieSet().add((Node.Cookie)new Hk2Cookie.Enable(lookup, name));
        }
        if (decorator.canDisable()) {
            this.getCookieSet().add((Node.Cookie)new Hk2Cookie.Disable(lookup, name));
        }
    }

    public Hk2ItemNode(Lookup lookup, Children children, String name, Decorator decorator) {
        this(children, lookup, name, decorator);
        this.setDisplayName(name);
    }

    public Image getIcon(int type) {
        Image badge = this.decorator.getIconBadge();
        Image image = badge != null ? (null == this.decorator.getIcon(type) ? Hk2ItemNode.badgeFolder(badge, false) : Hk2ItemNode.badgeIcon(badge, this.decorator.getIcon(type))) : this.decorator.getIcon(type);
        return image != null ? image : Hk2ItemNode.getIconDelegate().getIcon(type);
    }

    public Image getOpenedIcon(int type) {
        Image badge = this.decorator.getIconBadge();
        Image image = badge != null ? Hk2ItemNode.badgeFolder(badge, true) : this.decorator.getOpenedIcon(type);
        return image != null ? image : Hk2ItemNode.getIconDelegate().getOpenedIcon(type);
    }

    public Action[] getActions(boolean context) {
        ArrayList<SystemAction> actions = new ArrayList<SystemAction>();
        if (this.decorator.isRefreshable()) {
            actions.add(SystemAction.get(RefreshModulesAction.class));
        }
        if (this.decorator.canDeployTo()) {
            // empty if block
        }
        if (this.decorator.canUndeploy()) {
            actions.add(SystemAction.get(UndeployModuleAction.class));
        }
        if (this.decorator.canEnable()) {
            actions.add(SystemAction.get(EnableModulesAction.class));
        }
        if (this.decorator.canDisable()) {
            actions.add(SystemAction.get(DisableModulesAction.class));
        }
        if (this.decorator.canUnregister()) {
            actions.add(SystemAction.get(UnregisterResourceAction.class));
        }
        if (this.decorator.canShowBrowser()) {
            actions.add(SystemAction.get(OpenURLAction.class));
        }
        if (this.decorator.canTest()) {
            actions.add(SystemAction.get(OpenTestURLAction.class));
        }
        if (this.decorator.canCopy()) {
            actions.add(SystemAction.get(CopyAction.class));
        }
        if (this.decorator.canEditDetails()) {
            actions.add(SystemAction.get(EditDetailsAction.class));
        }
        return (Action[])actions.toArray(Action[]::new);
    }

    public static Node createWaitNode() {
        AbstractNode node = new AbstractNode(Children.LEAF);
        node.setName(NbBundle.getMessage(Hk2ItemNode.class, (String)"LBL_WaitNode_DisplayName"));
        node.setIconBaseWithExtension("org/openide/src/resources/wait.gif");
        return node;
    }

    public static Image badgeFolder(Image badge, boolean opened) {
        Node folderNode = Hk2ItemNode.getIconDelegate();
        Image folder = opened ? folderNode.getOpenedIcon(1) : folderNode.getIcon(1);
        return ImageUtilities.mergeImages((Image)folder, (Image)badge, (int)7, (int)7);
    }

    public static Image badgeIcon(Image badge, Image icon) {
        return ImageUtilities.mergeImages((Image)icon, (Image)badge, (int)7, (int)7);
    }

    private static Node getIconDelegate() {
        return DataFolder.findFolder((FileObject)FileUtil.getConfigRoot()).getNodeDelegate();
    }
}

