/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.multitabs.project;

import java.beans.PropertyChangeListener;
import java.util.Map;
import java.util.WeakHashMap;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.core.multitabs.impl.ProjectSupport;
import org.netbeans.swing.tabcontrol.TabData;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.util.ChangeSupport;
import org.openide.util.RequestProcessor;
import org.openide.windows.TopComponent;

public class ProjectSupportImpl
extends ProjectSupport {
    private static final Map<FileObject, Project> file2project = new WeakHashMap<FileObject, Project>(50);
    private static final RequestProcessor RP = new RequestProcessor("TabProjectBridge");
    private static final ChangeSupport changeSupport = new ChangeSupport((Object)RP);
    private static PropertyChangeListener projectsListener;

    public boolean isEnabled() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChangeListener(ChangeListener l) {
        ChangeSupport changeSupport = ProjectSupportImpl.changeSupport;
        synchronized (changeSupport) {
            ProjectSupportImpl.changeSupport.addChangeListener(l);
            if (null == projectsListener) {
                projectsListener = evt -> changeSupport.fireChange();
                OpenProjects.getDefault().addPropertyChangeListener(projectsListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeChangeListener(ChangeListener l) {
        ChangeSupport changeSupport = ProjectSupportImpl.changeSupport;
        synchronized (changeSupport) {
            ProjectSupportImpl.changeSupport.removeChangeListener(l);
            if (!ProjectSupportImpl.changeSupport.hasListeners() && null != projectsListener) {
                OpenProjects.getDefault().removePropertyChangeListener(projectsListener);
                projectsListener = null;
            }
        }
    }

    public ProjectSupport.ProjectProxy[] getOpenProjects() {
        Project[] projects = OpenProjects.getDefault().getOpenProjects();
        ProjectSupport.ProjectProxy[] res = new ProjectSupport.ProjectProxy[projects.length];
        for (int i = 0; i < projects.length; ++i) {
            ProjectSupport.ProjectProxy proxy;
            Project p = projects[i];
            res[i] = proxy = ProjectSupportImpl.createProxy(p);
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProjectSupport.ProjectProxy getProjectForTab(TabData tab) {
        FileObject fo;
        TopComponent tc;
        DataObject dob;
        Project p = null;
        if (null != tab && tab.getComponent() instanceof TopComponent && null != (dob = (DataObject)(tc = (TopComponent)tab.getComponent()).getLookup().lookup(DataObject.class)) && null != (fo = dob.getPrimaryFile())) {
            Map<FileObject, Project> map = file2project;
            synchronized (map) {
                p = file2project.get(fo);
                if (null == p && null != (p = FileOwnerQuery.getOwner((FileObject)fo))) {
                    file2project.put(fo, p);
                }
            }
        }
        return null == p ? null : ProjectSupportImpl.createProxy(p);
    }

    private static ProjectSupport.ProjectProxy createProxy(Project p) {
        ProjectInformation info = ProjectUtils.getInformation((Project)p);
        FileObject projectDir = p.getProjectDirectory();
        return new ProjectSupport.ProjectProxy((Object)p, info.getDisplayName(), projectDir.getPath());
    }
}

