/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.vault.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.vault.model.ChangeSecretCompartmentDetails;
import java.util.Objects;

public class ChangeSecretCompartmentRequest
extends BmcRequest<ChangeSecretCompartmentDetails> {
    private String secretId;
    private ChangeSecretCompartmentDetails changeSecretCompartmentDetails;
    private String ifMatch;
    private String opcRequestId;
    private String opcRetryToken;

    public String getSecretId() {
        return this.secretId;
    }

    public ChangeSecretCompartmentDetails getChangeSecretCompartmentDetails() {
        return this.changeSecretCompartmentDetails;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    @InternalSdk
    public ChangeSecretCompartmentDetails getBody$() {
        return this.changeSecretCompartmentDetails;
    }

    public Builder toBuilder() {
        return new Builder().secretId(this.secretId).changeSecretCompartmentDetails(this.changeSecretCompartmentDetails).ifMatch(this.ifMatch).opcRequestId(this.opcRequestId).opcRetryToken(this.opcRetryToken);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",secretId=").append(String.valueOf(this.secretId));
        sb.append(",changeSecretCompartmentDetails=").append(String.valueOf((Object)this.changeSecretCompartmentDetails));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",opcRetryToken=").append(String.valueOf(this.opcRetryToken));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ChangeSecretCompartmentRequest)) {
            return false;
        }
        ChangeSecretCompartmentRequest other = (ChangeSecretCompartmentRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.secretId, other.secretId) && Objects.equals((Object)this.changeSecretCompartmentDetails, (Object)other.changeSecretCompartmentDetails) && Objects.equals(this.ifMatch, other.ifMatch) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.opcRetryToken, other.opcRetryToken);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.secretId == null ? 43 : this.secretId.hashCode());
        result = result * 59 + (this.changeSecretCompartmentDetails == null ? 43 : this.changeSecretCompartmentDetails.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.opcRetryToken == null ? 43 : this.opcRetryToken.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<ChangeSecretCompartmentRequest, ChangeSecretCompartmentDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String secretId = null;
        private ChangeSecretCompartmentDetails changeSecretCompartmentDetails = null;
        private String ifMatch = null;
        private String opcRequestId = null;
        private String opcRetryToken = null;

        public Builder secretId(String secretId) {
            this.secretId = secretId;
            return this;
        }

        public Builder changeSecretCompartmentDetails(ChangeSecretCompartmentDetails changeSecretCompartmentDetails) {
            this.changeSecretCompartmentDetails = changeSecretCompartmentDetails;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ChangeSecretCompartmentRequest o) {
            this.secretId(o.getSecretId());
            this.changeSecretCompartmentDetails(o.getChangeSecretCompartmentDetails());
            this.ifMatch(o.getIfMatch());
            this.opcRequestId(o.getOpcRequestId());
            this.opcRetryToken(o.getOpcRetryToken());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ChangeSecretCompartmentRequest build() {
            ChangeSecretCompartmentRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(ChangeSecretCompartmentDetails body) {
            this.changeSecretCompartmentDetails(body);
            return this;
        }

        public ChangeSecretCompartmentRequest buildWithoutInvocationCallback() {
            ChangeSecretCompartmentRequest request = new ChangeSecretCompartmentRequest();
            request.secretId = this.secretId;
            request.changeSecretCompartmentDetails = this.changeSecretCompartmentDetails;
            request.ifMatch = this.ifMatch;
            request.opcRequestId = this.opcRequestId;
            request.opcRetryToken = this.opcRetryToken;
            return request;
        }
    }
}

