/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.vault.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.vault.model.Base64SecretContentDetails;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="contentType", defaultImpl=SecretContentDetails.class)
@JsonSubTypes(value={@JsonSubTypes.Type(value=Base64SecretContentDetails.class, name="BASE64")})
@JsonFilter(value="explicitlySetFilter")
public class SecretContentDetails
extends ExplicitlySetBmcModel {
    @JsonProperty(value="name")
    private final String name;
    @JsonProperty(value="stage")
    private final Stage stage;

    @Deprecated
    @ConstructorProperties(value={"name", "stage"})
    protected SecretContentDetails(String name, Stage stage) {
        this.name = name;
        this.stage = stage;
    }

    public String getName() {
        return this.name;
    }

    public Stage getStage() {
        return this.stage;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("SecretContentDetails(");
        sb.append("super=").append(super.toString());
        sb.append("name=").append(String.valueOf(this.name));
        sb.append(", stage=").append(String.valueOf((Object)this.stage));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SecretContentDetails)) {
            return false;
        }
        SecretContentDetails other = (SecretContentDetails)((Object)o);
        return Objects.equals(this.name, other.name) && Objects.equals((Object)this.stage, (Object)other.stage) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.name == null ? 43 : this.name.hashCode());
        result = result * 59 + (this.stage == null ? 43 : this.stage.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum ContentType implements BmcEnum
    {
        Base64("BASE64");

        private final String value;
        private static Map<String, ContentType> map;

        private ContentType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static ContentType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid ContentType: " + key);
        }

        static {
            map = new HashMap<String, ContentType>();
            for (ContentType v : ContentType.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum Stage implements BmcEnum
    {
        Current("CURRENT"),
        Pending("PENDING");

        private final String value;
        private static Map<String, Stage> map;

        private Stage(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Stage create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid Stage: " + key);
        }

        static {
            map = new HashMap<String, Stage>();
            for (Stage v : Stage.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

