/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cordova.updatetask;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.netbeans.modules.cordova.updatetask.XMLFile;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DeviceConfig
extends XMLFile {
    private String root;

    public DeviceConfig(InputStream resource) throws IOException {
        super(resource);
        this.init();
    }

    public DeviceConfig(File androidConfigFile) throws IOException {
        super(androidConfigFile);
        this.init();
    }

    public String getAccess() {
        return this.getAttributeText(this.root + "/access", "origin");
    }

    public void setAccess(String access) {
        this.setAttributeText(this.root + "/access", "origin", access);
    }

    public String getContent() {
        return this.getAttributeText(this.root + "/content", "src");
    }

    public void setContent(String src) {
        this.setAttributeText(this.root + "/content", "src", src);
    }

    public void setPreference(String name, String value) {
        NodeList nodes = this.getXpathNodes(this.root + "/preference");
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node n = nodes.item(i);
            String nameAttr = this.getAttributeText(n, "name");
            if (!name.equals(nameAttr)) continue;
            ((Element)n).setAttribute("name", name);
            ((Element)n).setAttribute("value", value);
            return;
        }
        Element createElement = this.doc.createElement("preference");
        createElement.setAttribute("name", name);
        createElement.setAttribute("value", value);
        this.getXpathNode(this.root).appendChild(createElement);
    }

    public String getPreference(String name) {
        return this.getAttributeText(this.root + "/preference", name);
    }

    private void init() {
        this.root = this.getNode("/cordova") != null ? "/cordova" : "/widget";
    }
}

