/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.docker.editor.completion;

import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import javax.swing.ImageIcon;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.editor.document.LineDocument;
import org.netbeans.api.editor.document.LineDocumentUtils;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.csl.api.CodeCompletionContext;
import org.netbeans.modules.csl.api.CodeCompletionHandler;
import org.netbeans.modules.csl.api.CodeCompletionHandler2;
import org.netbeans.modules.csl.api.CodeCompletionResult;
import org.netbeans.modules.csl.api.CompletionProposal;
import org.netbeans.modules.csl.api.Documentation;
import org.netbeans.modules.csl.api.ElementHandle;
import org.netbeans.modules.csl.api.ElementKind;
import org.netbeans.modules.csl.api.Modifier;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.api.ParameterInfo;
import org.netbeans.modules.csl.spi.DefaultCompletionProposal;
import org.netbeans.modules.csl.spi.DefaultCompletionResult;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.docker.editor.lexer.DockerfileTokenId;
import org.netbeans.modules.docker.editor.parser.Command;
import org.netbeans.modules.docker.editor.util.DocDownloader;
import org.openide.filesystems.FileObject;
import org.openide.util.ImageUtilities;
import org.openide.util.Parameters;

public final class DockerfileCompletion
implements CodeCompletionHandler2 {
    public CodeCompletionResult complete(CodeCompletionContext context) {
        switch (context.getQueryType()) {
            case COMPLETION: 
            case ALL_COMPLETION: 
            case DOCUMENTATION: {
                return this.completeImpl(context);
            }
        }
        return null;
    }

    public String document(ParserResult info, ElementHandle element) {
        return Optional.ofNullable(this.documentElement(info, element, () -> false)).map(doc -> doc.getContent()).orElse(null);
    }

    public ElementHandle resolveLink(String link, ElementHandle originalHandle) {
        if (originalHandle.getKind() == ElementKind.KEYWORD) {
            return Optional.ofNullable(Command.forHandle(originalHandle)).map(cmd -> cmd.getDocumentation(null)).map(doc -> doc.getUrl()).map(url -> {
                try {
                    return url.toURI();
                }
                catch (URISyntaxException e) {
                    return null;
                }
            }).map(uri -> {
                try {
                    return uri.resolve(new URI(link));
                }
                catch (URISyntaxException e) {
                    return null;
                }
            }).map(uri -> new DocHandle((URI)uri)).orElse(null);
        }
        return null;
    }

    public Documentation documentElement(@NonNull ParserResult info, @NonNull ElementHandle element, @NonNull Callable<Boolean> cancel) {
        switch (element.getKind()) {
            case KEYWORD: {
                return Optional.ofNullable(Command.forHandle(element)).map(cmd -> cmd.getDocumentation(cancel)).orElse(null);
            }
            case OTHER: {
                try {
                    URL url = ((DocHandle)element).getURI().toURL();
                    Future<String> becomesContent = DocDownloader.download(url, cancel);
                    String content = null;
                    while (cancel.call() != Boolean.TRUE) {
                        try {
                            content = becomesContent.get(250L, TimeUnit.MILLISECONDS);
                            break;
                        }
                        catch (TimeoutException timeoutException) {
                        }
                    }
                    return content == null ? null : DocDownloader.parseSection(content, url);
                }
                catch (Exception e) {
                    return null;
                }
            }
        }
        return null;
    }

    public String getPrefix(ParserResult info, int caretOffset, boolean upToOffset) {
        return null;
    }

    public CodeCompletionHandler.QueryType getAutoQuery(JTextComponent component, String typedText) {
        return CodeCompletionHandler.QueryType.COMPLETION;
    }

    public String resolveTemplateVariable(String variable, ParserResult info, int caretOffset, String name, Map parameters) {
        return null;
    }

    public Set<String> getApplicableTemplates(Document doc, int selectionBegin, int selectionEnd) {
        return null;
    }

    public ParameterInfo parameters(ParserResult info, int caretOffset, CompletionProposal proposal) {
        return ParameterInfo.NONE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CodeCompletionResult completeImpl(@NonNull CodeCompletionContext ctx) {
        BaseDocument doc = (BaseDocument)ctx.getParserResult().getSnapshot().getSource().getDocument(false);
        if (doc == null) {
            return CodeCompletionResult.NONE;
        }
        doc.readLock();
        try {
            Token prev;
            int offset = ctx.getCaretOffset();
            String prefix = ctx.getPrefix();
            int lineStart = LineDocumentUtils.getLineStart((LineDocument)doc, (int)offset);
            int anchor = offset - (prefix == null ? 0 : prefix.length());
            if (anchor == lineStart) {
                CodeCompletionResult codeCompletionResult = DockerfileCompletion.commands(prefix, anchor, false);
                return codeCompletionResult;
            }
            TokenSequence seq = TokenHierarchy.get((Document)doc).tokenSequence(DockerfileTokenId.language());
            if (seq == null) {
                CodeCompletionResult codeCompletionResult = CodeCompletionResult.NONE;
                return codeCompletionResult;
            }
            seq.move(Math.max(0, offset - 1));
            if (!seq.moveNext() && !seq.movePrevious()) {
                CodeCompletionResult codeCompletionResult = CodeCompletionResult.NONE;
                return codeCompletionResult;
            }
            Token current = seq.token();
            if (current != null && current.id() != DockerfileTokenId.WHITESPACE) {
                anchor = seq.offset();
                prefix = current.text().toString().substring(0, offset - anchor);
                seq.movePrevious();
            } else {
                anchor = offset;
                prefix = "";
            }
            while ((prev = seq.token()) != null && prev.id() == DockerfileTokenId.WHITESPACE && seq.movePrevious()) {
            }
            if (prev != null && prev.id() == DockerfileTokenId.ONBUILD && LineDocumentUtils.getLineStart((LineDocument)doc, (int)seq.offset()) == LineDocumentUtils.getLineStart((LineDocument)doc, (int)anchor)) {
                CodeCompletionResult codeCompletionResult = DockerfileCompletion.commands(prefix, anchor, true);
                return codeCompletionResult;
            }
            CodeCompletionResult codeCompletionResult = CodeCompletionResult.NONE;
            return codeCompletionResult;
        }
        finally {
            doc.readUnlock();
        }
    }

    @NonNull
    private static CodeCompletionResult commands(String prefix, int anchor, boolean afterOnBuild) {
        List commands = Command.getCommandNames(prefix).stream().map(name -> Command.forName(name)).filter(cmd -> cmd != null && (!afterOnBuild || cmd.isOnBuildSupported())).map(cmd -> new CmdCompletionProposal((Command)((Object)cmd), DockerfileCompletion.isUpcase(prefix), anchor)).collect(Collectors.toList());
        if (commands.isEmpty()) {
            return CodeCompletionResult.NONE;
        }
        DefaultCompletionResult res = new DefaultCompletionResult(commands, false);
        res.setFilterable(false);
        return res;
    }

    private static boolean isUpcase(@NullAllowed CharSequence text) {
        if (text != null) {
            for (int i = 0; i < text.length(); ++i) {
                if (!Character.isLowerCase(text.charAt(i))) continue;
                return false;
            }
        }
        return true;
    }

    private static final class DocHandle
    implements ElementHandle {
        private final URI uri;

        DocHandle(@NonNull URI uri) {
            Parameters.notNull((CharSequence)"uri", (Object)uri);
            this.uri = uri;
        }

        public FileObject getFileObject() {
            return null;
        }

        public String getMimeType() {
            return "text/x-dockerfile";
        }

        public String getName() {
            return this.uri.toString();
        }

        public String getIn() {
            return null;
        }

        public ElementKind getKind() {
            return ElementKind.OTHER;
        }

        public Set<Modifier> getModifiers() {
            return Collections.emptySet();
        }

        public boolean signatureEquals(ElementHandle handle) {
            return this.getKind().equals((Object)handle.getKind()) && this.getName().equals(handle.getName());
        }

        public OffsetRange getOffsetRange(ParserResult result) {
            return OffsetRange.NONE;
        }

        @NonNull
        URI getURI() {
            return this.uri;
        }
    }

    private static final class CmdCompletionProposal
    extends DefaultCompletionProposal {
        private static final String DOCKER_ICON = "org/netbeans/modules/docker/editor/resources/docker.png";
        private final Command cmd;
        private final boolean upperCase;

        CmdCompletionProposal(@NonNull Command cmd, boolean upcase, int anchor) {
            this.cmd = cmd;
            this.upperCase = upcase;
            this.setKind(ElementKind.KEYWORD);
            this.setAnchorOffset(anchor);
        }

        public ElementHandle getElement() {
            return this.cmd.toElementHandle();
        }

        public String getName() {
            return this.cmd.getName();
        }

        public ImageIcon getIcon() {
            return ImageUtilities.loadImageIcon((String)DOCKER_ICON, (boolean)true);
        }

        public String getInsertPrefix() {
            return String.format("%s ", this.upperCase ? this.getName() : this.getName().toLowerCase());
        }
    }
}

