/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tasklist.todo.settings;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.prefs.Preferences;
import org.netbeans.modules.tasklist.todo.settings.CommentTags;
import org.netbeans.modules.tasklist.todo.settings.ExtensionIdentifier;
import org.netbeans.modules.tasklist.todo.settings.FileIdentifier;
import org.netbeans.modules.tasklist.todo.settings.MimeIdentifier;
import org.openide.util.NbPreferences;

public final class Settings {
    public static final String PROP_PATTERN_LIST = "patternList";
    public static final String PROP_SCAN_COMMENTS_ONLY = "scanCommentsOnly";
    public static final String PROP_IDENTIFIERS_LIST = "identifiersList";
    private static Settings theInstance;
    private static final String OBJECT_DELIMITER = "|";
    private static final String FIELD_DELIMITER = ",";
    private final ArrayList<String> patterns = new ArrayList(10);
    private Map<String, ExtensionIdentifier> ext2comments = new HashMap<String, ExtensionIdentifier>();
    private Map<String, MimeIdentifier> mime2comments = new HashMap<String, MimeIdentifier>();
    private final Map<String, ExtensionIdentifier> ext2commentsDefault = new HashMap<String, ExtensionIdentifier>(25);
    private final Map<String, MimeIdentifier> mime2commentsDefault = new HashMap<String, MimeIdentifier>(25);
    private boolean scanCommentsOnly = true;
    private PropertyChangeSupport propertySupport;
    private static final String MIME_IDENTIFIERS = "mimeidentifiers";
    private static final String EXT_IDENTIFIERS = "extidentifiers";

    private Settings() {
        this.patterns.addAll(Settings.decodePatterns(this.getPreferences().get("patterns", "@todo|TODO|FIXME|XXX|PENDING|<<<<<<<")));
        this.scanCommentsOnly = this.getPreferences().getBoolean(PROP_SCAN_COMMENTS_ONLY, true);
        this.ext2commentsDefault.put("JAVA", new ExtensionIdentifier("JAVA", new CommentTags("//", "/*", "*/")));
        this.ext2commentsDefault.put("JS", new ExtensionIdentifier("JS", new CommentTags("//", "/*", "*/")));
        this.ext2commentsDefault.put("C", new ExtensionIdentifier("C", new CommentTags("//", "/*", "*/")));
        this.ext2commentsDefault.put("CPP", new ExtensionIdentifier("CPP", new CommentTags("//", "/*", "*/")));
        this.ext2commentsDefault.put("CXX", new ExtensionIdentifier("CXX", new CommentTags("//", "/*", "*/")));
        this.ext2commentsDefault.put("CC", new ExtensionIdentifier("CC", new CommentTags("//", "/*", "*/")));
        this.ext2commentsDefault.put("H", new ExtensionIdentifier("H", new CommentTags("//", "/*", "*/")));
        this.ext2commentsDefault.put("HPP", new ExtensionIdentifier("HPP", new CommentTags("//", "/*", "*/")));
        this.ext2commentsDefault.put("HTML", new ExtensionIdentifier("HTML", new CommentTags("<!--", "-->")));
        this.ext2commentsDefault.put("XHTML", new ExtensionIdentifier("XHTML", new CommentTags("<!--", "-->")));
        this.ext2commentsDefault.put("HTM", new ExtensionIdentifier("HTM", new CommentTags("<!--", "-->")));
        this.ext2commentsDefault.put("XML", new ExtensionIdentifier("XML", new CommentTags("<!--", "-->")));
        this.ext2commentsDefault.put("JSP", new ExtensionIdentifier("JSP", new CommentTags("<%--", "--%>")));
        this.ext2commentsDefault.put("CSS", new ExtensionIdentifier("CSS", new CommentTags("/*", "*/")));
        this.ext2commentsDefault.put("SCSS", new ExtensionIdentifier("SCSS", new CommentTags("//", "/*", "*/")));
        this.ext2commentsDefault.put("LESS", new ExtensionIdentifier("LESS", new CommentTags("//", "/*", "*/")));
        this.ext2commentsDefault.put("PROPERTIES", new ExtensionIdentifier("PROPERTIES", new CommentTags("#")));
        this.ext2commentsDefault.put("SH", new ExtensionIdentifier("SH", new CommentTags("#")));
        this.ext2commentsDefault.put("RB", new ExtensionIdentifier("RB", new CommentTags("#")));
        this.ext2commentsDefault.put("PHP", new ExtensionIdentifier("PHP", new CommentTags("//", "/*", "*/")));
        this.ext2commentsDefault.put("PY", new ExtensionIdentifier("PY", new CommentTags("#", "\"\"\"", "\"\"\"")));
        this.ext2commentsDefault.put("SCALA", new ExtensionIdentifier("SCALA", new CommentTags("//", "/*", "*/")));
        this.ext2commentsDefault.put("GROOVY", new ExtensionIdentifier("GROOVY", new CommentTags("//", "/*", "*/")));
        this.ext2commentsDefault.put("FX", new ExtensionIdentifier("FX", new CommentTags("//", "/*", "*/")));
        this.ext2commentsDefault.put("TWIG", new ExtensionIdentifier("TWIG", new CommentTags("{#", "#}")));
        this.ext2commentsDefault.put("TPL", new ExtensionIdentifier("TPL", new CommentTags("{*", "*}")));
        this.mime2commentsDefault.put("text/x-java", new MimeIdentifier("text/x-java", "Java Files", new CommentTags("//", "/*", "*/")));
        this.mime2commentsDefault.put("text/html", new MimeIdentifier("text/html", "HTML Files", new CommentTags("<!--", "-->")));
        this.mime2commentsDefault.put("application/x-httpd-eruby", new MimeIdentifier("application/x-httpd-eruby", "", new CommentTags("<!--", "-->")));
        this.mime2commentsDefault.put("text/x-yaml", new MimeIdentifier("text/x-yaml", "Yaml Files", new CommentTags("#")));
        this.mime2commentsDefault.put("text/x-python", new MimeIdentifier("text/x-python", "Python Files", new CommentTags("#", "\"\"\"", "\"\"\"")));
        this.mime2commentsDefault.put("text/x-fx", new MimeIdentifier("text/x-fx", "JavaFX Files", new CommentTags("//", "/*", "*/")));
        this.mime2commentsDefault.put("text/x-ruby", new MimeIdentifier("text/x-ruby", "Ruby Files", new CommentTags("#")));
        this.mime2commentsDefault.put("text/x-php5", new MimeIdentifier("text/x-php", "PHP Files", new CommentTags("//", "/*", "*/")));
        this.mime2commentsDefault.put("text/sh", new MimeIdentifier("text/sh", "", new CommentTags("#")));
        this.mime2commentsDefault.put("text/x-sql", new MimeIdentifier("text/x-sql", "SQL Files", new CommentTags("--", "/*", "*/")));
        String encodedMime = this.getPreferences().get(MIME_IDENTIFIERS, "");
        this.mime2comments = encodedMime.isEmpty() ? new HashMap<String, MimeIdentifier>(this.mime2commentsDefault) : Settings.decodeMimeIdentifiers(encodedMime);
        String encodedExt = this.getPreferences().get(EXT_IDENTIFIERS, "");
        this.ext2comments = encodedExt.isEmpty() ? new HashMap<String, ExtensionIdentifier>(this.ext2commentsDefault) : Settings.decodeExtIdentifiers(encodedExt);
    }

    public static final Settings getDefault() {
        if (null == theInstance) {
            theInstance = new Settings();
        }
        return theInstance;
    }

    public Collection<String> getPatterns() {
        return Collections.unmodifiableCollection(this.patterns);
    }

    public void setPatterns(Collection<String> newPatterns) {
        this.patterns.clear();
        this.patterns.addAll(newPatterns);
        this.getPreferences().put("patterns", Settings.encodePatterns(newPatterns));
        if (null == this.propertySupport) {
            this.propertySupport = new PropertyChangeSupport(this);
        }
        this.propertySupport.firePropertyChange(PROP_PATTERN_LIST, null, this.getPatterns());
    }

    public List<MimeIdentifier> getMimeIdentifiers() {
        ArrayList<MimeIdentifier> arrayList = new ArrayList<MimeIdentifier>(this.mime2comments.values());
        Collections.sort(arrayList);
        return arrayList;
    }

    public List<ExtensionIdentifier> getExtensionIdentifiers() {
        ArrayList<ExtensionIdentifier> arrayList = new ArrayList<ExtensionIdentifier>(this.ext2comments.values());
        Collections.sort(arrayList);
        return arrayList;
    }

    public void setIdentifiers(List<MimeIdentifier> mimeIdentifiers, List<ExtensionIdentifier> extensionIdentifiers) {
        this.mime2comments.clear();
        for (MimeIdentifier mimeIdentifier : mimeIdentifiers) {
            this.mime2comments.put(mimeIdentifier.getId(), mimeIdentifier);
        }
        this.getPreferences().put(MIME_IDENTIFIERS, Settings.encodeMimeIdentifiers(mimeIdentifiers));
        this.ext2comments.clear();
        for (ExtensionIdentifier extensionIdentifier : extensionIdentifiers) {
            this.ext2comments.put(extensionIdentifier.getId(), extensionIdentifier);
        }
        this.getPreferences().put(EXT_IDENTIFIERS, Settings.encodeExtIdentifiers(extensionIdentifiers));
        if (null == this.propertySupport) {
            this.propertySupport = new PropertyChangeSupport(this);
        }
        this.propertySupport.firePropertyChange(PROP_IDENTIFIERS_LIST, null, this.getPatterns());
    }

    public boolean isExtensionSupported(String fileExtension) {
        return null != this.ext2comments.get(fileExtension.toUpperCase());
    }

    public boolean isMimeTypeSupported(String mimeType) {
        return null != this.mime2comments.get(mimeType);
    }

    public String getLineComment(String fileExtension, String mime) {
        FileIdentifier identifier = this.mime2comments.get(mime);
        if (null == identifier) {
            identifier = this.ext2comments.get(fileExtension.toUpperCase());
        }
        return null == identifier ? null : identifier.getCommentTags().getLineComment();
    }

    public String getBlockCommentStart(String fileExtension, String mime) {
        FileIdentifier identifier = this.mime2comments.get(mime);
        if (null == identifier) {
            identifier = this.ext2comments.get(fileExtension.toUpperCase());
        }
        return null == identifier ? null : identifier.getCommentTags().getBlockCommentStart();
    }

    public String getBlockCommentEnd(String fileExtension, String mime) {
        FileIdentifier identifier = this.mime2comments.get(mime);
        if (null == identifier) {
            identifier = this.ext2comments.get(fileExtension.toUpperCase());
        }
        return null == identifier ? null : identifier.getCommentTags().getBlockCommentEnd();
    }

    public boolean isScanCommentsOnly() {
        return this.scanCommentsOnly;
    }

    public void setScanCommentsOnly(boolean val) {
        boolean oldVal = this.scanCommentsOnly;
        this.scanCommentsOnly = val;
        this.getPreferences().putBoolean(PROP_SCAN_COMMENTS_ONLY, val);
        if (null == this.propertySupport) {
            this.propertySupport = new PropertyChangeSupport(this);
        }
        this.propertySupport.firePropertyChange(PROP_SCAN_COMMENTS_ONLY, oldVal, val);
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        if (null == this.propertySupport) {
            this.propertySupport = new PropertyChangeSupport(this);
        }
        this.propertySupport.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        if (null != this.propertySupport) {
            this.propertySupport.removePropertyChangeListener(l);
        }
    }

    private Preferences getPreferences() {
        return NbPreferences.forModule(Settings.class);
    }

    private static Collection<String> decodePatterns(String encodedPatterns) {
        StringTokenizer st = new StringTokenizer(encodedPatterns, OBJECT_DELIMITER, false);
        ArrayList<String> patterns = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            String im = st.nextToken();
            patterns.add(im);
        }
        return patterns;
    }

    private static String encodePatterns(Collection<String> patterns) {
        StringBuilder sb = new StringBuilder();
        for (String p : patterns) {
            sb.append(p);
            sb.append(OBJECT_DELIMITER);
        }
        return sb.toString();
    }

    private static Map<String, MimeIdentifier> decodeMimeIdentifiers(String encodedIdentifiers) {
        StringTokenizer st = new StringTokenizer(encodedIdentifiers, OBJECT_DELIMITER, false);
        HashMap<String, MimeIdentifier> mimeIdentifiers = new HashMap<String, MimeIdentifier>(st.countTokens());
        while (st.hasMoreTokens()) {
            String im = st.nextToken();
            String[] fields = im.split(FIELD_DELIMITER, 5);
            MimeIdentifier mimeIdentifier = new MimeIdentifier(fields[0], fields[1], new CommentTags(fields[2], fields[3], fields[4]));
            mimeIdentifiers.put(mimeIdentifier.getId(), mimeIdentifier);
        }
        return mimeIdentifiers;
    }

    private static String encodeMimeIdentifiers(Collection<MimeIdentifier> identifiers) {
        StringBuilder sb = new StringBuilder();
        for (MimeIdentifier identifier : identifiers) {
            sb.append(identifier.getMimeType());
            sb.append(FIELD_DELIMITER);
            sb.append(identifier.getMimeName());
            sb.append(FIELD_DELIMITER);
            sb.append(Settings.encodeCommentTags(identifier.getCommentTags()));
            sb.append(OBJECT_DELIMITER);
        }
        return sb.toString();
    }

    private static Map<String, ExtensionIdentifier> decodeExtIdentifiers(String encodedIdentifiers) {
        StringTokenizer st = new StringTokenizer(encodedIdentifiers, OBJECT_DELIMITER, false);
        HashMap<String, ExtensionIdentifier> extensionIdentifiers = new HashMap<String, ExtensionIdentifier>(st.countTokens());
        while (st.hasMoreTokens()) {
            String im = st.nextToken();
            String[] fields = im.split(FIELD_DELIMITER, 4);
            ExtensionIdentifier extensionIdentifier = new ExtensionIdentifier(fields[0], new CommentTags(fields[1], fields[2], fields[3]));
            extensionIdentifiers.put(extensionIdentifier.getId(), extensionIdentifier);
        }
        return extensionIdentifiers;
    }

    private static String encodeExtIdentifiers(Collection<ExtensionIdentifier> identifiers) {
        StringBuilder sb = new StringBuilder();
        for (ExtensionIdentifier identifier : identifiers) {
            sb.append(identifier.getExtension());
            sb.append(FIELD_DELIMITER);
            sb.append(Settings.encodeCommentTags(identifier.getCommentTags()));
            sb.append(OBJECT_DELIMITER);
        }
        return sb.toString();
    }

    private static String encodeCommentTags(CommentTags tags) {
        StringBuilder sb = new StringBuilder();
        sb.append(tags.isLineCommentEnabled() ? tags.getLineComment() : "");
        sb.append(FIELD_DELIMITER);
        sb.append(tags.isBlockCommentEnabled() ? tags.getBlockCommentStart() : "");
        sb.append(FIELD_DELIMITER);
        sb.append(tags.isBlockCommentEnabled() ? tags.getBlockCommentEnd() : "");
        return sb.toString();
    }
}

