/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.hudson.php;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.project.Project;
import org.netbeans.modules.hudson.php.Bundle;
import org.netbeans.modules.hudson.php.options.HudsonOptions;
import org.netbeans.modules.hudson.php.options.HudsonOptionsValidator;
import org.netbeans.modules.hudson.php.util.BuildXmlUtils;
import org.netbeans.modules.hudson.php.util.PhpUnitUtils;
import org.netbeans.modules.hudson.php.util.XmlUtils;
import org.netbeans.modules.hudson.spi.HudsonSCM;
import org.netbeans.modules.hudson.ui.spi.ProjectHudsonJobCreatorFactory;
import org.netbeans.modules.php.api.phpmodule.PhpModule;
import org.netbeans.modules.php.api.util.UiUtils;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.ChangeSupport;
import org.openide.util.WeakListeners;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public final class HudsonJobCreator
extends JPanel
implements ProjectHudsonJobCreatorFactory.ProjectHudsonJobCreator,
ChangeListener {
    private static final long serialVersionUID = 1657613213547587L;
    private static final Logger LOGGER = Logger.getLogger(HudsonJobCreator.class.getName());
    private final PhpModule phpModule;
    private final HudsonSCM.Configuration scm;
    private final ChangeSupport changeSupport = new ChangeSupport((Object)this);

    private HudsonJobCreator(PhpModule phpModule) {
        assert (phpModule != null);
        this.phpModule = phpModule;
        this.scm = ProjectHudsonJobCreatorFactory.Helper.prepareSCM((File)FileUtil.toFile((FileObject)phpModule.getProjectDirectory()));
    }

    private static HudsonJobCreator forPhpModule(PhpModule phpModule) {
        HudsonJobCreator hudsonJobCreator = new HudsonJobCreator(phpModule);
        HudsonOptions options = HudsonOptions.getInstance();
        options.addChangeListener(WeakListeners.change((ChangeListener)hudsonJobCreator, (Object)options));
        return hudsonJobCreator;
    }

    public String jobName() {
        return this.phpModule.getDisplayName();
    }

    public JComponent customizer() {
        return this;
    }

    public HudsonSCM.ConfigurationStatus status() {
        if (this.phpModule.getTestDirectories().isEmpty()) {
            return HudsonSCM.ConfigurationStatus.withError((String)Bundle.HudsonJobCreator_error_noTests());
        }
        if (this.scm == null) {
            return ProjectHudsonJobCreatorFactory.Helper.noSCMError();
        }
        if (HudsonOptionsValidator.validate(this.getDefaultBuildXml(), this.getDefaultJobConfig(), this.getDefaultPhpUnitConfig()) != null) {
            return HudsonSCM.ConfigurationStatus.withError((String)Bundle.HudsonJobCreator_error_invalidHudsonOptions()).withExtraButton(this.getOpenHudsonOptionsButton());
        }
        HudsonSCM.ConfigurationStatus scmStatus = this.scm.problems();
        if (scmStatus != null) {
            return scmStatus;
        }
        return HudsonSCM.ConfigurationStatus.valid();
    }

    public void addChangeListener(ChangeListener listener) {
        this.changeSupport.addChangeListener(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.changeSupport.removeChangeListener(listener);
    }

    public Document configure() throws IOException {
        try {
            this.createBuildXml();
            this.createPhpUnitConfig();
        }
        catch (IOException ex) {
            throw new ProjectHudsonJobCreatorFactory.ProjectHudsonJobCreator.SilentIOException((Throwable)ex);
        }
        return this.createJobXml();
    }

    @CheckForNull
    private String getDefaultBuildXml() {
        return HudsonOptions.getInstance().getBuildXml();
    }

    @CheckForNull
    private String getDefaultJobConfig() {
        return HudsonOptions.getInstance().getJobConfig();
    }

    @CheckForNull
    private String getDefaultPhpUnitConfig() {
        return HudsonOptions.getInstance().getPhpUnitConfig();
    }

    @CheckForNull
    private FileObject getProjectBuildXml() {
        return this.phpModule.getProjectDirectory().getFileObject("build.xml");
    }

    @CheckForNull
    private FileObject getProjectPhpUnitConfig() {
        FileObject projectDirectory = this.phpModule.getProjectDirectory();
        FileObject phpUnitConfig = projectDirectory.getFileObject("phpunit.xml");
        if (phpUnitConfig != null) {
            return phpUnitConfig;
        }
        return projectDirectory.getFileObject("phpunit.xml.dist");
    }

    private JButton getOpenHudsonOptionsButton() {
        JButton button = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)button, (String)Bundle.HudsonJobCreator_button_labelWithMnemonics());
        button.getAccessibleContext().setAccessibleDescription(Bundle.HudsonJobCreator_button_a11y());
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UiUtils.showOptions((String)"Hudson");
            }
        });
        return button;
    }

    private Document createJobXml() throws IOException {
        Document document;
        try {
            String defaultJobConfig = this.getDefaultJobConfig();
            assert (defaultJobConfig != null);
            document = XmlUtils.parse(new File(defaultJobConfig));
        }
        catch (SAXException ex) {
            throw new IOException(ex);
        }
        this.removeNodes(document, "/project/scm", "/project/logRotator");
        this.scm.configure(document);
        ProjectHudsonJobCreatorFactory.Helper.addLogRotator((Document)document);
        Node disabled = XmlUtils.query(document, "/project/disabled");
        if (disabled != null) {
            XmlUtils.setNodeValue(document, disabled, "false");
        }
        return document;
    }

    private void removeNodes(Document document, String ... xpathExpressions) {
        for (String xpathExpression : xpathExpressions) {
            Node node = XmlUtils.query(document, xpathExpression);
            if (node == null) continue;
            node.getParentNode().removeChild(node);
        }
    }

    private void createBuildXml() throws IOException {
        FileObject buildXml = this.getProjectBuildXml();
        if (buildXml != null) {
            this.informUser(Bundle.HudsonJobCreator_buildXml_exist(), 1);
            return;
        }
        Path projectBuildXml = new File(FileUtil.toFile((FileObject)this.phpModule.getProjectDirectory()), "build.xml").toPath();
        Files.copy(Paths.get(this.getDefaultBuildXml(), new String[0]), projectBuildXml, new CopyOption[0]);
        BuildXmlUtils.processBuildXml(this.phpModule, projectBuildXml);
    }

    private void createPhpUnitConfig() throws IOException {
        FileObject phpUnitConfig = this.getProjectPhpUnitConfig();
        if (phpUnitConfig != null) {
            this.informUser(Bundle.HudsonJobCreator_phpUnitConfig_exist(), 1);
            return;
        }
        Path projectPhpUnitConfig = new File(FileUtil.toFile((FileObject)this.phpModule.getProjectDirectory()), "phpunit.xml.dist").toPath();
        Files.copy(Paths.get(this.getDefaultPhpUnitConfig(), new String[0]), projectPhpUnitConfig, new CopyOption[0]);
        PhpUnitUtils.processPhpUnitConfig(this.phpModule, projectPhpUnitConfig);
    }

    private void informUser(String message, int messageType) {
        NotifyDescriptor.Message descriptor = new NotifyDescriptor.Message((Object)message, messageType);
        DialogDisplayer.getDefault().notify((NotifyDescriptor)descriptor);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.changeSupport.fireChange();
    }

    public static class Factory
    implements ProjectHudsonJobCreatorFactory {
        public ProjectHudsonJobCreatorFactory.ProjectHudsonJobCreator forProject(Project project) {
            PhpModule phpModule = (PhpModule)project.getLookup().lookup(PhpModule.class);
            if (phpModule == null) {
                return null;
            }
            return HudsonJobCreator.forPhpModule(phpModule);
        }
    }
}

