/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ddloaders.web.multiview;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.j2ee.dd.api.web.WebApp;
import org.netbeans.modules.j2ee.dd.api.web.WelcomeFileList;
import org.netbeans.modules.j2ee.ddloaders.web.DDDataObject;
import org.netbeans.modules.j2ee.ddloaders.web.multiview.BrowseFolders;
import org.netbeans.modules.j2ee.ddloaders.web.multiview.DDUtils;
import org.netbeans.modules.xml.multiview.cookies.LinkCookie;
import org.netbeans.modules.xml.multiview.ui.LinkButton;
import org.netbeans.modules.xml.multiview.ui.SectionInnerPanel;
import org.netbeans.modules.xml.multiview.ui.SectionView;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public class WelcomeFilesPanel
extends SectionInnerPanel {
    DDDataObject dObj;
    private JButton browseButton;
    private JPanel filler;
    private JLabel wfDescription;
    private JLabel wfLabel;
    private JTextField wfTF;

    public WelcomeFilesPanel(SectionView sectionView, DDDataObject dObj) {
        super(sectionView);
        this.dObj = dObj;
        this.initComponents();
        this.addModifier(this.wfTF);
        this.getWelcomeFiles();
        LinkButton linkButton = new LinkButton((LinkCookie)this, null, null);
        Mnemonics.setLocalizedText((AbstractButton)linkButton, (String)NbBundle.getMessage(WelcomeFilesPanel.class, (String)"LBL_goToSources"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.add((Component)linkButton, gridBagConstraints);
    }

    public JComponent getErrorComponent(String errorId) {
        return this.wfTF;
    }

    protected void startUIChange() {
        this.dObj.setChangedFromUI(true);
    }

    protected void endUIChange() {
        this.dObj.modelUpdatedFromUI();
        this.dObj.setChangedFromUI(false);
    }

    public void setValue(JComponent source, Object value) {
        WebApp webApp = this.dObj.getWebApp();
        String text = (String)value;
        this.setWelcomeFiles(webApp, text);
    }

    private void setWelcomeFiles(WebApp webApp, String text) {
        if (text.length() == 0) {
            webApp.setWelcomeFileList(null);
        } else {
            ArrayList<String> wfList = new ArrayList<String>();
            StringTokenizer tok = new StringTokenizer(text, ",");
            while (tok.hasMoreTokens()) {
                String wf = tok.nextToken().trim();
                if (wf.length() <= 0 || wfList.contains(wf)) continue;
                wfList.add(wf);
            }
            if (wfList.size() == 0) {
                try {
                    WelcomeFileList welcomeFileList = (WelcomeFileList)webApp.createBean("WelcomeFileList");
                    webApp.setWelcomeFileList(welcomeFileList);
                }
                catch (ClassNotFoundException welcomeFileList) {}
            } else {
                String[] welcomeFiles = new String[wfList.size()];
                wfList.toArray(welcomeFiles);
                WelcomeFileList welcomeFileList = webApp.getSingleWelcomeFileList();
                if (welcomeFileList == null) {
                    try {
                        welcomeFileList = (WelcomeFileList)webApp.createBean("WelcomeFileList");
                        welcomeFileList.setWelcomeFile(welcomeFiles);
                        webApp.setWelcomeFileList(welcomeFileList);
                    }
                    catch (ClassNotFoundException classNotFoundException) {}
                } else {
                    welcomeFileList.setWelcomeFile(welcomeFiles);
                }
            }
        }
    }

    public void linkButtonPressed(Object obj, String id) {
        StringTokenizer tok = new StringTokenizer(this.wfTF.getText(), ",");
        DDUtils.openEditorForFiles(this.dObj, tok);
    }

    private void getWelcomeFiles() {
        WebApp webApp = this.dObj.getWebApp();
        WelcomeFileList wfList = webApp.getSingleWelcomeFileList();
        if (wfList == null) {
            this.wfTF.setText("");
            return;
        }
        String[] welcomeFiles = wfList.getWelcomeFile();
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < welcomeFiles.length; ++i) {
            if (i > 0) {
                buf.append(", ");
            }
            buf.append(welcomeFiles[i].trim());
        }
        this.wfTF.setText(buf.toString());
    }

    private void initComponents() {
        this.wfLabel = new JLabel();
        this.wfTF = new JTextField();
        this.browseButton = new JButton();
        this.wfDescription = new JLabel();
        this.filler = new JPanel();
        this.setLayout(new GridBagLayout());
        this.wfLabel.setLabelFor(this.wfTF);
        Mnemonics.setLocalizedText((JLabel)this.wfLabel, (String)NbBundle.getMessage(WelcomeFilesPanel.class, (String)"LBL_welcomeFiles"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(5, 10, 0, 6);
        this.add(this.wfLabel, gridBagConstraints);
        this.wfTF.setColumns(50);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.add(this.wfTF, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.browseButton, (String)NbBundle.getMessage(WelcomeFilesPanel.class, (String)"LBL_browse"));
        this.browseButton.setMargin(new Insets(0, 14, 0, 14));
        this.browseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WelcomeFilesPanel.this.browseButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(3, 6, 0, 0);
        this.add(this.browseButton, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.wfDescription, (String)NbBundle.getMessage(WelcomeFilesPanel.class, (String)"DESC_welcomeFiles"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.add(this.wfDescription, gridBagConstraints);
        this.filler.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.add(this.filler, gridBagConstraints);
    }

    private void browseButtonActionPerformed(ActionEvent evt) {
        try {
            SourceGroup[] groups = DDUtils.getDocBaseGroups(this.dObj);
            FileObject fo = BrowseFolders.showDialog(groups);
            if (fo != null) {
                String newWF;
                String fileName = DDUtils.getResourcePath(groups, fo, '/', true);
                String oldWF = this.wfTF.getText();
                if (fileName.length() > 0 && !oldWF.equals(newWF = DDUtils.addItem(oldWF, fileName, true))) {
                    this.wfTF.setText(newWF);
                    this.dObj.modelUpdatedFromUI();
                    this.dObj.setChangedFromUI(true);
                    this.setWelcomeFiles(this.dObj.getWebApp(), newWF);
                    this.dObj.setChangedFromUI(false);
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

