/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.refactoring.findusages.model;

import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.expr.ArgumentListExpression;
import org.codehaus.groovy.ast.expr.ConstructorCallExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.netbeans.modules.groovy.editor.api.ElementUtils;

public class MethodSignatureBuilder {
    private StringBuilder builder = new StringBuilder();

    public MethodSignatureBuilder appendMethodName(MethodNode method) {
        if (this.isConstructor(method)) {
            this.builder.append(method.getDeclaringClass().getNameWithoutPackage());
        } else {
            this.builder.append(method.getName());
        }
        return this;
    }

    private boolean isConstructor(MethodNode method) {
        return "<init>".equals(method.getName());
    }

    public MethodSignatureBuilder appendMethodName(MethodCallExpression methodCall) {
        this.builder.append(methodCall.getMethodAsString());
        return this;
    }

    public MethodSignatureBuilder appendMethodName(ConstructorCallExpression constructorCall) {
        this.builder.append(constructorCall.getType().getNameWithoutPackage());
        return this;
    }

    public MethodSignatureBuilder appendMethodParams(MethodNode method) {
        Parameter[] params = method.getParameters();
        this.builder.append("(");
        if (params.length > 0) {
            for (Parameter param : params) {
                this.builder.append(ElementUtils.getType((ASTNode)param.getType()).getNameWithoutPackage());
                this.builder.append(" ");
                this.builder.append(param.getName());
                this.builder.append(",");
            }
            this.builder.setLength(this.builder.length() - 1);
        }
        this.builder.append(")");
        return this;
    }

    public MethodSignatureBuilder appendMethodParams(Expression arguments) {
        ArgumentListExpression argumentList;
        this.builder.append("(");
        if (arguments instanceof ArgumentListExpression && (argumentList = (ArgumentListExpression)arguments).getExpressions().size() > 0) {
            for (Expression argument : argumentList.getExpressions()) {
                this.builder.append(ElementUtils.getTypeNameWithoutPackage((ASTNode)argument.getType()));
                this.builder.append(" ");
                this.builder.append(argument.getText());
                this.builder.append(",");
            }
            this.builder.setLength(this.builder.length() - 1);
        }
        this.builder.append(")");
        return this;
    }

    public MethodSignatureBuilder appendReturnType(MethodNode method) {
        this.builder.append(" : ");
        this.builder.append(method.getReturnType().getNameWithoutPackage());
        return this;
    }

    public MethodSignatureBuilder appendReturnType(MethodCallExpression methodCall) {
        this.builder.append(" : ");
        MethodNode methodTarget = methodCall.getMethodTarget();
        if (methodTarget != null && methodTarget.getReturnType() != null) {
            this.builder.append(methodTarget.getReturnType().getNameWithoutPackage());
        } else {
            this.builder.append("Object");
        }
        return this;
    }

    public String toString() {
        return this.builder.toString();
    }
}

