/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.composer.ui;

import java.awt.Image;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.modules.php.api.phpmodule.PhpModule;
import org.netbeans.modules.php.composer.files.ComposerJson;
import org.netbeans.modules.php.composer.files.ComposerLock;
import org.netbeans.modules.php.composer.ui.Bundle;
import org.netbeans.modules.php.composer.util.ComposerUtils;
import org.netbeans.spi.project.ui.support.NodeFactory;
import org.netbeans.spi.project.ui.support.NodeList;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.ChangeSupport;
import org.openide.util.ImageUtilities;
import org.openide.util.WeakListeners;

public final class ComposerLibraries {
    static final Logger LOGGER = Logger.getLogger(ComposerLibraries.class.getName());

    private ComposerLibraries() {
    }

    public static NodeFactory forPhpProject() {
        return new ComposerLibrariesNodeFactory();
    }

    private static final class ComposerLibrariesNodeFactory
    implements NodeFactory {
        private ComposerLibrariesNodeFactory() {
        }

        public NodeList<?> createNodes(Project project) {
            assert (project != null);
            return new ComposerLibrariesNodeList(project);
        }
    }

    private static final class ComposerLibraryInfo
    implements Comparable<ComposerLibraryInfo> {
        final Image icon;
        final String name;
        final String description;

        ComposerLibraryInfo(Image icon, String name, String descrition) {
            assert (icon != null);
            assert (name != null);
            assert (descrition != null);
            this.icon = icon;
            this.name = name;
            this.description = descrition;
        }

        @Override
        public int compareTo(ComposerLibraryInfo other) {
            return this.name.compareToIgnoreCase(other.name);
        }

        public int hashCode() {
            int hash = 7;
            hash = 97 * hash + Objects.hashCode(this.name);
            return hash;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ComposerLibraryInfo other = (ComposerLibraryInfo)obj;
            return this.name.equalsIgnoreCase(other.name);
        }
    }

    private static final class NpmLibraryNode
    extends AbstractNode {
        private final ComposerLibraryInfo libraryInfo;

        NpmLibraryNode(ComposerLibraryInfo libraryInfo) {
            super(Children.LEAF);
            this.libraryInfo = libraryInfo;
        }

        public String getName() {
            return this.libraryInfo.name;
        }

        public String getShortDescription() {
            return this.libraryInfo.description;
        }

        public Image getIcon(int type) {
            return this.libraryInfo.icon;
        }

        public Image getOpenedIcon(int type) {
            return this.libraryInfo.icon;
        }

        public Action[] getActions(boolean context) {
            return new Action[0];
        }
    }

    private static final class ComposerLibrariesChildren
    extends Children.Keys<ComposerLibraryInfo> {
        private static final String LIBRARIES_ICON = "org/netbeans/modules/php/composer/ui/resources/libraries.gif";
        private static final String DEV_BADGE = "org/netbeans/modules/php/composer/ui/resources/libraries-dev-badge.gif";
        private final ComposerJson composerJson;
        private final ComposerLock composerLock;
        private final Map<String, Image> icons = new HashMap<String, Image>();

        public ComposerLibrariesChildren(ComposerJson composerJson, ComposerLock composerLock) {
            super(true);
            assert (composerJson != null);
            assert (composerLock != null);
            this.composerJson = composerJson;
            this.composerLock = composerLock;
        }

        public boolean hasDependencies() {
            return !this.composerJson.getDependencies().isEmpty();
        }

        public void refreshDependencies() {
            this.setKeys();
        }

        protected Node[] createNodes(ComposerLibraryInfo key) {
            return new Node[]{new NpmLibraryNode(key)};
        }

        protected void addNotify() {
            this.setKeys();
        }

        protected void removeNotify() {
            this.setKeys(Collections.emptyList());
        }

        private void setKeys() {
            ComposerJson.ComposerDependencies dependencies = this.composerJson.getDependencies();
            if (dependencies.isEmpty()) {
                this.setKeys(Collections.emptyList());
                return;
            }
            ComposerLock.ComposerPackages packages = this.composerLock.getPackages();
            ArrayList<ComposerLibraryInfo> keys = new ArrayList<ComposerLibraryInfo>(dependencies.getCount());
            keys.addAll(this.getKeys(dependencies.dependencies, packages.packages, null, null));
            keys.addAll(this.getKeys(dependencies.devDependencies, packages.packagesDev, DEV_BADGE, Bundle.ComposerLibrariesChildren_library_dev()));
            this.setKeys(keys);
        }

        private List<ComposerLibraryInfo> getKeys(Map<String, String> dependencies, Map<String, String> packages, String badge, String libraryType) {
            if (dependencies.isEmpty()) {
                return Collections.emptyList();
            }
            ArrayList<ComposerLibraryInfo> keys = new ArrayList<ComposerLibraryInfo>(dependencies.size());
            for (Map.Entry<String, String> entry : dependencies.entrySet()) {
                String name = entry.getKey();
                String version = entry.getValue();
                String installedVersion = packages.get(name);
                if (installedVersion == null) {
                    installedVersion = Bundle.ComposerLibrariesChildren_na();
                }
                String description = Objects.equals(version, installedVersion) ? Bundle.ComposerLibrariesChildren_description_version(name, version) : Bundle.ComposerLibrariesChildren_description_versions(name, version, installedVersion);
                if (libraryType != null) {
                    description = Bundle.ComposerLibrariesChildren_description_type(description, libraryType);
                }
                keys.add(new ComposerLibraryInfo(this.geIcon(badge), name, description));
            }
            Collections.sort(keys);
            return keys;
        }

        private Image geIcon(String badge) {
            Image icon = this.icons.get(badge);
            if (icon == null) {
                icon = ImageUtilities.loadImage((String)LIBRARIES_ICON);
                if (badge != null) {
                    icon = ImageUtilities.mergeImages((Image)icon, (Image)ImageUtilities.loadImage((String)badge), (int)8, (int)8);
                }
                this.icons.put(badge, icon);
            }
            return icon;
        }
    }

    private static final class ComposerLibrariesNode
    extends AbstractNode {
        private static final String LIBRARIES_BADGE = "org/netbeans/modules/php/composer/ui/resources/libraries-badge.png";
        private final Node iconDelegate = DataFolder.findFolder((FileObject)FileUtil.getConfigRoot()).getNodeDelegate();

        ComposerLibrariesNode(ComposerLibrariesChildren npmLibrariesChildren) {
            super((Children)npmLibrariesChildren);
        }

        public String getDisplayName() {
            return Bundle.ComposerLibrariesNode_name();
        }

        public Image getIcon(int type) {
            return ImageUtilities.mergeImages((Image)this.iconDelegate.getIcon(type), (Image)ImageUtilities.loadImage((String)LIBRARIES_BADGE), (int)7, (int)7);
        }

        public Image getOpenedIcon(int type) {
            return this.getIcon(type);
        }

        public Action[] getActions(boolean context) {
            return new Action[0];
        }
    }

    private static final class ComposerLibrariesNodeList
    implements NodeList<Node>,
    PropertyChangeListener {
        private final ComposerJson composerJson;
        private final ComposerLock composerLock;
        private final ComposerLibrariesChildren composerLibrariesChildren;
        private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
        private Node composerLibrariesNode;

        ComposerLibrariesNodeList(Project project) {
            assert (project != null);
            PhpModule phpModule = PhpModule.Factory.lookupPhpModule((Project)project);
            assert (phpModule != null) : "PHP module must be found in " + project.getClass().getName();
            FileObject composerDirectory = ComposerUtils.getComposerWorkDir(phpModule);
            this.composerJson = new ComposerJson(composerDirectory);
            this.composerLock = new ComposerLock(composerDirectory);
            this.composerLibrariesChildren = new ComposerLibrariesChildren(this.composerJson, this.composerLock);
        }

        public List<Node> keys() {
            if (!this.composerLibrariesChildren.hasDependencies()) {
                return Collections.emptyList();
            }
            if (this.composerLibrariesNode == null) {
                this.composerLibrariesNode = new ComposerLibrariesNode(this.composerLibrariesChildren);
            }
            return Collections.singletonList(this.composerLibrariesNode);
        }

        public void addChangeListener(ChangeListener listener) {
            this.changeSupport.addChangeListener(listener);
        }

        public void removeChangeListener(ChangeListener listener) {
            this.changeSupport.removeChangeListener(listener);
        }

        public Node node(Node key) {
            return key;
        }

        public void addNotify() {
            this.composerJson.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)this.composerJson));
            this.composerLock.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)this.composerLock));
        }

        public void removeNotify() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            String propertyName = evt.getPropertyName();
            if ("REQUIRE".equals(propertyName) || "REQUIRE_DEV".equals(propertyName) || "PACKAGES".equals(propertyName) || "PACKAGES_DEV".equals(propertyName)) {
                this.fireChange();
            }
        }

        private void fireChange() {
            this.composerLibrariesChildren.refreshDependencies();
            this.changeSupport.fireChange();
        }
    }
}

