/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.errors;

import com.sun.source.util.TreePath;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.modules.java.hints.spi.ErrorRule;
import org.netbeans.modules.java.hints.spi.support.FixFactory;
import org.netbeans.spi.editor.hints.Fix;
import org.openide.util.NbBundle;

public class SuppressWarningsFixer
implements ErrorRule<Void> {
    private static final Map<String, String> KEY2SUPRESS_KEY;

    public Set<String> getCodes() {
        return KEY2SUPRESS_KEY.keySet();
    }

    public List<Fix> run(CompilationInfo compilationInfo, String diagnosticKey, int offset, TreePath treePath, ErrorRule.Data<Void> data) {
        String suppressKey = KEY2SUPRESS_KEY.get(diagnosticKey);
        if (suppressKey != null) {
            return FixFactory.createSuppressWarnings((CompilationInfo)compilationInfo, (TreePath)treePath, (String[])new String[]{suppressKey});
        }
        return Collections.emptyList();
    }

    public void cancel() {
    }

    public String getId() {
        return "SuppressWarningsFixer";
    }

    public String getDisplayName() {
        return NbBundle.getMessage(SuppressWarningsFixer.class, (String)"LBL_Suppress_Waning");
    }

    public String getDescription() {
        return NbBundle.getMessage(SuppressWarningsFixer.class, (String)"LBL_Suppress_Waning");
    }

    static {
        HashMap<String, String> map = new HashMap<String, String>();
        String uncheckedKey = "unchecked";
        map.put("compiler.warn.prob.found.req", uncheckedKey);
        map.put("compiler.warn.unchecked.cast.to.type", uncheckedKey);
        map.put("compiler.warn.unchecked.assign", uncheckedKey);
        map.put("compiler.warn.unchecked.assign.to.var", uncheckedKey);
        map.put("compiler.warn.unchecked.call.mbr.of.raw.type", uncheckedKey);
        map.put("compiler.warn.unchecked.meth.invocation.applied", uncheckedKey);
        map.put("compiler.warn.unchecked.generic.array.creation", uncheckedKey);
        String fallThroughKey = "fallthrough";
        map.put("compiler.warn.possible.fall-through.into.case", fallThroughKey);
        String deprecationKey = "deprecation";
        map.put("compiler.warn.has.been.deprecated", deprecationKey);
        KEY2SUPRESS_KEY = Collections.unmodifiableMap(map);
    }
}

