/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.errors;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Scope;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.GeneratorUtilities;
import org.netbeans.api.java.source.TreeUtilities;
import org.netbeans.api.java.source.TypeUtilities;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.lib.editor.util.StringEscapeUtils;
import org.netbeans.modules.java.hints.spi.ErrorRule;
import org.netbeans.spi.editor.hints.Fix;
import org.netbeans.spi.java.hints.JavaFix;
import org.openide.util.NbBundle;

public class AddConstructor
implements ErrorRule<Void> {
    private static final Set<String> ERROR_CODES = new HashSet<String>(Arrays.asList("compiler.err.cant.apply.symbol", "compiler.err.cant.apply.symbols"));

    public Set<String> getCodes() {
        return ERROR_CODES;
    }

    public List<Fix> run(CompilationInfo info, String diagnosticKey, int offset, TreePath treePath, ErrorRule.Data<Void> data) {
        if (!TreeUtilities.CLASS_TREE_KINDS.contains((Object)treePath.getLeaf().getKind())) {
            return Collections.emptyList();
        }
        Element el = info.getTrees().getElement(treePath);
        if (el == null || !el.getKind().isClass()) {
            return Collections.emptyList();
        }
        TypeElement clazz = (TypeElement)el;
        TypeMirror superType = clazz.getSuperclass();
        if (superType.getKind() != TypeKind.DECLARED) {
            return Collections.emptyList();
        }
        TypeElement superClazz = (TypeElement)info.getTypes().asElement(superType);
        DeclaredType targetType = (DeclaredType)clazz.asType();
        Scope classScope = info.getTrees().getScope(treePath);
        ArrayList<Fix> result = new ArrayList<Fix>();
        for (ExecutableElement constr : ElementFilter.constructorsIn(superClazz.getEnclosedElements())) {
            if (!info.getTrees().isAccessible(classScope, constr, (DeclaredType)superType)) continue;
            StringBuilder name = new StringBuilder();
            name.append(clazz.getSimpleName()).append("(");
            ExecutableType target = (ExecutableType)info.getTypes().asMemberOf(targetType, constr);
            boolean firstParam = true;
            for (TypeMirror typeMirror : target.getParameterTypes()) {
                if (!firstParam) {
                    name.append(", ");
                }
                firstParam = false;
                name.append(info.getTypeUtilities().getTypeName(typeMirror, new TypeUtilities.TypeNameOptions[0]));
            }
            name.append(")");
            result.add(new FixImpl(info, treePath, constr, StringEscapeUtils.escapeHtml((String)name.toString())).toEditorFix());
        }
        return result;
    }

    public String getId() {
        return AddConstructor.class.getName();
    }

    public String getDisplayName() {
        return NbBundle.getMessage(AddConstructor.class, (String)"DN_AddConstructor");
    }

    public void cancel() {
    }

    private static final class FixImpl
    extends JavaFix {
        private final ElementHandle<ExecutableElement> constr;
        private final String constrName;

        public FixImpl(CompilationInfo info, TreePath tp, ExecutableElement constr, String constrName) {
            super(info, tp);
            this.constr = ElementHandle.create((Element)constr);
            this.constrName = constrName;
        }

        protected String getText() {
            return NbBundle.getMessage(AddConstructor.class, (String)"FIX_AddConstructor", (Object)this.constrName);
        }

        protected void performRewrite(JavaFix.TransformationContext ctx) throws Exception {
            TypeElement clazz = (TypeElement)ctx.getWorkingCopy().getTrees().getElement(ctx.getPath());
            if (clazz == null) {
                return;
            }
            GeneratorUtilities gu = GeneratorUtilities.get((WorkingCopy)ctx.getWorkingCopy());
            MethodTree newConstr = gu.createConstructor(clazz, Collections.emptyList(), (ExecutableElement)this.constr.resolve((CompilationInfo)ctx.getWorkingCopy()));
            ctx.getWorkingCopy().rewrite(ctx.getPath().getLeaf(), (Tree)gu.insertClassMember((ClassTree)ctx.getPath().getLeaf(), (Tree)newConstr));
        }
    }
}

