/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.bugs;

import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.modules.java.hints.bugs.Bundle;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.Fix;
import org.netbeans.spi.java.hints.ErrorDescriptionFactory;
import org.netbeans.spi.java.hints.HintContext;

public class ConfusingVarargsParameter {
    private static final String[] EXCLUDE_CLASSES = new String[]{"java.text.MessageFormat", "java.io.PrintStream", "java.io.PrintWriter", "java.lang.String"};

    private static boolean isVarargsParameter(CompilationInfo ci, TreePath invPath) {
        if (invPath.getLeaf().getKind() != Tree.Kind.METHOD_INVOCATION) {
            return false;
        }
        MethodInvocationTree mit = (MethodInvocationTree)invPath.getLeaf();
        Element e = ci.getTrees().getElement(invPath);
        if (e == null || e.getKind() != ElementKind.METHOD) {
            return false;
        }
        ExecutableElement ee = (ExecutableElement)e;
        return ee.isVarArgs() && mit.getArguments().size() == ee.getParameters().size();
    }

    public static ErrorDescription primitiveArray(HintContext ctx) {
        TreePath invPath = ctx.getPath();
        CompilationInfo ci = ctx.getInfo();
        if (!ConfusingVarargsParameter.isVarargsParameter(ci, invPath)) {
            return null;
        }
        MethodInvocationTree mit = (MethodInvocationTree)invPath.getLeaf();
        ExpressionTree arg = mit.getArguments().get(mit.getArguments().size() - 1);
        if (arg.getKind() == Tree.Kind.NULL_LITERAL) {
            return null;
        }
        Element e = ci.getTrees().getElement(invPath);
        if (e != null) {
            TypeMirror tm;
            VariableElement var;
            TypeKind tk;
            if ((e.getKind() == ElementKind.CONSTRUCTOR || e.getKind() == ElementKind.METHOD) && (tk = (var = ((ExecutableElement)e).getParameters().get(mit.getArguments().size() - 1)).asType().getKind()) == TypeKind.ARRAY && (tm = ((ArrayType)var.asType()).getComponentType()).getKind().isPrimitive()) {
                return null;
            }
            Element ecl = e.getEnclosingElement();
            if (ecl != null && (ecl.getKind().isClass() || ecl.getKind().isInterface())) {
                TypeElement te = (TypeElement)ecl;
                String qn = te.getQualifiedName().toString();
                for (String s : EXCLUDE_CLASSES) {
                    if (!s.equals(qn)) continue;
                    return null;
                }
            }
        }
        return ErrorDescriptionFactory.forTree((HintContext)ctx, (Tree)mit.getArguments().get(mit.getArguments().size() - 1), (String)Bundle.TEXT_ConfusingPrimitveArrayToVararg(), (Fix[])new Fix[0]);
    }
}

