/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.bugs;

import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.prefs.Preferences;
import javax.lang.model.element.TypeElement;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.modules.java.hints.ui.ClassNameList;
import org.netbeans.modules.java.hints.ui.InnerPanelSupport;
import org.netbeans.modules.java.hints.ui.TypeAcceptor;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class BroadCatchCustomizer
extends JPanel
implements ActionListener,
ChangeListener {
    private Preferences prefs;
    private ClassNameList listClasses;
    private JCheckBox cbCommonTypes;
    private JCheckBox cbSuppressUmbrellas;
    private JPanel classHolder;

    public BroadCatchCustomizer(Preferences prefs) {
        this.prefs = prefs;
        this.initComponents();
        this.listClasses = new ClassNameList().restrictTypes(new TypeAcceptor<ElementHandle<TypeElement>, CompilationController>(){

            @Override
            public boolean accept(ElementHandle<TypeElement> item, CompilationController c) {
                TypeElement el = (TypeElement)item.resolve((CompilationInfo)c);
                TypeElement thr = c.getElements().getTypeElement("java.lang.Throwable");
                return c.getTypes().isSubtype(el.asType(), thr.asType());
            }
        });
        this.listClasses.addChangeListener(this);
        this.classHolder.add(this.listClasses);
        this.cbCommonTypes.addActionListener(this);
        this.cbSuppressUmbrellas.addActionListener(this);
        this.initList(prefs.get("catch.umbrella.types", "java.io.IOException, java.sql.SqlException"));
        this.cbSuppressUmbrellas.setSelected(prefs.getBoolean("catch.umbrella", false));
        this.cbCommonTypes.setSelected(!prefs.getBoolean("catch.common", true));
        this.enableUmbrella();
        prefs.putBoolean("catch.umbrella", this.cbSuppressUmbrellas.isSelected());
        prefs.putBoolean("catch.common", !this.cbCommonTypes.isSelected());
    }

    private void initList(String val) {
        this.listClasses.setClassNames(val);
        this.prefs.put("catch.umbrella.types", val);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.prefs.put("catch.umbrella.types", this.listClasses.getClassNameList());
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        Object src = ae.getSource();
        if (src == this.cbCommonTypes) {
            this.prefs.putBoolean("catch.common", !this.cbCommonTypes.isSelected());
        } else if (src == this.cbSuppressUmbrellas) {
            this.prefs.putBoolean("catch.umbrella", this.cbSuppressUmbrellas.isSelected());
            this.enableUmbrella();
        }
    }

    private void enableUmbrella() {
        boolean enable = this.cbSuppressUmbrellas.isEnabled() && this.cbSuppressUmbrellas.isSelected();
        InnerPanelSupport.enablePanel(this.classHolder, enable);
    }

    private void initComponents() {
        this.cbCommonTypes = new JCheckBox();
        this.cbSuppressUmbrellas = new JCheckBox();
        this.classHolder = new JPanel();
        this.setPreferredSize(new Dimension(360, 169));
        Mnemonics.setLocalizedText((AbstractButton)this.cbCommonTypes, (String)NbBundle.getMessage(BroadCatchCustomizer.class, (String)"BroadCatchCustomizer.cbCommonTypes.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.cbSuppressUmbrellas, (String)NbBundle.getMessage(BroadCatchCustomizer.class, (String)"BroadCatchCustomizer.cbSuppressUmbrellas.text"));
        this.classHolder.setLayout(new GridLayout());
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.cbSuppressUmbrellas).addComponent(this.cbCommonTypes)).addContainerGap(140, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addGap(21, 21, 21).addComponent(this.classHolder, -1, -1, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.cbCommonTypes).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cbSuppressUmbrellas).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.classHolder, -1, -1, Short.MAX_VALUE).addContainerGap()));
    }
}

