/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.analyzer.ui;

import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Collection;
import javax.swing.InputMap;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.tree.TreePath;
import org.netbeans.modules.java.hints.analyzer.ui.CheckRenderer;
import org.netbeans.modules.java.hints.analyzer.ui.FixDescription;
import org.openide.explorer.view.BeanTreeView;
import org.openide.explorer.view.NodeTreeModel;
import org.openide.explorer.view.Visualizer;
import org.openide.nodes.Node;

public class CheckTreeView
extends BeanTreeView {
    private NodeTreeModel nodeTreeModel;

    public CheckTreeView() {
        this.setFocusable(false);
        CheckListener l = new CheckListener();
        this.tree.addMouseListener(l);
        this.tree.addKeyListener(l);
        CheckRenderer check = new CheckRenderer();
        this.tree.setCellRenderer(check);
        this.tree.getSelectionModel().setSelectionMode(1);
        this.tree.setShowsRootHandles(false);
        InputMap input = this.tree.getInputMap(0);
        if (null != input) {
            input.remove(KeyStroke.getKeyStroke(10, 0));
        }
        this.setBorder(UIManager.getBorder("ScrollPane.border"));
    }

    protected NodeTreeModel createModel() {
        this.nodeTreeModel = super.createModel();
        return this.nodeTreeModel;
    }

    public void expandRow(int row) {
        this.tree.expandRow(row);
    }

    public boolean getScrollsOnExpand() {
        return this.tree.getScrollsOnExpand();
    }

    public void setScrollsOnExpand(boolean scrolls) {
        this.tree.setScrollsOnExpand(scrolls);
    }

    protected void showPath(TreePath path) {
        this.tree.expandPath(path);
        this.showPathWithoutExpansion(path);
    }

    protected void showSelection(TreePath[] treePaths) {
        this.tree.getSelectionModel().setSelectionPaths(treePaths);
        if (treePaths.length == 1) {
            this.showPathWithoutExpansion(treePaths[0]);
        }
    }

    private void showPathWithoutExpansion(TreePath path) {
        Rectangle rect = this.tree.getPathBounds(path);
        if (rect != null && this.getWidth() > 0 && this.getHeight() > 0) {
            this.tree.scrollRectToVisible(rect);
        }
    }

    class CheckListener
    implements MouseListener,
    KeyListener {
        CheckListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (!e.isPopupTrigger()) {
                TreePath path = CheckTreeView.this.tree.getPathForLocation(e.getPoint().x, e.getPoint().y);
                Rectangle r = CheckTreeView.this.tree.getPathBounds(path);
                if (r != null) {
                    r.width = r.height;
                    if (r.contains(e.getPoint()) && this.toggle(path)) {
                        e.consume();
                        CheckTreeView.this.repaint();
                    }
                }
            }
        }

        @Override
        public void keyTyped(KeyEvent e) {
        }

        @Override
        public void keyReleased(KeyEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            JTree tree;
            TreePath path;
            if (e.getKeyCode() == 32 && e.getSource() instanceof JTree && this.toggle(path = (tree = (JTree)e.getSource()).getSelectionPath())) {
                e.consume();
                CheckTreeView.this.repaint();
            }
        }

        private boolean toggle(TreePath treePath) {
            if (treePath == null) {
                return false;
            }
            Node node = Visualizer.findNode((Object)treePath.getLastPathComponent());
            if (node == null) {
                return false;
            }
            Collection fixes = node.getLookup().lookupAll(FixDescription.class);
            if (!fixes.isEmpty()) {
                CheckRenderer.State s = CheckRenderer.getCheckState(fixes);
                boolean select = s != CheckRenderer.State.SELECTED;
                for (FixDescription fd : fixes) {
                    fd.setSelected(select);
                }
                return true;
            }
            return false;
        }
    }
}

