/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.junit.diff;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import org.netbeans.junit.diff.Diff;
import org.netbeans.junit.diff.LineDiff;

public class SimpleDiff
implements Diff {
    private static final int BUFSIZE = 1024;
    private final LineDiff lineDiff = new LineDiff(false);

    @Override
    public boolean diff(File first, File second, File diff) throws IOException {
        if (this.isBinaryFile(first) || this.isBinaryFile(second)) {
            return this.binaryCompare(first, second, diff);
        }
        return this.textualCompare(first, second, diff);
    }

    @Override
    public boolean diff(String first, String second, String diff) throws IOException {
        File fFirst = new File(first);
        File fSecond = new File(second);
        File fDiff = null != diff ? new File(diff) : null;
        return this.diff(fFirst, fSecond, fDiff);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isBinaryFile(File file) throws IOException {
        byte[] buffer = new byte[1024];
        try (FileInputStream is = new FileInputStream(file);){
            int bytesRead = is.read(buffer, 0, 1024);
            if (bytesRead == -1) {
                boolean bl = false;
                return bl;
            }
            for (int i = 0; i != bytesRead; ++i) {
                if (buffer[i] >= 0) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
    }

    protected boolean binaryCompare(File first, File second, File diff) throws IOException {
        if (first.length() != second.length()) {
            return true;
        }
        BufferedInputStream fs1 = new BufferedInputStream(new FileInputStream(first));
        BufferedInputStream fs2 = new BufferedInputStream(new FileInputStream(second));
        byte[] b1 = new byte[1024];
        byte[] b2 = new byte[1024];
        try {
            while (true) {
                int l1 = ((InputStream)fs1).read(b1);
                int l2 = ((InputStream)fs2).read(b2);
                if (l1 == -1) {
                    boolean bl = l2 != -1;
                    return bl;
                }
                if (l1 != l2) {
                    boolean bl = true;
                    return bl;
                }
                if (Arrays.equals(b1, b2)) continue;
                boolean bl = true;
                return bl;
            }
        }
        finally {
            ((InputStream)fs1).close();
            ((InputStream)fs2).close();
        }
    }

    protected boolean textualCompare(File first, File second, File diff) throws IOException {
        return this.lineDiff.diff(first, second, diff);
    }
}

