/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.common.ui.cssprep;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.LayoutStyle;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.options.OptionsDisplayer;
import org.netbeans.api.project.Project;
import org.netbeans.modules.web.common.ui.api.CssPreprocessorUI;
import org.netbeans.modules.web.common.ui.cssprep.Bundle;
import org.netbeans.modules.web.common.ui.cssprep.CssPreprocessorAccessor;
import org.netbeans.modules.web.common.ui.cssprep.CssPreprocessorsAccessor;
import org.netbeans.modules.web.common.ui.spi.CssPreprocessorUIImplementation;
import org.netbeans.spi.project.ui.support.ProjectCustomizer;
import org.openide.awt.Mnemonics;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.Parameters;

public final class CssPreprocessorsCustomizerPanel
extends JPanel
implements ChangeListener,
HelpCtx.Provider {
    private static final long serialVersionUID = -364546871657687310L;
    private static final Logger LOGGER = Logger.getLogger(CssPreprocessorsCustomizerPanel.class.getName());
    private final ProjectCustomizer.Category category;
    private final Project project;
    private final List<CssPreprocessorUIImplementation.Customizer> customizers = new CopyOnWriteArrayList<CssPreprocessorUIImplementation.Customizer>();
    private final Map<Component, CssPreprocessorUIImplementation.Customizer> componentCustomizers = new ConcurrentHashMap<Component, CssPreprocessorUIImplementation.Customizer>();
    private JButton configureButton;
    private JTabbedPane mainTabbedPane;

    public CssPreprocessorsCustomizerPanel(ProjectCustomizer.Category category, Project project) {
        assert (category != null);
        assert (project != null);
        this.category = category;
        this.project = project;
        this.customizers.addAll(this.getCustomizers());
        this.initComponents();
        this.init();
        this.validateCustomizers();
    }

    private void init() {
        for (CssPreprocessorUIImplementation.Customizer customizer : this.customizers) {
            assert (customizer != null);
            customizer.addChangeListener(this);
            JComponent component = customizer.getComponent();
            this.mainTabbedPane.addTab(customizer.getDisplayName(), component);
            this.componentCustomizers.put(component, customizer);
        }
        if (!this.customizers.isEmpty()) {
            this.mainTabbedPane.setSelectedIndex(0);
        }
        this.category.setStoreListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CssPreprocessorsCustomizerPanel.this.store();
            }
        });
        this.category.setCloseListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CssPreprocessorsCustomizerPanel.this.removeListeners();
            }
        });
    }

    private Collection<CssPreprocessorUIImplementation.Customizer> getCustomizers() {
        List<CssPreprocessorUI> preprocessors = CssPreprocessorsAccessor.getDefault().getPreprocessors();
        ArrayList<CssPreprocessorUIImplementation.Customizer> result = new ArrayList<CssPreprocessorUIImplementation.Customizer>(preprocessors.size());
        for (CssPreprocessorUI cssPreprocessor : preprocessors) {
            CssPreprocessorUIImplementation.Customizer customizer = CssPreprocessorAccessor.getDefault().createCustomizer(cssPreprocessor, this.project);
            if (customizer == null) continue;
            result.add(customizer);
        }
        return result;
    }

    void validateCustomizers() {
        String message = null;
        for (CssPreprocessorUIImplementation.Customizer customizer : this.customizers) {
            if (!customizer.isValid()) {
                String errorMessage = customizer.getErrorMessage();
                Parameters.notNull((CharSequence)"errorMessage", (Object)errorMessage);
                this.category.setErrorMessage(Bundle.CssPreprocessorsCustomizerPanel_message(customizer.getDisplayName(), errorMessage));
                this.category.setValid(false);
                return;
            }
            String warning = customizer.getWarningMessage();
            if (message != null || warning == null) continue;
            message = Bundle.CssPreprocessorsCustomizerPanel_message(customizer.getDisplayName(), warning);
        }
        this.category.setErrorMessage(message != null ? message : " ");
        this.category.setValid(true);
    }

    void store() {
        for (CssPreprocessorUIImplementation.Customizer customizer : this.customizers) {
            assert (customizer.isValid()) : "Saving invalid customizer: " + customizer.getDisplayName() + " (error: " + customizer.getErrorMessage() + ")";
            try {
                customizer.save();
            }
            catch (IOException ex) {
                LOGGER.log(Level.WARNING, "Error while saving CSS preprocessor: " + customizer.getDisplayName(), ex);
            }
        }
    }

    void removeListeners() {
        for (CssPreprocessorUIImplementation.Customizer customizer : this.customizers) {
            customizer.removeChangeListener(this);
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.validateCustomizers();
    }

    private void initComponents() {
        this.configureButton = new JButton();
        this.mainTabbedPane = new JTabbedPane();
        Mnemonics.setLocalizedText((AbstractButton)this.configureButton, (String)NbBundle.getMessage(CssPreprocessorsCustomizerPanel.class, (String)"CssPreprocessorsCustomizerPanel.configureButton.text"));
        this.configureButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CssPreprocessorsCustomizerPanel.this.configureButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.mainTabbedPane, -1, 400, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.configureButton)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.configureButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.mainTabbedPane, -1, 269, Short.MAX_VALUE)));
    }

    private void configureButtonActionPerformed(ActionEvent evt) {
        OptionsDisplayer.getDefault().open("Html5/CssPreprocessors");
    }

    public HelpCtx getHelpCtx() {
        HelpCtx generalHelp = new HelpCtx("org.netbeans.modules.web.common.api.ui.CssPreprocessorsCustomizerPanel");
        Component selectedComponent = this.mainTabbedPane.getSelectedComponent();
        if (selectedComponent == null) {
            return generalHelp;
        }
        CssPreprocessorUIImplementation.Customizer customizer = this.componentCustomizers.get(selectedComponent);
        assert (customizer != null) : "Unknown tab: " + this.mainTabbedPane.getSelectedIndex();
        HelpCtx help = customizer.getHelp();
        if (help != null) {
            return help;
        }
        return generalHelp;
    }
}

