/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript2.editor.formatter;

import java.util.LinkedList;
import java.util.List;
import org.antlr.v4.runtime.ParserRuleContext;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.javascript2.editor.formatter.FormatToken;
import org.netbeans.modules.javascript2.editor.formatter.FormatTokenStream;
import org.netbeans.modules.javascript2.editor.formatter.TokenUtils;
import org.netbeans.modules.javascript2.json.parser.JsonParser;
import org.netbeans.modules.javascript2.json.parser.JsonParserBaseVisitor;
import org.netbeans.modules.javascript2.lexer.api.JsTokenId;

public class JsonFormatVisitor
extends JsonParserBaseVisitor<Void> {
    private final TokenUtils tokenUtils;

    public JsonFormatVisitor(FormatTokenStream tokenStream, TokenSequence<? extends JsTokenId> ts, int formatFinish) {
        this.tokenUtils = new TokenUtils(ts, tokenStream, formatFinish);
        for (FormatToken token : tokenStream) {
            FormatToken next;
            if (token.getKind() != FormatToken.Kind.WHITESPACE) continue;
            LinkedList<FormatToken> newTokens = new LinkedList<FormatToken>(){

                @Override
                public boolean add(FormatToken token) {
                    FormatToken last;
                    FormatToken formatToken = last = this.isEmpty() ? null : (FormatToken)this.getLast();
                    if (last != null) {
                        last.setNext(token);
                        token.setPrevious(last);
                    }
                    return super.add(token);
                }
            };
            int start = 0;
            for (int i = 0; i < token.getText().length(); ++i) {
                if (token.getText().charAt(i) != '\n') continue;
                if (start > 0) {
                    newTokens.add(FormatToken.forAny(FormatToken.Kind.WHITESPACE, token.getOffset() + start, token.getText().subSequence(start, i), JsTokenId.WHITESPACE));
                }
                newTokens.add(FormatToken.forAny(FormatToken.Kind.EOL, token.getOffset() + i, token.getText().subSequence(start, i + 1), JsTokenId.EOL));
                start = i + 1;
            }
            if (start > 0) {
                newTokens.add(FormatToken.forAny(FormatToken.Kind.WHITESPACE, token.getOffset() + start, token.getText().subSequence(start, token.getText().length()), JsTokenId.WHITESPACE));
            }
            if (newTokens.isEmpty()) continue;
            FormatToken previous = token.previous();
            if (previous != null) {
                previous.setNext((FormatToken)newTokens.getFirst());
                ((FormatToken)newTokens.getFirst()).setPrevious(previous);
            }
            if ((next = token.next()) == null) continue;
            next.setPrevious((FormatToken)newTokens.getLast());
            ((FormatToken)newTokens.getLast()).setNext(next);
        }
    }

    public Void visitObject(JsonParser.ObjectContext ctx) {
        FormatToken formatToken = this.tokenUtils.getPreviousToken(this.getStart((ParserRuleContext)ctx), JsTokenId.BRACKET_LEFT_CURLY, true);
        if (formatToken != null) {
            TokenUtils.appendTokenAfterLastVirtual(formatToken, FormatToken.forFormat(FormatToken.Kind.INDENTATION_INC));
            TokenUtils.appendTokenAfterLastVirtual(formatToken, FormatToken.forFormat(FormatToken.Kind.AFTER_LEFT_BRACE));
            TokenUtils.appendTokenAfterLastVirtual(formatToken, FormatToken.forFormat(FormatToken.Kind.AFTER_OBJECT_START));
            FormatToken previous = formatToken.previous();
            if (previous != null) {
                TokenUtils.appendToken(previous, FormatToken.forFormat(FormatToken.Kind.BEFORE_OBJECT));
            }
        }
        int objectFinish = this.getFinish((ParserRuleContext)ctx);
        ctx.pair().stream().forEach(pair -> {
            FormatToken nextToken = this.tokenUtils.getNextToken(this.getFinish((ParserRuleContext)pair), JsTokenId.OPERATOR_COMMA, objectFinish);
            if (nextToken != null) {
                TokenUtils.appendTokenAfterLastVirtual(nextToken, FormatToken.forFormat(FormatToken.Kind.AFTER_PROPERTY), true);
            }
        });
        formatToken = this.tokenUtils.getPreviousNonWhiteToken(this.getFinish((ParserRuleContext)ctx), this.getStart((ParserRuleContext)ctx), JsTokenId.BRACKET_RIGHT_CURLY, true);
        if (formatToken != null) {
            TokenUtils.appendTokenAfterLastVirtual(formatToken, FormatToken.forFormat(FormatToken.Kind.BEFORE_OBJECT_END));
            TokenUtils.appendTokenAfterLastVirtual(formatToken, FormatToken.forFormat(FormatToken.Kind.BEFORE_RIGHT_BRACE));
            TokenUtils.appendTokenAfterLastVirtual(formatToken, FormatToken.forFormat(FormatToken.Kind.INDENTATION_DEC));
        }
        return (Void)super.visitObject(ctx);
    }

    public Void visitPair(JsonParser.PairContext ctx) {
        FormatToken colon = this.tokenUtils.getNextToken(this.getFinish((ParserRuleContext)ctx.key()), JsTokenId.OPERATOR_COLON, this.getFinish((ParserRuleContext)ctx));
        if (colon != null) {
            TokenUtils.appendToken(colon, FormatToken.forFormat(FormatToken.Kind.AFTER_PROPERTY_OPERATOR));
            FormatToken before = colon.previous();
            if (before != null) {
                TokenUtils.appendTokenAfterLastVirtual(before, FormatToken.forFormat(FormatToken.Kind.BEFORE_PROPERTY_OPERATOR));
            }
        }
        return (Void)super.visitPair(ctx);
    }

    public Void visitArray(JsonParser.ArrayContext ctx) {
        List items;
        int finish;
        int start = this.getStart((ParserRuleContext)ctx);
        FormatToken leftBracket = this.tokenUtils.getNextToken(start, JsTokenId.BRACKET_LEFT_BRACKET, finish = this.getFinish((ParserRuleContext)ctx));
        if (leftBracket != null) {
            FormatToken previous;
            if (leftBracket.previous() != null) {
                TokenUtils.appendToken(leftBracket.previous(), FormatToken.forFormat(FormatToken.Kind.BEFORE_ARRAY));
            }
            TokenUtils.appendToken(leftBracket, FormatToken.forFormat(FormatToken.Kind.AFTER_ARRAY_LITERAL_START));
            TokenUtils.appendToken(leftBracket, FormatToken.forFormat(FormatToken.Kind.AFTER_ARRAY_LITERAL_BRACKET));
            TokenUtils.appendToken(leftBracket, FormatToken.forFormat(FormatToken.Kind.INDENTATION_INC));
            FormatToken rightBracket = this.tokenUtils.getPreviousToken(finish, JsTokenId.BRACKET_RIGHT_BRACKET, start + 1);
            if (rightBracket != null && (previous = rightBracket.previous()) != null) {
                TokenUtils.appendToken(previous, FormatToken.forFormat(FormatToken.Kind.BEFORE_ARRAY_LITERAL_END));
                TokenUtils.appendToken(previous, FormatToken.forFormat(FormatToken.Kind.BEFORE_ARRAY_LITERAL_BRACKET));
                TokenUtils.appendToken(previous, FormatToken.forFormat(FormatToken.Kind.INDENTATION_DEC));
            }
        }
        if ((items = ctx.value()) != null && !items.isEmpty()) {
            int prevItemFinish = start;
            for (int i = 1; i < items.size(); ++i) {
                FormatToken comma;
                JsonParser.ValueContext prevItem = (JsonParser.ValueContext)items.get(i - 1);
                if (prevItem != null) {
                    prevItemFinish = this.getFinish((ParserRuleContext)prevItem);
                }
                if ((comma = this.tokenUtils.getNextToken(prevItemFinish, JsTokenId.OPERATOR_COMMA, finish)) == null) continue;
                prevItemFinish = comma.getOffset();
                TokenUtils.appendTokenAfterLastVirtual(comma, FormatToken.forFormat(FormatToken.Kind.AFTER_ARRAY_LITERAL_ITEM));
            }
        }
        return (Void)super.visitArray(ctx);
    }

    private int getStart(ParserRuleContext ctx) {
        return ctx.getStart().getStartIndex();
    }

    private int getFinish(ParserRuleContext ctx) {
        return ctx.getStop().getStopIndex();
    }
}

