/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript2.editor.doc;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.swing.ImageIcon;
import org.netbeans.modules.csl.api.CompletionProposal;
import org.netbeans.modules.csl.api.ElementHandle;
import org.netbeans.modules.csl.api.ElementKind;
import org.netbeans.modules.csl.api.HtmlFormatter;
import org.netbeans.modules.csl.api.Modifier;
import org.netbeans.modules.javascript2.doc.api.JsDocumentationSupport;
import org.netbeans.modules.javascript2.doc.spi.AnnotationCompletionTag;
import org.netbeans.modules.javascript2.doc.spi.AnnotationCompletionTagProvider;
import org.netbeans.modules.javascript2.doc.spi.JsDocumentationProvider;
import org.netbeans.modules.javascript2.doc.spi.ParameterFormat;
import org.netbeans.modules.javascript2.editor.JsCompletionItem;
import org.netbeans.modules.javascript2.editor.doc.JsDocumentationElement;
import org.netbeans.modules.javascript2.types.spi.ParserResult;
import org.openide.util.ImageUtilities;

public class JsDocumentationCodeCompletion {
    private static final String TAG_PREFIX = "@";

    public static void complete(JsCompletionItem.CompletionRequest request, List<CompletionProposal> resultList) {
        int originalOffset = request.info.getSnapshot().getOriginalOffset(request.anchor);
        if (request.prefix != null && request.prefix.startsWith(TAG_PREFIX)) {
            JsDocumentationCodeCompletion.completeAnnotation(request, resultList, originalOffset);
        } else {
            CharSequence text = request.info.getSnapshot().getText();
            if (TAG_PREFIX.charAt(0) == text.charAt(request.anchor - 1)) {
                request.prefix = request.prefix == null ? TAG_PREFIX : TAG_PREFIX + request.prefix;
                JsDocumentationCodeCompletion.completeAnnotation(request, resultList, originalOffset - 1);
            }
        }
    }

    private static void completeAnnotation(JsCompletionItem.CompletionRequest request, List<CompletionProposal> resultList, int anchor) {
        JsDocumentationProvider documentationProvider = JsDocumentationSupport.getDocumentationProvider((ParserResult)request.result);
        int orderingBase = 0;
        for (AnnotationCompletionTagProvider provider : documentationProvider.getAnnotationsProvider()) {
            ++orderingBase;
            for (AnnotationCompletionTag tag : provider.getAnnotations()) {
                if (!tag.getName().startsWith(request.prefix)) continue;
                resultList.add(new JsDocumentationCodeCompletionItem(anchor, tag, provider.getName(), orderingBase));
            }
        }
    }

    public static class JsDocumentationCodeCompletionItem
    implements CompletionProposal {
        private static final String ANNOTATION_ICON = "org/netbeans/modules/csl/source/resources/icons/annotation.png";
        private static final ImageIcon IMAGE_ICON = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/csl/source/resources/icons/annotation.png", (boolean)false);
        private final AnnotationCompletionTag tag;
        private final int anchorOffset;
        private final JsDocumentationElement elem;
        private final String providerName;
        private final int priority;

        public JsDocumentationCodeCompletionItem(int anchorOffset, AnnotationCompletionTag tag, String providerName, int priority) {
            this.tag = tag;
            this.anchorOffset = anchorOffset;
            this.providerName = providerName;
            this.priority = priority;
            this.elem = new JsDocumentationElement(tag.getName(), tag.getDocumentation());
        }

        public int getAnchorOffset() {
            return this.anchorOffset;
        }

        public ElementHandle getElement() {
            return this.elem;
        }

        public String getName() {
            return this.tag.getName();
        }

        public String getInsertPrefix() {
            return this.getName();
        }

        public String getSortText() {
            return this.priority + this.providerName + this.getName();
        }

        public int getSortPrioOverride() {
            return 0;
        }

        public String getLhsHtml(HtmlFormatter formatter) {
            formatter.name(this.getKind(), true);
            formatter.appendText(this.getName());
            formatter.name(this.getKind(), false);
            List formats = this.tag.getParameters();
            if (formats != null) {
                for (ParameterFormat f : formats) {
                    String pre = f.getPre();
                    if (pre != null) {
                        formatter.appendText(pre);
                    }
                    formatter.parameters(true);
                    formatter.appendText(f.getParam());
                    formatter.parameters(false);
                    String post = f.getPost();
                    if (post == null) continue;
                    formatter.appendText(post);
                }
            }
            return formatter.getText();
        }

        public String getRhsHtml(HtmlFormatter formatter) {
            return this.providerName;
        }

        public ElementKind getKind() {
            return this.elem.getKind();
        }

        public ImageIcon getIcon() {
            return IMAGE_ICON;
        }

        public Set<Modifier> getModifiers() {
            return Collections.emptySet();
        }

        public boolean isSmart() {
            return false;
        }

        public String getCustomInsertTemplate() {
            return this.tag.getInsertTemplate();
        }
    }
}

