/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript2.editor;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.ImageIcon;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.lexer.Language;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.csl.api.CodeCompletionContext;
import org.netbeans.modules.csl.api.CompletionProposal;
import org.netbeans.modules.csl.api.ElementHandle;
import org.netbeans.modules.csl.api.ElementKind;
import org.netbeans.modules.csl.api.HtmlFormatter;
import org.netbeans.modules.csl.api.Modifier;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.csl.spi.support.CancelSupport;
import org.netbeans.modules.javascript2.editor.Bundle;
import org.netbeans.modules.javascript2.editor.JsKeywords;
import org.netbeans.modules.javascript2.editor.JsVersion;
import org.netbeans.modules.javascript2.editor.Utils;
import org.netbeans.modules.javascript2.editor.options.OptionsUtils;
import org.netbeans.modules.javascript2.editor.parser.JsParserResult;
import org.netbeans.modules.javascript2.editor.spi.CompletionContext;
import org.netbeans.modules.javascript2.editor.spi.ElementDocumentation;
import org.netbeans.modules.javascript2.editor.spi.ProposalRequest;
import org.netbeans.modules.javascript2.lexer.api.JsTokenId;
import org.netbeans.modules.javascript2.lexer.api.LexUtilities;
import org.netbeans.modules.javascript2.model.api.Index;
import org.netbeans.modules.javascript2.model.api.IndexedElement;
import org.netbeans.modules.javascript2.model.api.JsElement;
import org.netbeans.modules.javascript2.model.api.JsFunction;
import org.netbeans.modules.javascript2.model.api.JsObject;
import org.netbeans.modules.javascript2.model.api.Model;
import org.netbeans.modules.javascript2.model.api.ModelUtils;
import org.netbeans.modules.javascript2.types.api.Type;
import org.netbeans.modules.javascript2.types.api.TypeUsage;
import org.netbeans.modules.parsing.api.Snapshot;
import org.openide.filesystems.FileObject;
import org.openide.util.ImageUtilities;

public class JsCompletionItem
implements CompletionProposal {
    protected final CompletionRequest request;
    protected final ElementHandle element;
    private static ImageIcon priviligedIcon = null;
    private static ImageIcon publicGenerator = null;
    private static ImageIcon privateGenerator = null;
    private static ImageIcon priviligedGenerator = null;

    protected JsCompletionItem(ElementHandle element, CompletionRequest request) {
        this.element = element;
        this.request = request;
    }

    public int getAnchorOffset() {
        return LexUtilities.getLexerOffset((ParserResult)((JsParserResult)this.request.info), (int)this.request.anchor);
    }

    public ElementHandle getElement() {
        return this.element;
    }

    public String getName() {
        return this.element.getName();
    }

    public String getInsertPrefix() {
        return this.element.getName();
    }

    public String getSortText() {
        StringBuilder sb = new StringBuilder();
        if (this.element != null) {
            FileObject sourceFo = this.request.result.getSnapshot().getSource().getFileObject();
            FileObject elementFo = this.element.getFileObject();
            if (elementFo != null && sourceFo != null && sourceFo.equals(elementFo)) {
                sb.append("1");
            } else if (OffsetRange.NONE.equals((Object)this.element.getOffsetRange((ParserResult)this.request.result))) {
                sb.append("8");
            } else {
                sb.append("9");
            }
        }
        sb.append(this.getName());
        return sb.toString();
    }

    protected boolean isDeprecated() {
        return this.element.getModifiers().contains(Modifier.DEPRECATED);
    }

    public String getLhsHtml(HtmlFormatter formatter) {
        this.formatName(formatter);
        return formatter.getText();
    }

    protected void formatName(HtmlFormatter formatter) {
        if (this.isDeprecated()) {
            formatter.deprecated(true);
            formatter.appendText(this.getName());
            formatter.deprecated(false);
        } else {
            formatter.appendText(this.getName());
        }
    }

    public String getRhsHtml(HtmlFormatter formatter) {
        String location = null;
        if (this.element instanceof JsElement) {
            JsElement jsElement = (JsElement)this.element;
            if (jsElement.isPlatform()) {
                location = Bundle.JsCompletionItem_lbl_js_platform();
            } else if (jsElement.getSourceLabel() != null) {
                location = jsElement.getSourceLabel();
            }
        }
        if (location == null) {
            location = this.getFileNameURL();
        }
        if (location == null) {
            return null;
        }
        formatter.reset();
        boolean isgues = OffsetRange.NONE.equals((Object)this.element.getOffsetRange((ParserResult)this.request.result));
        if (isgues) {
            formatter.appendHtml("<font color=#999999>");
        }
        formatter.appendText(location);
        if (isgues) {
            formatter.appendHtml("</font>");
        }
        return formatter.getText();
    }

    public ElementKind getKind() {
        return this.element.getKind();
    }

    public ImageIcon getIcon() {
        return null;
    }

    public Set<Modifier> getModifiers() {
        EnumSet<Modifier> modifiers;
        if (this.getElement() == null || this.getElement().getModifiers().isEmpty()) {
            modifiers = Collections.EMPTY_SET;
        } else {
            modifiers = EnumSet.noneOf(Modifier.class);
            modifiers.addAll(this.getElement().getModifiers());
        }
        if (modifiers.contains(Modifier.PRIVATE) && (modifiers.contains(Modifier.PUBLIC) || modifiers.contains(Modifier.PROTECTED))) {
            modifiers.remove(Modifier.PUBLIC);
            modifiers.remove(Modifier.PROTECTED);
        }
        return modifiers;
    }

    public boolean isSmart() {
        return false;
    }

    public int getSortPrioOverride() {
        int order = 100;
        if (this.element instanceof JsElement) {
            if (((JsElement)this.element).isPlatform()) {
                order = "prototype".equals(this.element.getName()) ? 1 : 0;
            }
            if (OffsetRange.NONE.equals((Object)this.element.getOffsetRange((ParserResult)this.request.result))) {
                order = 120;
            }
        }
        return order;
    }

    public String getCustomInsertTemplate() {
        return null;
    }

    @CheckForNull
    public final String getFileNameURL() {
        ElementHandle elem = this.getElement();
        if (elem == null) {
            return null;
        }
        FileObject fo = elem.getFileObject();
        if (fo != null) {
            return fo.getNameExt();
        }
        return this.getName();
    }

    public static ProposalRequest createRequest(CodeCompletionContext ccContext, CompletionContext jsCompletionContext, String prefix) {
        int caretOffset = ccContext.getParserResult().getSnapshot().getEmbeddedOffset(ccContext.getCaretOffset());
        String pref = ccContext.getPrefix();
        int offset = pref == null ? caretOffset : caretOffset - pref.length();
        return new ProposalRequest(ccContext, jsCompletionContext, null, offset);
    }

    public static class CompletionRequest {
        public int anchor;
        public JsParserResult result;
        public ParserResult info;
        public String prefix;
        public CompletionContext completionContext;
        public boolean addHtmlTagAttributes;
        public CancelSupport cancelSupport;
        public Collection<String> fqnTypes = new LinkedHashSet<String>();
    }

    public static abstract class SimpleDocElement
    implements ElementHandle,
    ElementDocumentation {
        private final String name;
        private final ElementKind kind;

        public SimpleDocElement(String name, ElementKind kind) {
            this.name = name;
            this.kind = kind;
        }

        public FileObject getFileObject() {
            return null;
        }

        public String getMimeType() {
            return "";
        }

        public String getName() {
            return this.name;
        }

        public String getIn() {
            return "";
        }

        public ElementKind getKind() {
            return this.kind;
        }

        public Set<Modifier> getModifiers() {
            return Collections.emptySet();
        }

        public boolean signatureEquals(ElementHandle handle) {
            return false;
        }

        public OffsetRange getOffsetRange(ParserResult result) {
            return OffsetRange.NONE;
        }
    }

    public static class Factory {
        public static void create(Map<String, List<JsElement>> items, CompletionRequest request, List<CompletionProposal> result) {
            CancelSupport cancelSupport = request.cancelSupport;
            if (cancelSupport.isCancelled()) {
                return;
            }
            HashMap resolvedTypes = new HashMap();
            for (Map.Entry<String, List<JsElement>> entry : items.entrySet()) {
                HashMap<Object, JsCompletionItem> signatures = new HashMap<Object, JsCompletionItem>();
                Index jsIndex = null;
                if (OptionsUtils.forLanguage((Language<JsTokenId>)JsTokenId.javascriptLanguage()).autoCompletionTypeResolution()) {
                    jsIndex = Index.get((FileObject)request.info.getSnapshot().getSource().getFileObject());
                }
                block5: for (JsElement element : entry.getValue()) {
                    JsCompletionItem item;
                    Object signature;
                    if (cancelSupport.isCancelled()) {
                        return;
                    }
                    switch (element.getJSKind()) {
                        case CONSTRUCTOR: 
                        case FUNCTION: 
                        case METHOD: 
                        case GENERATOR: 
                        case ARROW_FUNCTION: {
                            Set<String> resolvedType;
                            HashSet<String> returnTypes = new HashSet<String>();
                            LinkedHashMap<String, Set<String>> allParameters = new LinkedHashMap<String, Set<String>>();
                            if (element instanceof JsFunction) {
                                Collection resolveTypes = ModelUtils.resolveTypes((Collection)((JsFunction)element).getReturnTypes(), (Model)Model.getModel((ParserResult)request.info, (boolean)false), (Index)jsIndex, (boolean)false);
                                returnTypes.addAll(Utils.getDisplayNames(resolveTypes));
                                for (JsObject jsObject : ((JsFunction)element).getParameters()) {
                                    HashSet paramTypes = new HashSet();
                                    for (TypeUsage type : jsObject.getAssignmentForOffset(jsObject.getOffset() + 1)) {
                                        resolvedType = (Set)resolvedTypes.get(type.getType());
                                        if (resolvedType == null) {
                                            resolvedType = new HashSet<String>(1);
                                            String displayName = ModelUtils.getDisplayName((Type)type);
                                            if (!displayName.isEmpty()) {
                                                resolvedType.add(displayName);
                                            }
                                            resolvedTypes.put(type.getType(), resolvedType);
                                        }
                                        paramTypes.addAll(resolvedType);
                                    }
                                    allParameters.put(jsObject.getName(), paramTypes);
                                }
                            } else if (element instanceof IndexedElement.FunctionIndexedElement) {
                                HashSet<TypeUsage> returnTypeUsages = new HashSet<TypeUsage>();
                                for (String type : ((IndexedElement.FunctionIndexedElement)element).getReturnTypes()) {
                                    returnTypeUsages.add(new TypeUsage(type, -1, false));
                                }
                                Collection resolveTypes = ModelUtils.resolveTypes(returnTypeUsages, (Model)Model.getModel((ParserResult)request.info, (boolean)false), (Index)jsIndex, (boolean)false);
                                returnTypes.addAll(Utils.getDisplayNames(resolveTypes));
                                LinkedHashMap parameters = ((IndexedElement.FunctionIndexedElement)element).getParameters();
                                for (Map.Entry entry2 : parameters.entrySet()) {
                                    HashSet paramTypes = new HashSet();
                                    for (String type : (Collection)entry2.getValue()) {
                                        HashSet<String> resolvedType2 = (HashSet<String>)resolvedTypes.get(type);
                                        if (resolvedType2 == null) {
                                            resolvedType2 = new HashSet<String>(1);
                                            String displayName = ModelUtils.getDisplayName((String)type);
                                            if (!displayName.isEmpty()) {
                                                resolvedType2.add(displayName);
                                            }
                                            resolvedTypes.put(type, resolvedType2);
                                        }
                                        paramTypes.addAll(resolvedType2);
                                    }
                                    allParameters.put((String)entry2.getKey(), paramTypes);
                                }
                            }
                            if (signatures.containsKey(signature = Factory.createFnSignature(entry.getKey(), allParameters, returnTypes))) continue block5;
                            JsFunctionCompletionItem item2 = element.getJSKind() != JsElement.Kind.GENERATOR ? new JsFunctionCompletionItem((ElementHandle)element, request, returnTypes, allParameters) : new JsGeneratorCompletionItem((ElementHandle)element, request, returnTypes, allParameters);
                            signatures.put(signature, item2);
                            continue block5;
                        }
                        case PARAMETER: 
                        case PROPERTY: 
                        case PROPERTY_GETTER: 
                        case PROPERTY_SETTER: 
                        case FIELD: 
                        case VARIABLE: {
                            Set<String> resolvedType;
                            HashSet<String> typesToDisplay = new HashSet<String>();
                            Collection assignment = null;
                            if (element instanceof JsObject) {
                                JsObject jsObject = (JsObject)element;
                                assignment = jsObject.getAssignments();
                            } else if (element instanceof IndexedElement) {
                                IndexedElement iElement = (IndexedElement)element;
                                assignment = iElement.getAssignments();
                            }
                            if (assignment != null && !assignment.isEmpty()) {
                                HashSet<TypeUsage> toResolve = new HashSet<TypeUsage>();
                                for (TypeUsage type : assignment) {
                                    if (type.isResolved()) {
                                        if ("undefined".equals(type.getType())) continue;
                                        typesToDisplay.add(ModelUtils.getDisplayName((Type)type));
                                        continue;
                                    }
                                    resolvedType = (HashSet)resolvedTypes.get(type.getType());
                                    if (resolvedType == null) {
                                        toResolve.clear();
                                        toResolve.add(type);
                                        resolvedType = new HashSet(1);
                                        Collection resolved = ModelUtils.resolveTypes(toResolve, (Model)Model.getModel((ParserResult)request.result, (boolean)false), (Index)jsIndex, (boolean)false);
                                        for (TypeUsage rType : resolved) {
                                            String displayName = ModelUtils.getDisplayName((Type)rType);
                                            if (displayName.isEmpty()) continue;
                                            resolvedType.add(displayName);
                                        }
                                        resolvedTypes.put(type.getType(), resolvedType);
                                    }
                                    typesToDisplay.addAll((Collection<String>)resolvedType);
                                }
                            }
                            if (signatures.containsKey(signature = element.getName() + ":" + Factory.createTypeSignature(typesToDisplay))) continue block5;
                            item = new JsPropertyCompletionItem((ElementHandle)element, request, typesToDisplay);
                            signatures.put(signature, item);
                            continue block5;
                        }
                    }
                    signature = element.getName();
                    if (signatures.containsKey(signature)) continue;
                    item = new JsCompletionItem((ElementHandle)element, request);
                    signatures.put(signature, item);
                }
                for (JsCompletionItem item : signatures.values()) {
                    result.add(item);
                }
            }
        }

        private static String createFnSignature(String name, HashMap<String, Set<String>> params, Set<String> returnTypes) {
            StringBuilder sb = new StringBuilder();
            sb.append(name).append('(');
            for (Map.Entry<String, Set<String>> entry : params.entrySet()) {
                sb.append(entry.getKey()).append(':');
                sb.append(Factory.createTypeSignature(entry.getValue()));
                sb.append(',');
            }
            sb.append(')');
            sb.append(Factory.createTypeSignature(returnTypes));
            return sb.toString();
        }

        private static String createTypeSignature(Set<String> types) {
            StringBuilder sb = new StringBuilder();
            for (String name : types) {
                sb.append(name).append('|');
            }
            return sb.toString();
        }
    }

    public static class JsPropertyCompletionItem
    extends JsCompletionItem {
        private final Set<String> resolvedTypes;

        JsPropertyCompletionItem(ElementHandle element, CompletionRequest request, Set<String> resolvedTypes) {
            super(element, request);
            this.resolvedTypes = resolvedTypes != null ? resolvedTypes : Collections.EMPTY_SET;
        }

        @Override
        public String getLhsHtml(HtmlFormatter formatter) {
            this.formatName(formatter);
            if (!this.resolvedTypes.isEmpty()) {
                formatter.type(true);
                formatter.appendText(": ");
                Iterator<String> it = this.resolvedTypes.iterator();
                while (it.hasNext()) {
                    formatter.appendText(it.next());
                    if (!it.hasNext()) continue;
                    formatter.appendText("|");
                }
                formatter.type(false);
            }
            return formatter.getText();
        }

        @Override
        public String getCustomInsertTemplate() {
            if (this.request.completionContext == CompletionContext.OBJECT_PROPERTY_NAME) {
                return this.getName() + ": ${cursor}";
            }
            return super.getCustomInsertTemplate();
        }
    }

    static class KeywordItem
    extends JsCompletionItem {
        private static ImageIcon keywordIcon = null;
        private final String keyword;
        private final JsKeywords.CompletionDescription description;

        public KeywordItem(String keyword, JsKeywords.CompletionDescription description, CompletionRequest request) {
            super(null, request);
            this.keyword = keyword;
            this.description = description;
        }

        @Override
        public String getName() {
            return this.keyword;
        }

        @Override
        public String getLhsHtml(HtmlFormatter formatter) {
            formatter.name(this.getKind(), true);
            formatter.appendText(this.getName());
            formatter.name(this.getKind(), false);
            return formatter.getText();
        }

        @Override
        public ElementKind getKind() {
            return ElementKind.KEYWORD;
        }

        @Override
        public String getRhsHtml(HtmlFormatter formatter) {
            JsVersion since = this.description.getVersion();
            if (since != null) {
                formatter.appendText(since.getDisplayName());
                return formatter.getText();
            }
            return null;
        }

        @Override
        public ImageIcon getIcon() {
            if (keywordIcon == null) {
                keywordIcon = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/javascript2/editor/resources/javascript.png", (boolean)false);
            }
            return keywordIcon;
        }

        @Override
        public String getInsertPrefix() {
            return this.getName();
        }

        @Override
        public String getCustomInsertTemplate() {
            StringBuilder builder = new StringBuilder();
            JsKeywords.CompletionType type = this.description.getType();
            if (type == null) {
                return this.getName();
            }
            switch (type) {
                case SIMPLE: {
                    builder.append(this.getName());
                    break;
                }
                case ENDS_WITH_SPACE: {
                    builder.append(this.getName());
                    builder.append(" ${cursor}");
                    break;
                }
                case CURSOR_INSIDE_BRACKETS: {
                    builder.append(this.getName());
                    builder.append("(${cursor})");
                    break;
                }
                case ENDS_WITH_CURLY_BRACKETS: {
                    builder.append(this.getName());
                    builder.append(" {${cursor}}");
                    break;
                }
                case ENDS_WITH_SEMICOLON: {
                    builder.append(this.getName());
                    CharSequence text = this.request.info.getSnapshot().getText();
                    int index = this.request.anchor + this.request.prefix.length();
                    if (index != text.length() && ';' == text.charAt(index)) break;
                    builder.append(";");
                    break;
                }
                case ENDS_WITH_COLON: {
                    builder.append(this.getName());
                    builder.append(" ${cursor}:");
                    break;
                }
                case ENDS_WITH_DOT: {
                    builder.append(this.getName());
                    builder.append(".${cursor}");
                    break;
                }
                default: {
                    assert (false) : type.toString();
                    break;
                }
            }
            return builder.toString();
        }

        @Override
        public int getSortPrioOverride() {
            return 130;
        }
    }

    public static class JsCallbackCompletionItem
    extends JsCompletionItem {
        private static ImageIcon callbackIcon = null;
        private IndexedElement.FunctionIndexedElement function;

        public JsCallbackCompletionItem(IndexedElement.FunctionIndexedElement element, CompletionRequest request) {
            super((ElementHandle)element, request);
            this.function = element;
        }

        @Override
        public ImageIcon getIcon() {
            if (callbackIcon == null) {
                callbackIcon = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/javascript2/editor/resources/methodCallback.png", (boolean)false);
            }
            return callbackIcon;
        }

        @Override
        public String getLhsHtml(HtmlFormatter formatter) {
            formatter.setMaxLength(OptionsUtils.forLanguage((Language<JsTokenId>)JsTokenId.javascriptLanguage()).getCodeCompletionItemSignatureWidth());
            formatter.name(ElementKind.KEYWORD, true);
            formatter.appendText("function");
            formatter.name(ElementKind.KEYWORD, false);
            formatter.appendText(" (");
            this.appendParamsStr(formatter);
            formatter.appendText(")");
            return formatter.getText();
        }

        @Override
        public int getSortPrioOverride() {
            return 90;
        }

        private void appendParamsStr(HtmlFormatter formatter) {
            Iterator it = this.function.getParameters().entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                formatter.parameters(true);
                formatter.appendText((String)entry.getKey());
                formatter.parameters(false);
                Collection types = (Collection)entry.getValue();
                if (!types.isEmpty()) {
                    formatter.type(true);
                    formatter.appendText(": ");
                    Iterator itTypes = types.iterator();
                    while (itTypes.hasNext()) {
                        formatter.appendText((String)itTypes.next());
                        if (!itTypes.hasNext()) continue;
                        formatter.appendText("|");
                    }
                    formatter.type(false);
                }
                if (!it.hasNext()) continue;
                formatter.appendText(", ");
            }
        }

        @Override
        public String getCustomInsertTemplate() {
            StringBuilder template = new StringBuilder();
            template.append(" \n /** ");
            for (Map.Entry entry : this.function.getParameters().entrySet()) {
                Collection types = (Collection)entry.getValue();
                template.append("\n * @param {");
                if (!types.isEmpty()) {
                    Iterator itTypes = types.iterator();
                    while (itTypes.hasNext()) {
                        template.append((String)itTypes.next());
                        if (!itTypes.hasNext()) continue;
                        template.append("|");
                    }
                } else {
                    template.append("Object");
                }
                template.append("} ");
                template.append((String)entry.getKey());
            }
            template.append("\n */");
            template.append("\nfunction (");
            Iterator it = this.function.getParameters().entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry;
                entry = it.next();
                template.append((String)entry.getKey());
                if (!it.hasNext()) continue;
                template.append(", ");
            }
            template.append(") {\n ${cursor}\n}");
            return template.toString();
        }

        @Override
        public String getName() {
            return "function";
        }
    }

    public static class JsGeneratorCompletionItem
    extends JsFunctionCompletionItem {
        public JsGeneratorCompletionItem(ElementHandle element, CompletionRequest request, Set<String> resolvedReturnTypes, Map<String, Set<String>> parametersTypes) {
            super(element, request, resolvedReturnTypes, parametersTypes);
        }

        @Override
        public ImageIcon getIcon() {
            if (this.getModifiers().contains(Modifier.PUBLIC)) {
                if (publicGenerator == null) {
                    publicGenerator = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/javascript2/editor/resources/generatorPublic.png", (boolean)false);
                }
                return publicGenerator;
            }
            if (this.getModifiers().contains(Modifier.PRIVATE)) {
                if (privateGenerator == null) {
                    privateGenerator = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/javascript2/editor/resources/generatorPrivate.png", (boolean)false);
                }
                return privateGenerator;
            }
            if (this.getModifiers().contains(Modifier.PROTECTED)) {
                if (priviligedGenerator == null) {
                    priviligedGenerator = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/javascript2/editor/resources/generatorPriviliged.png", (boolean)false);
                }
                return priviligedGenerator;
            }
            return super.getIcon();
        }
    }

    public static class JsFunctionCompletionItem
    extends JsCompletionItem {
        private final Set<String> returnTypes;
        private final Map<String, Set<String>> parametersTypes;

        JsFunctionCompletionItem(ElementHandle element, CompletionRequest request, Set<String> resolvedReturnTypes, Map<String, Set<String>> parametersTypes) {
            super(element, request);
            this.returnTypes = resolvedReturnTypes != null ? resolvedReturnTypes : Collections.EMPTY_SET;
            this.parametersTypes = parametersTypes != null ? parametersTypes : Collections.emptyMap();
        }

        @Override
        public String getLhsHtml(HtmlFormatter formatter) {
            formatter.setMaxLength(OptionsUtils.forLanguage((Language<JsTokenId>)JsTokenId.javascriptLanguage()).getCodeCompletionItemSignatureWidth());
            formatter.emphasis(true);
            this.formatName(formatter);
            formatter.emphasis(false);
            if (!this.asObject()) {
                formatter.appendText("(");
                this.appendParamsStr(formatter);
                formatter.appendText(")");
                this.appendReturnTypes(formatter);
            }
            return formatter.getText();
        }

        private void appendParamsStr(HtmlFormatter formatter) {
            Iterator<Map.Entry<String, Set<String>>> it = this.parametersTypes.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<String, Set<String>> entry = it.next();
                formatter.parameters(true);
                formatter.appendText(entry.getKey());
                formatter.parameters(false);
                Collection types = entry.getValue();
                if (!types.isEmpty()) {
                    formatter.type(true);
                    formatter.appendText(": ");
                    Iterator itTypes = types.iterator();
                    while (itTypes.hasNext()) {
                        formatter.appendText((String)itTypes.next());
                        if (!itTypes.hasNext()) continue;
                        formatter.appendText("|");
                    }
                    formatter.type(false);
                }
                if (!it.hasNext()) continue;
                formatter.appendText(", ");
            }
        }

        private void appendReturnTypes(HtmlFormatter formatter) {
            if (!this.returnTypes.isEmpty()) {
                formatter.appendText(": ");
                formatter.type(true);
                Iterator<String> it = this.returnTypes.iterator();
                while (it.hasNext()) {
                    formatter.appendText(it.next());
                    if (!it.hasNext()) continue;
                    formatter.appendText("|");
                }
                formatter.type(false);
            }
        }

        @Override
        public String getCustomInsertTemplate() {
            StringBuilder template = new StringBuilder();
            template.append(this.getName());
            if (!this.asObject()) {
                if (this.parametersTypes.isEmpty()) {
                    template.append("()${cursor}");
                } else {
                    template.append("(${cursor})");
                }
            } else {
                template.append("${cursor}");
            }
            return template.toString();
        }

        @Override
        public ImageIcon getIcon() {
            if (this.getModifiers().contains(Modifier.PROTECTED)) {
                if (priviligedIcon == null) {
                    priviligedIcon = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/javascript2/editor/resources/methodPriviliged.png", (boolean)false);
                }
                return priviligedIcon;
            }
            return super.getIcon();
        }

        private boolean isAfterNewKeyword() {
            int offset;
            boolean isAfterNew = false;
            Snapshot snapshot = this.request.result.getSnapshot();
            TokenSequence ts = LexUtilities.getJsTokenSequence((Snapshot)snapshot, (int)snapshot.getOriginalOffset(offset = this.request.anchor));
            if (ts != null) {
                Token token;
                ts.move(offset);
                if (ts.moveNext() && (token = LexUtilities.findPrevious((TokenSequence)ts, Arrays.asList(JsTokenId.IDENTIFIER, JsTokenId.PRIVATE_IDENTIFIER, JsTokenId.OPERATOR_DOT, JsTokenId.OPERATOR_OPTIONAL_ACCESS, JsTokenId.BLOCK_COMMENT, JsTokenId.WHITESPACE, JsTokenId.LINE_COMMENT, JsTokenId.EOL))).id() == JsTokenId.KEYWORD_NEW) {
                    isAfterNew = true;
                }
            }
            return isAfterNew;
        }

        private boolean asObject() {
            boolean isAfterNew;
            boolean result = false;
            char firstChar = this.getName().charAt(0);
            JsElement.Kind jsKind = null;
            if (this.element instanceof JsElement) {
                jsKind = ((JsElement)this.element).getJSKind();
            }
            if ((jsKind != null && jsKind == JsElement.Kind.CONSTRUCTOR || Character.isUpperCase(firstChar)) && !(isAfterNew = this.isAfterNewKeyword())) {
                String type;
                for (String type2 : this.returnTypes) {
                    if (!type2.endsWith(this.element.getName())) continue;
                    return true;
                }
                if (this.returnTypes.isEmpty()) {
                    result = true;
                } else if (!(this.returnTypes.size() != 1 || !Character.isUpperCase(firstChar = (type = this.returnTypes.iterator().next()).charAt(0)) || "Number".equals(type) || "Boolean".equals(type) || "String".equals(type) || "Array".equals(type))) {
                    result = true;
                }
            }
            return result;
        }
    }
}

