/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.nativeexecution;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.netbeans.modules.nativeexecution.AbstractNativeProcess;
import org.netbeans.modules.nativeexecution.NativeProcessInfo;
import org.netbeans.modules.nativeexecution.ProcessStatusAccessor;
import org.netbeans.modules.nativeexecution.api.HostInfo;
import org.netbeans.modules.nativeexecution.api.NativeProcessBuilder;
import org.netbeans.modules.nativeexecution.api.ProcessStatusEx;
import org.netbeans.modules.nativeexecution.api.pty.Pty;
import org.netbeans.modules.nativeexecution.api.util.MacroMap;
import org.netbeans.modules.nativeexecution.api.util.ProcessUtils;
import org.netbeans.modules.nativeexecution.api.util.Signal;
import org.netbeans.modules.nativeexecution.api.util.UnbufferSupport;
import org.netbeans.modules.nativeexecution.api.util.WindowsSupport;
import org.netbeans.modules.nativeexecution.pty.NbStartUtility;
import org.netbeans.modules.nativeexecution.signals.SignalSupport;
import org.netbeans.modules.nativeexecution.support.Logger;

public abstract class NbNativeProcess
extends AbstractNativeProcess {
    private final String nbStartPath;
    private volatile ProcessStatusEx statusEx;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NbNativeProcess(NativeProcessInfo info) {
        super(new NativeProcessInfo(info, true));
        String _nbStartPath = null;
        try {
            _nbStartPath = NbStartUtility.getInstance().getPath(this.getExecutionEnvironment());
        }
        catch (IOException iOException) {
        }
        finally {
            this.nbStartPath = _nbStartPath;
        }
    }

    @Override
    protected final void create() throws Throwable {
        this.createProcessImpl(this.getCommand());
        this.readProcessInfo(this.getInputStream());
    }

    private List<String> getCommand() {
        MacroMap userEnv;
        String envFile;
        boolean getStatus;
        ArrayList<String> command = new ArrayList<String>();
        command.add(this.nbStartPath);
        String wdir = this.info.getWorkingDirectory(true);
        if (wdir != null && !wdir.isEmpty()) {
            command.add("--dir");
            command.add(this.fixForWindows(wdir));
        }
        if (!this.info.isPtyMode()) {
            command.add("--no-pty");
        } else {
            Pty pty = this.info.getPty();
            if (FIX_ERASE_KEY_IN_TERMINAL.booleanValue()) {
                command.add("--set-erase-key");
            }
            if (pty != null) {
                command.add("-p");
                command.add(pty.getSlaveName());
            }
        }
        if (!this.info.isPtyMode() && this.info.isUnbuffer()) {
            try {
                UnbufferSupport.initUnbuffer(this.info.getExecutionEnvironment(), this.info.getEnvironment());
            }
            catch (IOException ex) {
                Logger.getInstance().log(Level.FINE, "initUnbuffer failed", ex);
            }
        }
        if (this.info.getInitialSuspend()) {
            command.add("-w");
        }
        if (getStatus = this.info.isStatusEx()) {
            command.add("--report");
            command.add(this.hostInfo.getTempDir() + "/status");
        }
        if ((envFile = this.hostInfo.getEnvironmentFile()) != null) {
            command.add("--readenv");
            command.add(envFile);
        }
        if (this.info.isRedirectError()) {
            command.add("--redirect-error");
        }
        if ((userEnv = this.info.getEnvironment()) != null) {
            Map<String, String> userDefinedMap = userEnv.getUserDefinedMap();
            for (Map.Entry<String, String> entry : userDefinedMap.entrySet()) {
                if (this.isWindows() && entry.getKey().equalsIgnoreCase("PATH")) {
                    command.add("--env");
                    command.add(entry.getKey() + "=" + WindowsSupport.getInstance().convertToAllShellPaths(entry.getValue()));
                    continue;
                }
                command.add("--env");
                command.add(entry.getKey() + "=" + entry.getValue());
            }
        }
        if (this.info.isCommandLineDefined()) {
            command.add(this.hostInfo.getShell());
            command.add("-c");
            String origCommand = this.info.getCommandLineForShell();
            command.add("exec " + origCommand);
        } else {
            command.add(this.fixForWindows(this.info.getExecutable()));
            command.addAll(this.info.getArguments());
        }
        return command;
    }

    private void readProcessInfo(InputStream fromProcessStream) throws IOException {
        String line;
        while (!(line = this.readLine(fromProcessStream).trim()).isEmpty()) {
            this.addProcessInfo(line);
        }
        String pidProperty = this.getProcessInfo("PID");
        if (pidProperty == null) {
            InputStream error = this.getErrorStream();
            while (!(line = this.readLine(error).trim()).isEmpty()) {
                LOG.info(line);
            }
            throw new InternalError("Failed to get process PID");
        }
        this.setPID(Integer.parseInt(pidProperty));
    }

    @Override
    protected final int waitResult() throws InterruptedException {
        int result = this.waitResultImpl();
        String reportFile = this.getProcessInfo("REPORT");
        if (reportFile != null) {
            NativeProcessBuilder npb = NativeProcessBuilder.newProcessBuilder(this.info.getExecutionEnvironment());
            npb.setExecutable("/bin/sh");
            npb.setArguments("-c", "cat " + reportFile + " && rm " + reportFile);
            ProcessUtils.ExitStatus st = ProcessUtils.execute(npb);
            if (st.isOK()) {
                this.statusEx = ProcessStatusAccessor.getDefault().create(st.getOutputString().split("\n"));
                result = this.statusEx.getExitCode();
            }
        }
        return result;
    }

    @Override
    public ProcessStatusEx getExitStatusEx() {
        this.exitValue();
        return this.statusEx;
    }

    private String readLine(InputStream is) throws IOException {
        int c;
        StringBuilder sb = new StringBuilder(20);
        while (!this.isInterrupted() && (c = is.read()) >= 0 && c != 10) {
            sb.append((char)c);
        }
        return sb.toString().trim();
    }

    protected abstract int waitResultImpl() throws InterruptedException;

    protected abstract void createProcessImpl(List<String> var1) throws Throwable;

    @Override
    protected int destroyImpl() {
        if (this.destroyed()) {
            return 0;
        }
        String env = this.getProcessInfo("NBMAGIC");
        if (env != null) {
            String magicEnv = "NBMAGIC=" + env;
            SignalSupport.signalProcessesByEnv(this.info.getExecutionEnvironment(), magicEnv, Signal.SIGTERM);
        }
        return 0;
    }

    protected boolean isWindows() {
        return HostInfo.OSFamily.WINDOWS.equals((Object)this.hostInfo.getOSFamily());
    }

    protected String fixForWindows(String path) {
        return this.isWindows() ? WindowsSupport.getInstance().convertToCygwinPath(path) : path;
    }

    private boolean destroyed() {
        try {
            this.exitValue();
            return true;
        }
        catch (IllegalThreadStateException ex) {
            return false;
        }
    }
}

