/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.beans.analysis.analyzer;

import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import org.netbeans.modules.web.beans.analysis.CdiAnalysisResult;
import org.netbeans.modules.web.beans.analysis.analyzer.ElementAnalyzer;
import org.netbeans.modules.web.beans.analysis.analyzer.type.AnnotationsAnalyzer;
import org.netbeans.modules.web.beans.analysis.analyzer.type.CtorsAnalyzer;
import org.netbeans.modules.web.beans.analysis.analyzer.type.TypedClassAnalizer;

public class ClassElementAnalyzer
implements ElementAnalyzer {
    private static final List<ClassAnalyzer> ANALYZERS = new LinkedList<ClassAnalyzer>();

    @Override
    public void analyze(Element element, TypeElement parent, AtomicBoolean cancel, CdiAnalysisResult result) {
        TypeElement subject = (TypeElement)element;
        for (ClassAnalyzer analyzer : ANALYZERS) {
            if (cancel.get()) {
                return;
            }
            analyzer.analyze(subject, parent, cancel, result);
        }
    }

    static {
        ANALYZERS.add(new TypedClassAnalizer());
        ANALYZERS.add(new AnnotationsAnalyzer());
        ANALYZERS.add(new CtorsAnalyzer());
    }

    public static interface ClassAnalyzer {
        public void analyze(TypeElement var1, TypeElement var2, AtomicBoolean var3, CdiAnalysisResult var4);
    }
}

